/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;

@NoExtend
public class ArtifactDescriptor {
    public static final String MULE_ARTIFACT = "mule-artifact";
    public static final String META_INF = "META-INF";
    public static final String MULE_ARTIFACT_JSON_DESCRIPTOR = "mule-artifact.json";
    public static final String MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "mule-artifact.json").toString();
    public static final String MULE_ARTIFACT_FOLDER = Paths.get("META-INF", "mule-artifact").toString();
    private final String name;
    private File rootFolder;
    private ClassLoaderModel classLoaderModel = ClassLoaderModel.NULL_CLASSLOADER_MODEL;
    private BundleDescriptor bundleDescriptor;
    private MuleVersion minMuleVersion;
    private Product requiredProduct;
    private Optional<Properties> deploymentProperties = Optional.empty();

    public ArtifactDescriptor(String name) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"Artifact name cannot be empty");
        this.name = name;
    }

    public ArtifactDescriptor(String name, Optional<Properties> deploymentProperties) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"Artifact name cannot be empty");
        this.name = name;
        this.deploymentProperties = deploymentProperties;
    }

    public String getName() {
        return this.name;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(File rootFolder) {
        if (rootFolder == null) {
            throw new IllegalArgumentException("Root folder cannot be null");
        }
        this.rootFolder = rootFolder;
    }

    public MuleVersion getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public void setMinMuleVersion(MuleVersion minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public ClassLoaderModel getClassLoaderModel() {
        return this.classLoaderModel;
    }

    public void setClassLoaderModel(ClassLoaderModel classLoaderModel) {
        this.classLoaderModel = classLoaderModel;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public Product getRequiredProduct() {
        return this.requiredProduct;
    }

    public void setRequiredProduct(Product requiredProduct) {
        this.requiredProduct = requiredProduct;
    }

    public void setBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getName());
    }

    public Optional<Properties> getDeploymentProperties() {
        return this.deploymentProperties;
    }
}

