/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer;

import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public class TransactionProfilingDataProducer
implements ResettableProfilingDataProducer<TransactionProfilingEventContext, CoreEvent> {
    private final DefaultProfilingService defaultProfilingService;
    private final ProfilingEventType<TransactionProfilingEventContext> profilingEventType;
    private final ProfilingDataProducerStatus profilingProducerStatus;

    public TransactionProfilingDataProducer(DefaultProfilingService defaultProfilingService, ProfilingEventType<TransactionProfilingEventContext> profilingEventType, ProfilingProducerScope profilingProducerScope, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.defaultProfilingService = defaultProfilingService;
        this.profilingEventType = profilingEventType;
        this.profilingProducerStatus = featureFlaggingService.getProfilingDataProducerStatus(profilingEventType, profilingProducerScope);
    }

    @Override
    public void reset() {
        this.profilingProducerStatus.reset();
    }

    public void triggerProfilingEvent(TransactionProfilingEventContext transactionProfilingEventContext) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent(transactionProfilingEventContext, this.profilingEventType);
        }
    }

    public void triggerProfilingEvent(CoreEvent coreEvent, Function<CoreEvent, TransactionProfilingEventContext> transformation) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent((ProfilingEventContext)transformation.apply(coreEvent), this.profilingEventType);
        }
    }
}

