/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.BaseExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@NoExtend
public class PolicyChain
extends AbstractComponent
implements Initialisable,
Startable,
Stoppable,
Disposable,
Processor {
    @Inject
    private MuleContext muleContext;
    @Inject
    private ServerNotificationHandler notificationManager;
    private ProcessingStrategy processingStrategy;
    private List<Processor> processors;
    private MessageProcessorChain processorChain;
    private String flowStackEntryName;
    private PolicyNotificationHelper notificationHelper;
    private boolean propagateMessageTransformations;
    private Optional<Consumer<Exception>> onError = Optional.empty();
    private FluxSinkRecorder chainActiveSink;

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public final void initialise() throws InitialisationException {
        this.processorChain = MessageProcessors.buildNewChainWithListOfProcessors(Optional.ofNullable(this.processingStrategy), this.processors, this.policyChainErrorHandler());
        LifecycleUtils.initialiseIfNeeded(this.processorChain, this.muleContext);
        this.notificationHelper = new PolicyNotificationHelper(this.notificationManager, this.muleContext.getConfiguration().getId(), (Component)this);
        this.flowStackEntryName = this.getLocation().getLocation() + "[before next]";
    }

    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    public void start() throws MuleException {
        this.chainActiveSink = new FluxSinkRecorder();
        this.processingStrategy.registerInternalSink((Publisher<CoreEvent>)this.chainActiveSink.flux(), this.flowStackEntryName);
        if (this.processorChain != null) {
            this.processorChain.start();
        }
    }

    public void dispose() {
        if (this.processorChain != null) {
            this.processorChain.dispose();
        }
    }

    public void stop() throws MuleException {
        if (this.processorChain != null) {
            this.processorChain.stop();
        }
        this.chainActiveSink.complete();
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this.processorChain);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).doOnNext(this.pushBeforeNextFlowStackElement().andThen(this.notificationHelper.notification(2101))).transform((Function)this.processorChain).doOnNext(this.popFlowFlowStackElement().andThen((? super T e) -> this.notificationHelper.fireNotification((CoreEvent)e, null, 2104)));
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    private BaseExceptionHandler policyChainErrorHandler() {
        return new BaseExceptionHandler(){

            @Override
            public void onError(Exception exception) {
                MessagingException t = (MessagingException)((Object)exception);
                PolicyChain.this.notificationHelper.fireNotification(t.getEvent(), (Exception)((Object)t), 2104);
                PolicyChain.this.popFlowFlowStackElement().accept(t.getEvent());
                PolicyChain.this.onError.ifPresent(onError -> onError.accept(t));
            }

            public String toString() {
                return PolicyChain.class.getSimpleName() + ".errorHandler @ " + PolicyChain.this.getLocation().getLocation();
            }
        };
    }

    private Consumer<CoreEvent> pushBeforeNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.flowStackEntryName, this.getIdentifier(), null));
    }

    private Consumer<CoreEvent> popFlowFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
    }

    public boolean isPropagateMessageTransformations() {
        return this.propagateMessageTransformations;
    }

    public void setPropagateMessageTransformations(boolean propagateMessageTransformations) {
        this.propagateMessageTransformations = propagateMessageTransformations;
    }

    public PolicyChain onChainError(Consumer<Exception> onError) {
        this.onError = Optional.of(onError);
        return this;
    }
}

