/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public final class DelegateConnectionManagerAdapter
implements ConnectionManagerAdapter {
    private ConnectionManagerAdapter delegate;
    private ConnectionManagerAdapter connectionManagerAdapterStrategy;

    @Inject
    public DelegateConnectionManagerAdapter(MuleContext muleContext) {
        this.delegate = new DefaultConnectionManager(muleContext);
        this.connectionManagerAdapterStrategy = Boolean.parseBoolean(muleContext.getDeploymentProperties().getProperty("mule.application.deployment.lazyConnections", "false")) ? new LazyConnectionManagerAdapter() : new EagerConnectionManagerAdapter();
    }

    @Override
    public <C> RetryPolicyTemplate getRetryTemplateFor(ConnectionProvider<C> connectionProvider) {
        return this.connectionManagerAdapterStrategy.getRetryTemplateFor(connectionProvider);
    }

    @Override
    public <C> ReconnectionConfig getReconnectionConfigFor(ConnectionProvider<C> connectionProvider) {
        return this.connectionManagerAdapterStrategy.getReconnectionConfigFor(connectionProvider);
    }

    @Override
    public PoolingProfile getDefaultPoolingProfile() {
        return this.connectionManagerAdapterStrategy.getDefaultPoolingProfile();
    }

    @Override
    public <C> void bind(Object config, ConnectionProvider<C> connectionProvider) {
        this.connectionManagerAdapterStrategy.bind(config, connectionProvider);
    }

    @Override
    public boolean hasBinding(Object config) {
        return this.connectionManagerAdapterStrategy.hasBinding(config);
    }

    @Override
    public void unbind(Object config) {
        this.connectionManagerAdapterStrategy.unbind(config);
    }

    @Override
    public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
        return this.connectionManagerAdapterStrategy.getConnection(config);
    }

    @Override
    public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
        return this.connectionManagerAdapterStrategy.testConnectivity(connectionProvider);
    }

    @Override
    public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
        return this.connectionManagerAdapterStrategy.testConnectivity(connection, connectionHandler);
    }

    @Override
    public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
        return this.connectionManagerAdapterStrategy.testConnectivity(configurationInstance);
    }

    public void initialise() throws InitialisationException {
        this.connectionManagerAdapterStrategy.initialise();
    }

    public void start() throws MuleException {
        this.connectionManagerAdapterStrategy.start();
    }

    public void stop() throws MuleException {
        this.connectionManagerAdapterStrategy.stop();
    }

    public void dispose() {
        this.connectionManagerAdapterStrategy.dispose();
    }

    class LazyInvocationHandler
    implements InvocationHandler {
        private Object config;
        private ConnectionHandler<Object> connection;

        public LazyInvocationHandler(Object config) {
            this.config = config;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getConnection")) {
                if (this.connection == null) {
                    this.connection = DelegateConnectionManagerAdapter.this.delegate.getConnection(this.config);
                }
                return this.connection.getConnection();
            }
            if (this.connection != null) {
                return method.invoke(this.connection, args);
            }
            return null;
        }
    }

    class LazyConnectionManagerAdapter
    implements ConnectionManagerAdapter {
        LazyConnectionManagerAdapter() {
        }

        @Override
        public <C> void bind(Object owner, ConnectionProvider<C> connectionProvider) {
            DelegateConnectionManagerAdapter.this.delegate.bind(owner, connectionProvider);
        }

        @Override
        public <C> RetryPolicyTemplate getRetryTemplateFor(ConnectionProvider<C> connectionProvider) {
            return DelegateConnectionManagerAdapter.this.delegate.getRetryTemplateFor(connectionProvider);
        }

        @Override
        public <C> ReconnectionConfig getReconnectionConfigFor(ConnectionProvider<C> connectionProvider) {
            return DelegateConnectionManagerAdapter.this.delegate.getReconnectionConfigFor(connectionProvider);
        }

        @Override
        public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
            return ConnectionValidationResult.success();
        }

        @Override
        public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
            return ConnectionValidationResult.success();
        }

        @Override
        public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
            return ConnectionValidationResult.success();
        }

        @Override
        public boolean hasBinding(Object config) {
            return DelegateConnectionManagerAdapter.this.delegate.hasBinding(config);
        }

        @Override
        public void unbind(Object config) {
            DelegateConnectionManagerAdapter.this.delegate.unbind(config);
        }

        @Override
        public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
            Object proxyInstance = Proxy.newProxyInstance(config.getClass().getClassLoader(), new Class[]{ConnectionHandler.class, ConnectionHandlerAdapter.class}, (InvocationHandler)new LazyInvocationHandler(config));
            return (ConnectionHandler)proxyInstance;
        }

        public void stop() throws MuleException {
            DelegateConnectionManagerAdapter.this.delegate.stop();
        }

        public void dispose() {
            DelegateConnectionManagerAdapter.this.delegate.dispose();
        }

        public void initialise() throws InitialisationException {
            DelegateConnectionManagerAdapter.this.delegate.initialise();
        }

        public void start() throws MuleException {
            DelegateConnectionManagerAdapter.this.delegate.start();
        }

        @Override
        public PoolingProfile getDefaultPoolingProfile() {
            return DelegateConnectionManagerAdapter.this.delegate.getDefaultPoolingProfile();
        }
    }

    class EagerConnectionManagerAdapter
    implements ConnectionManagerAdapter {
        EagerConnectionManagerAdapter() {
        }

        @Override
        public <C> RetryPolicyTemplate getRetryTemplateFor(ConnectionProvider<C> connectionProvider) {
            return DelegateConnectionManagerAdapter.this.delegate.getRetryTemplateFor(connectionProvider);
        }

        @Override
        public <C> ReconnectionConfig getReconnectionConfigFor(ConnectionProvider<C> connectionProvider) {
            return DelegateConnectionManagerAdapter.this.delegate.getReconnectionConfigFor(connectionProvider);
        }

        @Override
        public PoolingProfile getDefaultPoolingProfile() {
            return DelegateConnectionManagerAdapter.this.delegate.getDefaultPoolingProfile();
        }

        @Override
        public <C> void bind(Object config, ConnectionProvider<C> connectionProvider) {
            DelegateConnectionManagerAdapter.this.delegate.bind(config, connectionProvider);
        }

        @Override
        public boolean hasBinding(Object config) {
            return DelegateConnectionManagerAdapter.this.delegate.hasBinding(config);
        }

        @Override
        public void unbind(Object config) {
            DelegateConnectionManagerAdapter.this.delegate.unbind(config);
        }

        @Override
        public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
            return DelegateConnectionManagerAdapter.this.delegate.getConnection(config);
        }

        @Override
        public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
            return DelegateConnectionManagerAdapter.this.delegate.testConnectivity(connectionProvider);
        }

        @Override
        public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
            return DelegateConnectionManagerAdapter.this.delegate.testConnectivity(connection, connectionHandler);
        }

        @Override
        public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
            return DelegateConnectionManagerAdapter.this.delegate.testConnectivity(configurationInstance);
        }

        public void initialise() throws InitialisationException {
            DelegateConnectionManagerAdapter.this.delegate.initialise();
        }

        public void start() throws MuleException {
            DelegateConnectionManagerAdapter.this.delegate.start();
        }

        public void stop() throws MuleException {
            DelegateConnectionManagerAdapter.this.delegate.stop();
        }

        public void dispose() {
            DelegateConnectionManagerAdapter.this.delegate.dispose();
        }
    }
}

