/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.ReactorAwareProfilingService;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentProcessingStrategyProfilingEventContext;
import org.reactivestreams.Publisher;

public class PipelineProcessingStrategyReactiveProcessorBuilder {
    private final String artifactId;
    private final String artifactType;
    private final ReactiveProcessor pipeline;
    private final ClassLoader executionClassloader;
    private ScheduledExecutorService scheduler;
    private ReactorAwareProfilingService profilingService;

    private PipelineProcessingStrategyReactiveProcessorBuilder(ReactiveProcessor pipeline, ClassLoader executionClassloader, String artifactId, String artifactType) {
        this.pipeline = pipeline;
        this.executionClassloader = executionClassloader;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    public static PipelineProcessingStrategyReactiveProcessorBuilder pipelineProcessingStrategyReactiveProcessorFrom(ReactiveProcessor pipeline, ClassLoader executionClassloader, String artifactId, String artifactType) {
        return new PipelineProcessingStrategyReactiveProcessorBuilder(pipeline, executionClassloader, artifactId, artifactType);
    }

    public PipelineProcessingStrategyReactiveProcessorBuilder withScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public PipelineProcessingStrategyReactiveProcessorBuilder withProfilingService(ReactorAwareProfilingService profilingService) {
        this.profilingService = profilingService;
        return this;
    }

    public ReactiveProcessor build() {
        return publisher -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)publisher)).build();
    }

    private <T extends Publisher> ReactorPublisherBuilder<T> baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder<T> publisher) {
        ComponentLocation location = ProfilingUtils.getLocation(this.pipeline);
        ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> psSchedulingFlowExecutionDataProducer = this.dataProducerFromProfilingService((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION);
        ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> startingFlowExecutionDataproducer = this.dataProducerFromProfilingService((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION);
        ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> flowExecutedDataProducer = this.dataProducerFromProfilingService((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.FLOW_EXECUTED);
        Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transfomer = coreEvent -> new DefaultComponentProcessingStrategyProfilingEventContext((CoreEvent)coreEvent, ProfilingUtils.getLocation(this.pipeline), Thread.currentThread().getName(), this.artifactId, this.artifactType, System.currentTimeMillis());
        return publisher.profileProcessingStrategyEvent(this.profilingService, psSchedulingFlowExecutionDataProducer, transfomer).publishOn(Optional.ofNullable(this.scheduler)).profileProcessingStrategyEvent(this.profilingService, startingFlowExecutionDataproducer, transfomer).doOnSubscribe(subscription -> Thread.currentThread().setContextClassLoader(this.executionClassloader)).transform(this.pipeline).profileProcessingStrategyEvent(this.profilingService, flowExecutedDataProducer, transfomer);
    }

    private ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> dataProducerFromProfilingService(ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> profilingEventType) {
        return this.profilingService.getProfilingDataProducer(profilingEventType);
    }
}

