/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListSizeNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ObjectFunctionBuiltins.class)
public final class ObjectFunctionBuiltinsFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectBindPropertiesNode.class)
    public static final class ObjectBindPropertiesNodeGen
    extends ObjectFunctionBuiltins.ObjectBindPropertiesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private BindProperties5Data bindProperties5_cache;
        @Node.Child
        private InteropLibrary bindProperties6_members_;

        private ObjectBindPropertiesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 1) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.bindPropertiesInvalidTarget(arguments0Value_, arguments1Value_);
            }
            if ((state_0 & 0x1FE) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                Object arguments1Value__;
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 2) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSDynamicObject(arguments1Value__)) {
                        return this.bindPropertiesDynamicObject(arguments0Value__, (DynamicObject)arguments1Value__);
                    }
                }
                if ((state_0 & 4) != 0 && arguments1Value_ instanceof Symbol) {
                    arguments1Value__ = (Symbol)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.bindProperties(arguments0Value__, (Symbol)arguments1Value__);
                    }
                }
                if ((state_0 & 8) != 0 && arguments1Value_ instanceof JSLazyString) {
                    arguments1Value__ = (JSLazyString)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.bindProperties(arguments0Value__, (JSLazyString)arguments1Value__);
                    }
                }
                if ((state_0 & 0x10) != 0 && arguments1Value_ instanceof SafeInteger) {
                    arguments1Value__ = (SafeInteger)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.bindProperties(arguments0Value__, (SafeInteger)arguments1Value__);
                    }
                }
                if ((state_0 & 0x20) != 0 && arguments1Value_ instanceof BigInt) {
                    arguments1Value__ = (BigInt)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__)) {
                        return this.bindProperties(arguments0Value__, (BigInt)arguments1Value__);
                    }
                }
                if ((state_0 & 0x1C0) != 0) {
                    if ((state_0 & 0x40) != 0 && JSGuards.isJSObject(arguments0Value__) && !JSGuards.isTruffleObject(arguments1Value_)) {
                        return this.bindProperties(arguments0Value__, arguments1Value_);
                    }
                    if ((state_0 & 0x80) != 0) {
                        BindProperties5Data s8_ = this.bindProperties5_cache;
                        while (s8_ != null) {
                            if (s8_.interop_.accepts(arguments1Value_) && JSGuards.isJSObject(arguments0Value__) && JSGuards.isForeignObject(arguments1Value_)) {
                                return this.bindProperties(arguments0Value__, arguments1Value_, s8_.interop_, s8_.members_);
                            }
                            s8_ = s8_.next_;
                        }
                    }
                    if ((state_0 & 0x100) != 0 && JSGuards.isJSObject(arguments0Value__) && JSGuards.isForeignObject(arguments1Value_)) {
                        return this.bindProperties6Boundary(state_0, arguments0Value__, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object bindProperties6Boundary(int state_0, DynamicObject arguments0Value__, Object arguments1Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary bindProperties6_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments1Value_);
                DynamicObject dynamicObject = this.bindProperties(arguments0Value__, arguments1Value_, bindProperties6_interop__, this.bindProperties6_members_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (!JSGuards.isJSObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.bindPropertiesInvalidTarget(arguments0Value, arguments1Value);
                    return dynamicObject;
                }
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    Object arguments1Value_;
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSTypes.isDynamicObject(arguments1Value)) {
                        arguments1Value_ = (DynamicObject)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSDynamicObject(arguments1Value_)) {
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindPropertiesDynamicObject(arguments0Value_, (DynamicObject)arguments1Value_);
                            return dynamicObject;
                        }
                    }
                    if (arguments1Value instanceof Symbol) {
                        arguments1Value_ = (Symbol)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindProperties(arguments0Value_, (Symbol)arguments1Value_);
                            return dynamicObject;
                        }
                    }
                    if (arguments1Value instanceof JSLazyString) {
                        arguments1Value_ = (JSLazyString)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            this.state_0_ = state_0 |= 8;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindProperties(arguments0Value_, (JSLazyString)arguments1Value_);
                            return dynamicObject;
                        }
                    }
                    if (arguments1Value instanceof SafeInteger) {
                        arguments1Value_ = (SafeInteger)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            this.state_0_ = state_0 |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindProperties(arguments0Value_, (SafeInteger)arguments1Value_);
                            return dynamicObject;
                        }
                    }
                    if (arguments1Value instanceof BigInt) {
                        arguments1Value_ = (BigInt)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            this.state_0_ = state_0 |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindProperties(arguments0Value_, (BigInt)arguments1Value_);
                            return dynamicObject;
                        }
                    }
                    if (JSGuards.isJSObject(arguments0Value_) && !JSGuards.isTruffleObject(arguments1Value)) {
                        this.state_0_ = state_0 |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        arguments1Value_ = this.bindProperties(arguments0Value_, arguments1Value);
                        return arguments1Value_;
                    }
                    if (exclude == 0) {
                        int count8_ = 0;
                        BindProperties5Data s8_ = this.bindProperties5_cache;
                        if ((state_0 & 0x80) != 0) {
                            while (!(s8_ == null || s8_.interop_.accepts(arguments1Value) && JSGuards.isJSObject(arguments0Value_) && JSGuards.isForeignObject(arguments1Value))) {
                                s8_ = s8_.next_;
                                ++count8_;
                            }
                        }
                        if (s8_ == null && JSGuards.isJSObject(arguments0Value_) && JSGuards.isForeignObject(arguments1Value) && count8_ < 5) {
                            s8_ = (BindProperties5Data)super.insert((Node)new BindProperties5Data(this.bindProperties5_cache));
                            s8_.interop_ = (InteropLibrary)s8_.insertAccessor(INTEROP_LIBRARY_.create(arguments1Value));
                            s8_.members_ = (InteropLibrary)s8_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                            this.bindProperties5_cache = s8_;
                            this.state_0_ = state_0 |= 0x80;
                        }
                        if (s8_ != null) {
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindProperties(arguments0Value_, arguments1Value, s8_.interop_, s8_.members_);
                            return dynamicObject;
                        }
                    }
                    InteropLibrary bindProperties6_interop__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isForeignObject(arguments1Value)) {
                            bindProperties6_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments1Value);
                            this.bindProperties6_members_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                            this.exclude_ = exclude |= 1;
                            this.bindProperties5_cache = null;
                            state_0 &= 0xFFFFFF7F;
                            this.state_0_ = state_0 |= 0x100;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.bindProperties(arguments0Value_, arguments1Value, bindProperties6_interop__, this.bindProperties6_members_);
                            return dynamicObject;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            BindProperties5Data s8_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s8_ = this.bindProperties5_cache) == null || s8_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<InteropLibrary>> cached;
            Object[] data = new Object[10];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "bindPropertiesInvalidTarget";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "bindPropertiesDynamicObject";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            if ((state_0 & 0x80) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<InteropLibrary>>();
                BindProperties5Data s8_ = this.bindProperties5_cache;
                while (s8_ != null) {
                    cached.add(Arrays.asList(s8_.interop_, s8_.members_));
                    s8_ = s8_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[8] = s;
            s = new Object[3];
            s[0] = "bindProperties";
            if ((state_0 & 0x100) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.bindProperties6_members_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[9] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectBindPropertiesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectBindPropertiesNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectBindPropertiesNode.class)
        private static final class BindProperties5Data
        extends Node {
            @Node.Child
            BindProperties5Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;

            BindProperties5Data(BindProperties5Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectFromEntriesNode.class)
    public static final class ObjectFromEntriesNodeGen
    extends ObjectFunctionBuiltins.ObjectFromEntriesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectFromEntriesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.entries(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "entries";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectFromEntriesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectFromEntriesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectValuesOrEntriesNode.class)
    public static final class ObjectValuesOrEntriesNodeGen
    extends ObjectFunctionBuiltins.ObjectValuesOrEntriesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile valuesOrEntriesJSObject_lengthZero_;
        @Node.Child
        private EnumerableOwnPropertyNamesForeign0Data enumerableOwnPropertyNamesForeign0_cache;
        @Node.Child
        private EnumerableOwnPropertyNamesForeign1Data enumerableOwnPropertyNamesForeign1_cache;
        @Node.Child
        private ObjectFunctionBuiltins.ObjectValuesOrEntriesNode valuesOrEntriesGeneric_recursive_;

        private ObjectValuesOrEntriesNodeGen(JSContext context, JSBuiltin builtin, boolean entries, JavaScriptNode[] arguments) {
            super(context, builtin, entries);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop
        protected DynamicObject executeEvaluated(Object arguments0Value) {
            DynamicObject arguments0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                return this.valuesOrEntriesJSObject(arguments0Value_, this.valuesOrEntriesJSObject_lengthZero_);
            }
            if ((state_0 & 0xE) != 0) {
                EnumerableOwnPropertyNamesForeign1Data s3_;
                if ((state_0 & 2) != 0) {
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value)) {
                            return this.enumerableOwnPropertyNamesForeign(arguments0Value, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_, s2_.errorBranch_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && (s3_ = this.enumerableOwnPropertyNamesForeign1_cache) != null && JSGuards.isForeignObject(arguments0Value)) {
                    return this.enumerableOwnPropertyNamesForeign1Boundary(state_0, s3_, arguments0Value);
                }
                if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    return this.valuesOrEntriesGeneric(arguments0Value, this.valuesOrEntriesGeneric_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private DynamicObject enumerableOwnPropertyNamesForeign1Boundary(int state_0, EnumerableOwnPropertyNamesForeign1Data s3_, Object arguments0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value, interop__, s3_.members_, s3_.importValue_, s3_.growProfile_, s3_.errorBranch_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.valuesOrEntriesJSObject(arguments0Value__, this.valuesOrEntriesJSObject_lengthZero_);
            }
            if ((state_0 & 0xE) != 0) {
                EnumerableOwnPropertyNamesForeign1Data s3_;
                if ((state_0 & 2) != 0) {
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            return this.enumerableOwnPropertyNamesForeign(arguments0Value_, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_, s2_.errorBranch_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && (s3_ = this.enumerableOwnPropertyNamesForeign1_cache) != null && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.enumerableOwnPropertyNamesForeign1Boundary0(state_0, s3_, arguments0Value_);
                }
                if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                    return this.valuesOrEntriesGeneric(arguments0Value_, this.valuesOrEntriesGeneric_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object enumerableOwnPropertyNamesForeign1Boundary0(int state_0, EnumerableOwnPropertyNamesForeign1Data s3_, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value_, interop__, s3_.members_, s3_.importValue_, s3_.growProfile_, s3_.errorBranch_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.valuesOrEntriesJSObject_lengthZero_ = ConditionProfile.createBinaryProfile();
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valuesOrEntriesJSObject(arguments0Value_, this.valuesOrEntriesJSObject_lengthZero_);
                    return dynamicObject;
                }
                if (exclude == 0) {
                    int count2_ = 0;
                    EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                    if ((state_0 & 2) != 0) {
                        while (!(s2_ == null || s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && JSGuards.isForeignObject(arguments0Value) && count2_ < 5) {
                        s2_ = (EnumerableOwnPropertyNamesForeign0Data)super.insert((Node)new EnumerableOwnPropertyNamesForeign0Data(this.enumerableOwnPropertyNamesForeign0_cache));
                        s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s2_.members_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s2_.importValue_ = s2_.insertAccessor(ImportValueNode.create());
                        s2_.growProfile_ = BranchProfile.create();
                        s2_.errorBranch_ = BranchProfile.create();
                        this.enumerableOwnPropertyNamesForeign0_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value, s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_, s2_.errorBranch_);
                        return dynamicObject;
                    }
                }
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        EnumerableOwnPropertyNamesForeign1Data s3_ = (EnumerableOwnPropertyNamesForeign1Data)super.insert((Node)new EnumerableOwnPropertyNamesForeign1Data());
                        interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        s3_.members_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s3_.importValue_ = s3_.insertAccessor(ImportValueNode.create());
                        s3_.growProfile_ = BranchProfile.create();
                        s3_.errorBranch_ = BranchProfile.create();
                        this.enumerableOwnPropertyNamesForeign1_cache = s3_;
                        this.exclude_ = exclude |= 1;
                        this.enumerableOwnPropertyNamesForeign0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.enumerableOwnPropertyNamesForeign(arguments0Value, interop__, s3_.members_, s3_.importValue_, s3_.growProfile_, s3_.errorBranch_);
                        return dynamicObject;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    this.valuesOrEntriesGeneric_recursive_ = (ObjectFunctionBuiltins.ObjectValuesOrEntriesNode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.valuesOrEntriesGeneric(arguments0Value, this.valuesOrEntriesGeneric_recursive_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            EnumerableOwnPropertyNamesForeign0Data s2_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.enumerableOwnPropertyNamesForeign0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "valuesOrEntriesJSObject";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.valuesOrEntriesJSObject_lengthZero_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "enumerableOwnPropertyNamesForeign";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                EnumerableOwnPropertyNamesForeign0Data s2_ = this.enumerableOwnPropertyNamesForeign0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s2_.interop_, s2_.members_, s2_.importValue_, s2_.growProfile_, s2_.errorBranch_}));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "enumerableOwnPropertyNamesForeign";
            if ((state_0 & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                EnumerableOwnPropertyNamesForeign1Data s3_ = this.enumerableOwnPropertyNamesForeign1_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s3_.members_, s3_.importValue_, s3_.growProfile_, s3_.errorBranch_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "valuesOrEntriesGeneric";
            if ((state_0 & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.valuesOrEntriesGeneric_recursive_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectValuesOrEntriesNode create(JSContext context, JSBuiltin builtin, boolean entries, JavaScriptNode[] arguments) {
            return new ObjectValuesOrEntriesNodeGen(context, builtin, entries, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectValuesOrEntriesNode.class)
        private static final class EnumerableOwnPropertyNamesForeign1Data
        extends Node {
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            ImportValueNode importValue_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            EnumerableOwnPropertyNamesForeign1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectValuesOrEntriesNode.class)
        private static final class EnumerableOwnPropertyNamesForeign0Data
        extends Node {
            @Node.Child
            EnumerableOwnPropertyNamesForeign0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            ImportValueNode importValue_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            EnumerableOwnPropertyNamesForeign0Data(EnumerableOwnPropertyNamesForeign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.AssignPropertiesNode.class)
    static final class AssignPropertiesNodeGen
    extends ObjectFunctionBuiltins.AssignPropertiesNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private CopyPropertiesFromJSObjectData copyPropertiesFromJSObject_cache;
        @Node.Child
        private Object0Data object0_cache;
        @Node.Child
        private InteropLibrary object1_keysInterop_;
        @Node.Child
        private InteropLibrary object1_stringInterop_;

        private AssignPropertiesNodeGen(JSContext context) {
            super(context);
        }

        @Override
        @ExplodeLoop
        void executeVoid(Object arg0Value, Object arg1Value, WriteElementNode arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arg1Value)) {
                    DynamicObject arg1Value_ = (DynamicObject)arg1Value;
                    CopyPropertiesFromJSObjectData s1_ = this.copyPropertiesFromJSObject_cache;
                    if (s1_ != null && JSGuards.isJSObject(arg1Value_)) {
                        ObjectFunctionBuiltins.AssignPropertiesNode.copyPropertiesFromJSObject(arg0Value, arg1Value_, arg2Value, s1_.read_, s1_.getOwnProperty_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                        return;
                    }
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0) {
                        Object0Data s2_ = this.object0_cache;
                        while (s2_ != null) {
                            if (s2_.fromInterop_.accepts(arg1Value) && !JSGuards.isJSObject(arg1Value)) {
                                this.doObject(arg0Value, arg1Value, arg2Value, s2_.fromInterop_, s2_.keysInterop_, s2_.stringInterop_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0 && !JSGuards.isJSObject(arg1Value)) {
                        this.object1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void object1Boundary(int state_0, Object arg0Value, Object arg1Value, WriteElementNode arg2Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary object1_fromInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                this.doObject(arg0Value, arg1Value, arg2Value, object1_fromInterop__, this.object1_keysInterop_, this.object1_stringInterop_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(Object arg0Value, Object arg1Value, WriteElementNode arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arg1Value_;
                if (JSTypes.isDynamicObject(arg1Value) && JSGuards.isJSObject(arg1Value_ = (DynamicObject)arg1Value)) {
                    CopyPropertiesFromJSObjectData s1_ = (CopyPropertiesFromJSObjectData)super.insert((Node)new CopyPropertiesFromJSObjectData());
                    s1_.read_ = s1_.insertAccessor(ReadElementNode.create(this.context));
                    s1_.getOwnProperty_ = s1_.insertAccessor(JSGetOwnPropertyNode.create(false));
                    s1_.listSize_ = s1_.insertAccessor(ListSizeNode.create());
                    s1_.listGet_ = s1_.insertAccessor(ListGetNode.create());
                    s1_.classProfile_ = JSClassProfile.create();
                    this.copyPropertiesFromJSObject_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    ObjectFunctionBuiltins.AssignPropertiesNode.copyPropertiesFromJSObject(arg0Value, arg1Value_, arg2Value, s1_.read_, s1_.getOwnProperty_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                    return;
                }
                if (exclude == 0) {
                    int count2_ = 0;
                    Object0Data s2_ = this.object0_cache;
                    if ((state_0 & 2) != 0) {
                        while (s2_ != null && (!s2_.fromInterop_.accepts(arg1Value) || JSGuards.isJSObject(arg1Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && !JSGuards.isJSObject(arg1Value) && count2_ < 5) {
                        s2_ = (Object0Data)super.insert((Node)new Object0Data(this.object0_cache));
                        s2_.fromInterop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                        s2_.keysInterop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s2_.stringInterop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        this.object0_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doObject(arg0Value, arg1Value, arg2Value, s2_.fromInterop_, s2_.keysInterop_, s2_.stringInterop_);
                        return;
                    }
                }
                InteropLibrary object1_fromInterop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (!JSGuards.isJSObject(arg1Value)) {
                        object1_fromInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                        this.object1_keysInterop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                        this.object1_stringInterop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                        this.exclude_ = exclude |= 1;
                        this.object0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        this.doObject(arg0Value, arg1Value, arg2Value, object1_fromInterop__, this.object1_keysInterop_, this.object1_stringInterop_);
                        return;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Object0Data s2_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.object0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "copyPropertiesFromJSObject";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                CopyPropertiesFromJSObjectData s1_ = this.copyPropertiesFromJSObject_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.read_, s1_.getOwnProperty_, s1_.listSize_, s1_.listGet_, s1_.classProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doObject";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                Object0Data s2_ = this.object0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.fromInterop_, s2_.keysInterop_, s2_.stringInterop_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doObject";
            if ((state_0 & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.object1_keysInterop_, this.object1_stringInterop_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.AssignPropertiesNode create(JSContext context) {
            return new AssignPropertiesNodeGen(context);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.AssignPropertiesNode.class)
        private static final class Object0Data
        extends Node {
            @Node.Child
            Object0Data next_;
            @Node.Child
            InteropLibrary fromInterop_;
            @Node.Child
            InteropLibrary keysInterop_;
            @Node.Child
            InteropLibrary stringInterop_;

            Object0Data(Object0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.AssignPropertiesNode.class)
        private static final class CopyPropertiesFromJSObjectData
        extends Node {
            @Node.Child
            ReadElementNode read_;
            @Node.Child
            JSGetOwnPropertyNode getOwnProperty_;
            @Node.Child
            ListSizeNode listSize_;
            @Node.Child
            ListGetNode listGet_;
            @CompilerDirectives.CompilationFinal
            JSClassProfile classProfile_;

            CopyPropertiesFromJSObjectData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectAssignNode.class)
    public static final class ObjectAssignNodeGen
    extends ObjectFunctionBuiltins.ObjectAssignNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private AssignData assign_cache;

        private ObjectAssignNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                AssignData s1_ = this.assign_cache;
                if (s1_ != null) {
                    return this.assign(arguments0Value_, arguments1Value__, s1_.toObjectNode_, s1_.write_, s1_.assignProperties_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    AssignData s1_ = (AssignData)super.insert((Node)new AssignData());
                    s1_.toObjectNode_ = s1_.insertAccessor(JSToObjectNode.createToObject(this.getContext()));
                    s1_.write_ = s1_.insertAccessor(WriteElementNode.create(this.getContext(), true));
                    s1_.assignProperties_ = s1_.insertAccessor(AssignPropertiesNodeGen.create(this.getContext()));
                    this.assign_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.assign(arguments0Value, arguments1Value_, s1_.toObjectNode_, s1_.write_, s1_.assignProperties_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "assign";
            if (state_0 != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                AssignData s1_ = this.assign_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.toObjectNode_, s1_.write_, s1_.assignProperties_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectAssignNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectAssignNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectAssignNode.class)
        private static final class AssignData
        extends Node {
            @Node.Child
            JSToObjectNode toObjectNode_;
            @Node.Child
            WriteElementNode write_;
            @Node.Child
            ObjectFunctionBuiltins.AssignPropertiesNode assignProperties_;

            AssignData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectIsNode.class)
    public static final class ObjectIsNodeGen
    extends ObjectFunctionBuiltins.ObjectIsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSIdenticalNode isNumberNumber_doIdenticalNode_;
        @Node.Child
        private JSIdenticalNode isObject_doIdenticalNode_;

        private ObjectIsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0 && (state_0 & 0xF) != 0) {
                return this.execute_int_int0(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && (state_0 & 0xF) != 0) {
                return this.execute_double_double1(state_0, frameValue);
            }
            return this.execute_generic2(state_0, frameValue);
        }

        private Object execute_int_int0(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            return this.isInt(arguments0Value_, arguments1Value_);
        }

        private Object execute_double_double1(int state_0, VirtualFrame frameValue) {
            double arguments1Value_;
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state_0 & 0xE0) == 0 && (state_0 & 0xF) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state_0 & 0xD0) == 0 && (state_0 & 0xF) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state_0 & 0xB0) == 0 && (state_0 & 0xF) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0xF0) >>> 4, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_int = 0;
            long arguments1Value_long = 0L;
            try {
                if ((state_0 & 0xE00) == 0 && (state_0 & 0xF) != 0) {
                    arguments1Value_long = this.arguments1_.executeLong(frameValue);
                    arguments1Value_ = JSTypes.longToDouble(arguments1Value_long);
                } else if ((state_0 & 0xD00) == 0 && (state_0 & 0xF) != 0) {
                    arguments1Value_int = this.arguments1_.executeInt(frameValue);
                    arguments1Value_ = JSTypes.intToDouble(arguments1Value_int);
                } else if ((state_0 & 0xB00) == 0 && (state_0 & 0xF) != 0) {
                    arguments1Value_ = this.arguments1_.executeDouble(frameValue);
                } else {
                    Object arguments1Value__ = this.arguments1_.execute(frameValue);
                    arguments1Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0xF00) >>> 8, arguments1Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize((state_0 & 0xE0) == 0 && (state_0 & 0xF) != 0 ? (Number)arguments0Value_long : (Number)((state_0 & 0xD0) == 0 && (state_0 & 0xF) != 0 ? (Number)arguments0Value_int : (Number)arguments0Value_), ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return this.isDouble(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic2(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.isInt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state_0 & 2) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xF0) >>> 4, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0xF0) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitDouble((state_0 & 0xF00) >>> 8, arguments1Value_)) {
                    double arguments1Value__ = JSTypesGen.asImplicitDouble((state_0 & 0xF00) >>> 8, arguments1Value_);
                    return this.isDouble(arguments0Value__, arguments1Value__);
                }
            }
            if ((state_0 & 4) != 0 && arguments0Value_ instanceof Number) {
                Number arguments1Value__;
                Number arguments0Value__ = (Number)arguments0Value_;
                if (arguments1Value_ instanceof Number && this.isNumberNumber(arguments0Value__, arguments1Value__ = (Number)arguments1Value_)) {
                    return this.isNumberNumber(arguments0Value__, arguments1Value__, this.isNumberNumber_doIdenticalNode_);
                }
            }
            if ((state_0 & 8) != 0 && !this.isNumberNumber(arguments0Value_, arguments1Value_)) {
                return this.isObject(arguments0Value_, arguments1Value_, this.isObject_doIdenticalNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0 && (state_0 & 0xF) != 0) {
                return this.executeBoolean_int_int3(state_0, frameValue);
            }
            if ((state_0 & 0xD) == 0 && (state_0 & 0xF) != 0) {
                return this.executeBoolean_double_double4(state_0, frameValue);
            }
            return this.executeBoolean_generic5(state_0, frameValue);
        }

        private boolean executeBoolean_int_int3(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            int arguments0Value_;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            return this.isInt(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_double_double4(int state_0, VirtualFrame frameValue) {
            double arguments1Value_;
            double arguments0Value_;
            int arguments0Value_int = 0;
            long arguments0Value_long = 0L;
            try {
                if ((state_0 & 0xE0) == 0 && (state_0 & 0xF) != 0) {
                    arguments0Value_long = this.arguments0_.executeLong(frameValue);
                    arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
                } else if ((state_0 & 0xD0) == 0 && (state_0 & 0xF) != 0) {
                    arguments0Value_int = this.arguments0_.executeInt(frameValue);
                    arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
                } else if ((state_0 & 0xB0) == 0 && (state_0 & 0xF) != 0) {
                    arguments0Value_ = this.arguments0_.executeDouble(frameValue);
                } else {
                    Object arguments0Value__ = this.arguments0_.execute(frameValue);
                    arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0xF0) >>> 4, arguments0Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                Object arguments1Value = this.arguments1_.execute(frameValue);
                return this.executeAndSpecialize(ex.getResult(), arguments1Value);
            }
            int arguments1Value_int = 0;
            long arguments1Value_long = 0L;
            try {
                if ((state_0 & 0xE00) == 0 && (state_0 & 0xF) != 0) {
                    arguments1Value_long = this.arguments1_.executeLong(frameValue);
                    arguments1Value_ = JSTypes.longToDouble(arguments1Value_long);
                } else if ((state_0 & 0xD00) == 0 && (state_0 & 0xF) != 0) {
                    arguments1Value_int = this.arguments1_.executeInt(frameValue);
                    arguments1Value_ = JSTypes.intToDouble(arguments1Value_int);
                } else if ((state_0 & 0xB00) == 0 && (state_0 & 0xF) != 0) {
                    arguments1Value_ = this.arguments1_.executeDouble(frameValue);
                } else {
                    Object arguments1Value__ = this.arguments1_.execute(frameValue);
                    arguments1Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0xF00) >>> 8, arguments1Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize((state_0 & 0xE0) == 0 && (state_0 & 0xF) != 0 ? (Number)arguments0Value_long : (Number)((state_0 & 0xD0) == 0 && (state_0 & 0xF) != 0 ? (Number)arguments0Value_int : (Number)arguments0Value_), ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return this.isDouble(arguments0Value_, arguments1Value_);
        }

        private boolean executeBoolean_generic5(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 1) != 0 && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (Integer)arguments0Value_;
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.isInt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state_0 & 2) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xF0) >>> 4, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0xF0) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitDouble((state_0 & 0xF00) >>> 8, arguments1Value_)) {
                    double arguments1Value__ = JSTypesGen.asImplicitDouble((state_0 & 0xF00) >>> 8, arguments1Value_);
                    return this.isDouble(arguments0Value__, arguments1Value__);
                }
            }
            if ((state_0 & 4) != 0 && arguments0Value_ instanceof Number) {
                Number arguments1Value__;
                Number arguments0Value__ = (Number)arguments0Value_;
                if (arguments1Value_ instanceof Number && this.isNumberNumber(arguments0Value__, arguments1Value__ = (Number)arguments1Value_)) {
                    return this.isNumberNumber(arguments0Value__, arguments1Value__, this.isNumberNumber_doIdenticalNode_);
                }
            }
            if ((state_0 & 8) != 0 && !this.isNumberNumber(arguments0Value_, arguments1Value_)) {
                return this.isObject(arguments0Value_, arguments1Value_, this.isObject_doIdenticalNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int doubleCast0;
                if (arguments0Value instanceof Integer) {
                    int arguments0Value_ = (Integer)arguments0Value;
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.isInt(arguments0Value_, arguments1Value_);
                        return bl;
                    }
                }
                if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                    double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                    int doubleCast1 = JSTypesGen.specializeImplicitDouble(arguments1Value);
                    if (doubleCast1 != 0) {
                        double arguments1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arguments1Value);
                        state_0 |= doubleCast0 << 4;
                        state_0 |= doubleCast1 << 8;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.isDouble(arguments0Value_, arguments1Value_);
                        return bl;
                    }
                }
                if (arguments0Value instanceof Number) {
                    Number arguments1Value_;
                    Number arguments0Value_ = (Number)arguments0Value;
                    if (arguments1Value instanceof Number && this.isNumberNumber(arguments0Value_, arguments1Value_ = (Number)arguments1Value)) {
                        this.isNumberNumber_doIdenticalNode_ = (JSIdenticalNode)super.insert((Node)JSIdenticalNode.createSameValue());
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.isNumberNumber(arguments0Value_, arguments1Value_, this.isNumberNumber_doIdenticalNode_);
                        return bl;
                    }
                }
                if (!this.isNumberNumber(arguments0Value, arguments1Value)) {
                    this.isObject_doIdenticalNode_ = (JSIdenticalNode)super.insert((Node)JSIdenticalNode.createSameValue());
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.isObject(arguments0Value, arguments1Value, this.isObject_doIdenticalNode_);
                    return bl;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSIdenticalNode>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "isInt";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "isDouble";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "isNumberNumber";
            if ((state_0 & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSIdenticalNode>>();
                cached.add(Arrays.asList(this.isNumberNumber_doIdenticalNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "isObject";
            if ((state_0 & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isObject_doIdenticalNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectIsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectIsNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectSetPrototypeOfNode.class)
    public static final class ObjectSetPrototypeOfNodeGen
    extends ObjectFunctionBuiltins.ObjectSetPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ObjectSetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 3) != 0 && arguments0Value_ instanceof JSObject) {
                JSDynamicObject arguments1Value__;
                JSObject arguments0Value__ = (JSObject)((Object)arguments0Value_);
                if ((state_0 & 1) != 0 && arguments1Value_ instanceof JSDynamicObject && JSGuards.isValidPrototype((Object)(arguments1Value__ = (JSDynamicObject)((Object)arguments1Value_)))) {
                    return this.setPrototypeOfJSObject(arguments0Value__, arguments1Value__);
                }
                if ((state_0 & 2) != 0 && !JSGuards.isValidPrototype(arguments1Value_)) {
                    return ObjectFunctionBuiltins.ObjectSetPrototypeOfNode.setPrototypeOfJSObjectToInvalidNewProto(arguments0Value__, arguments1Value_);
                }
            }
            if ((state_0 & 0x1C) != 0) {
                if ((state_0 & 4) != 0 && JSGuards.isNullOrUndefined(arguments0Value_)) {
                    return this.setPrototypeOfNonObjectCoercible(arguments0Value_, arguments1Value_);
                }
                if (!((state_0 & 8) == 0 || JSGuards.isJSObject(arguments0Value_) || JSGuards.isNullOrUndefined(arguments0Value_) || JSGuards.isForeignObject(arguments0Value_))) {
                    return ObjectFunctionBuiltins.ObjectSetPrototypeOfNode.setPrototypeOfValue(arguments0Value_, arguments1Value_);
                }
                if ((state_0 & 0x10) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.setPrototypeOfForeignObject(arguments0Value_, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSObject) {
                JSDynamicObject arguments1Value_;
                JSObject arguments0Value_ = (JSObject)((Object)arguments0Value);
                if (arguments1Value instanceof JSDynamicObject && JSGuards.isValidPrototype((Object)(arguments1Value_ = (JSDynamicObject)((Object)arguments1Value)))) {
                    this.state_0_ = state_0 |= 1;
                    return this.setPrototypeOfJSObject(arguments0Value_, arguments1Value_);
                }
                if (!JSGuards.isValidPrototype(arguments1Value)) {
                    this.state_0_ = state_0 |= 2;
                    return ObjectFunctionBuiltins.ObjectSetPrototypeOfNode.setPrototypeOfJSObjectToInvalidNewProto(arguments0Value_, arguments1Value);
                }
            }
            if (JSGuards.isNullOrUndefined(arguments0Value)) {
                this.state_0_ = state_0 |= 4;
                return this.setPrototypeOfNonObjectCoercible(arguments0Value, arguments1Value);
            }
            if (!(JSGuards.isJSObject(arguments0Value) || JSGuards.isNullOrUndefined(arguments0Value) || JSGuards.isForeignObject(arguments0Value))) {
                this.state_0_ = state_0 |= 8;
                return ObjectFunctionBuiltins.ObjectSetPrototypeOfNode.setPrototypeOfValue(arguments0Value, arguments1Value);
            }
            if (JSGuards.isForeignObject(arguments0Value)) {
                this.state_0_ = state_0 |= 0x10;
                return this.setPrototypeOfForeignObject(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "setPrototypeOfJSObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfJSObjectToInvalidNewProto";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfNonObjectCoercible";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfValue";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "setPrototypeOfForeignObject";
            s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectSetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectSetPrototypeOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectKeysNode.class)
    public static final class ObjectKeysNodeGen
    extends ObjectFunctionBuiltins.ObjectKeysNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private KeysForeign0Data keysForeign0_cache;
        @Node.Child
        private KeysForeign1Data keysForeign1_cache;

        private ObjectKeysNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSDynamicObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.keysDynamicObject((DynamicObject)arguments0Value__);
            }
            if ((state_0 & 2) != 0 && arguments0Value_ instanceof Symbol) {
                arguments0Value__ = (Symbol)arguments0Value_;
                return this.keysSymbol((Symbol)arguments0Value__);
            }
            if ((state_0 & 4) != 0 && arguments0Value_ instanceof JSLazyString) {
                arguments0Value__ = (JSLazyString)arguments0Value_;
                return this.keysString((JSLazyString)arguments0Value__);
            }
            if ((state_0 & 8) != 0 && arguments0Value_ instanceof SafeInteger) {
                arguments0Value__ = (SafeInteger)arguments0Value_;
                return this.keysSafeInt((SafeInteger)arguments0Value__);
            }
            if ((state_0 & 0x10) != 0 && arguments0Value_ instanceof BigInt) {
                arguments0Value__ = (BigInt)arguments0Value_;
                return this.keysBigInt((BigInt)arguments0Value__);
            }
            if ((state_0 & 0xE0) != 0) {
                KeysForeign1Data s8_;
                if ((state_0 & 0x20) != 0 && !JSGuards.isTruffleObject(arguments0Value_)) {
                    return this.keysOther(arguments0Value_);
                }
                if ((state_0 & 0x40) != 0) {
                    KeysForeign0Data s7_ = this.keysForeign0_cache;
                    while (s7_ != null) {
                        if (s7_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            return this.keysForeign(arguments0Value_, s7_.interop_, s7_.members_, s7_.growProfile_, s7_.errorBranch_);
                        }
                        s7_ = s7_.next_;
                    }
                }
                if ((state_0 & 0x80) != 0 && (s8_ = this.keysForeign1_cache) != null && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.keysForeign1Boundary(state_0, s8_, arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object keysForeign1Boundary(int state_0, KeysForeign1Data s8_, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                DynamicObject dynamicObject = this.keysForeign(arguments0Value_, interop__, s8_.members_, s8_.growProfile_, s8_.errorBranch_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                Object arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSDynamicObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keysDynamicObject((DynamicObject)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof Symbol) {
                    arguments0Value_ = (Symbol)arguments0Value;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keysSymbol((Symbol)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof JSLazyString) {
                    arguments0Value_ = (JSLazyString)arguments0Value;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keysString((JSLazyString)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof SafeInteger) {
                    arguments0Value_ = (SafeInteger)arguments0Value;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keysSafeInt((SafeInteger)arguments0Value_);
                    return dynamicObject;
                }
                if (arguments0Value instanceof BigInt) {
                    arguments0Value_ = (BigInt)arguments0Value;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.keysBigInt((BigInt)arguments0Value_);
                    return dynamicObject;
                }
                if (!JSGuards.isTruffleObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.keysOther(arguments0Value);
                    return arguments0Value_;
                }
                if (exclude == 0) {
                    int count7_ = 0;
                    KeysForeign0Data s7_ = this.keysForeign0_cache;
                    if ((state_0 & 0x40) != 0) {
                        while (!(s7_ == null || s7_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s7_ = s7_.next_;
                            ++count7_;
                        }
                    }
                    if (s7_ == null && JSGuards.isForeignObject(arguments0Value) && count7_ < 5) {
                        s7_ = (KeysForeign0Data)super.insert((Node)new KeysForeign0Data(this.keysForeign0_cache));
                        s7_.interop_ = (InteropLibrary)s7_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s7_.members_ = (InteropLibrary)s7_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s7_.growProfile_ = BranchProfile.create();
                        s7_.errorBranch_ = BranchProfile.create();
                        this.keysForeign0_cache = s7_;
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s7_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.keysForeign(arguments0Value, s7_.interop_, s7_.members_, s7_.growProfile_, s7_.errorBranch_);
                        return dynamicObject;
                    }
                }
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        KeysForeign1Data s8_ = (KeysForeign1Data)super.insert((Node)new KeysForeign1Data());
                        interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        s8_.members_ = (InteropLibrary)s8_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s8_.growProfile_ = BranchProfile.create();
                        s8_.errorBranch_ = BranchProfile.create();
                        this.keysForeign1_cache = s8_;
                        this.exclude_ = exclude |= 1;
                        this.keysForeign0_cache = null;
                        state_0 &= 0xFFFFFFBF;
                        this.state_0_ = state_0 |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.keysForeign(arguments0Value, interop__, s8_.members_, s8_.growProfile_, s8_.errorBranch_);
                        return dynamicObject;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            KeysForeign0Data s7_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s7_ = this.keysForeign0_cache) == null || s7_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[9];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "keysDynamicObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "keysSymbol";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "keysString";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "keysSafeInt";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "keysBigInt";
            s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "keysOther";
            s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "keysForeign";
            if ((state_0 & 0x40) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                KeysForeign0Data s7_ = this.keysForeign0_cache;
                while (s7_ != null) {
                    cached.add(Arrays.asList(s7_.interop_, s7_.members_, s7_.growProfile_, s7_.errorBranch_));
                    s7_ = s7_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "keysForeign";
            if ((state_0 & 0x80) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                KeysForeign1Data s8_ = this.keysForeign1_cache;
                if (s8_ != null) {
                    cached.add(Arrays.asList(s8_.members_, s8_.growProfile_, s8_.errorBranch_));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[8] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectKeysNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectKeysNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectKeysNode.class)
        private static final class KeysForeign1Data
        extends Node {
            @Node.Child
            InteropLibrary members_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            KeysForeign1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectKeysNode.class)
        private static final class KeysForeign0Data
        extends Node {
            @Node.Child
            KeysForeign0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @CompilerDirectives.CompilationFinal
            BranchProfile growProfile_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            KeysForeign0Data(KeysForeign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode.class)
    public static final class ObjectSetIntegrityLevelNodeGen
    extends ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectSetIntegrityLevelNodeGen(JSContext context, JSBuiltin builtin, boolean freeze, JavaScriptNode[] arguments) {
            super(context, builtin, freeze);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.setIntegrityLevel(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "setIntegrityLevel";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectSetIntegrityLevelNode create(JSContext context, JSBuiltin builtin, boolean freeze, JavaScriptNode[] arguments) {
            return new ObjectSetIntegrityLevelNodeGen(context, builtin, freeze, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode.class)
    public static final class ObjectTestIntegrityLevelNodeGen
    extends ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ObjectTestIntegrityLevelNodeGen(JSContext context, JSBuiltin builtin, boolean frozen, JavaScriptNode[] arguments) {
            super(context, builtin, frozen);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.testIntegrityLevel(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.testIntegrityLevel(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "testIntegrityLevel";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectTestIntegrityLevelNode create(JSContext context, JSBuiltin builtin, boolean frozen, JavaScriptNode[] arguments) {
            return new ObjectTestIntegrityLevelNodeGen(context, builtin, frozen, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectPreventExtensionsNode.class)
    public static final class ObjectPreventExtensionsNodeGen
    extends ObjectFunctionBuiltins.ObjectPreventExtensionsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private ObjectPreventExtensionsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.preventExtensionsObject(arguments0Value__);
            }
            if ((state_0 & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.preventExtensionsNonObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            DynamicObject arguments0Value_;
            int state_0 = this.state_0_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_0_ = state_0 |= 1;
                return this.preventExtensionsObject(arguments0Value_);
            }
            if (!JSGuards.isJSObject(arguments0Value)) {
                this.state_0_ = state_0 |= 2;
                return this.preventExtensionsNonObject(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "preventExtensionsObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "preventExtensionsNonObject";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectPreventExtensionsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectPreventExtensionsNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectIsExtensibleNode.class)
    public static final class ObjectIsExtensibleNodeGen
    extends ObjectFunctionBuiltins.ObjectIsExtensibleNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private IsExtensibleNode isExtensibleObject_isExtensibleNode_;

        private ObjectIsExtensibleNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.isExtensibleObject(arguments0Value__, this.isExtensibleObject_isExtensibleNode_);
            }
            if ((state_0 & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.isExtensibleNonObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.isExtensibleObject(arguments0Value__, this.isExtensibleObject_isExtensibleNode_);
            }
            if ((state_0 & 2) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.isExtensibleNonObject(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.isExtensibleObject_isExtensibleNode_ = (IsExtensibleNode)super.insert((Node)IsExtensibleNode.create());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.isExtensibleObject(arguments0Value_, this.isExtensibleObject_isExtensibleNode_);
                    return bl;
                }
                if (!JSGuards.isJSObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.isExtensibleNonObject(arguments0Value);
                    return bl;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "isExtensibleObject";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<IsExtensibleNode>> cached = new ArrayList<List<IsExtensibleNode>>();
                cached.add(Arrays.asList(this.isExtensibleObject_isExtensibleNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "isExtensibleNonObject";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectIsExtensibleNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectIsExtensibleNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectDefinePropertiesNode.class)
    public static final class ObjectDefinePropertiesNodeGen
    extends ObjectFunctionBuiltins.ObjectDefinePropertiesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private ObjectDefinePropertiesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if (JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return this.definePropertiesObjectObject(arguments0Value__, arguments1Value__);
                    }
                }
            }
            if ((state_0 & 2) != 0) {
                return this.definePropertiesGeneric(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0 && JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSTypes.isDynamicObject(arguments1Value)) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.definePropertiesObjectObject(arguments0Value_, arguments1Value_);
                            return dynamicObject;
                        }
                    }
                }
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.definePropertiesGeneric(arguments0Value, arguments1Value);
                return dynamicObject;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "definePropertiesObjectObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "definePropertiesGeneric";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectDefinePropertiesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectDefinePropertiesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectDefinePropertyNode.class)
    public static final class ObjectDefinePropertyNodeGen
    extends ObjectFunctionBuiltins.ObjectDefinePropertyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private ObjectDefinePropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if (JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments1Value_)) {
                        String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments1Value_);
                        if (JSGuards.isJSObject(arguments0Value__)) {
                            return this.definePropertyJSObjectString(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.definePropertyGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0 && JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSGuards.isJSObject(arguments0Value_)) {
                            state_0 |= stringCast1 << 2;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject = this.definePropertyJSObjectString(arguments0Value_, arguments1Value_, arguments2Value);
                            return dynamicObject;
                        }
                    }
                }
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.definePropertyGeneric(arguments0Value, arguments1Value, arguments2Value);
                return dynamicObject;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "definePropertyJSObjectString";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "definePropertyGeneric";
            s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectDefinePropertyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectDefinePropertyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectCreateNode.class)
    public static final class ObjectCreateNodeGen
    extends ObjectFunctionBuiltins.ObjectCreateNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private CreateForeignNullOrInvalidPrototype0Data createForeignNullOrInvalidPrototype0_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile createForeignNullOrInvalidPrototype1_isNull_;

        private ObjectCreateNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 7) != 0) {
                if ((state_0 & 1) != 0 && JSGuards.isJSNull(arguments0Value_)) {
                    return this.createPrototypeNull(arguments0Value_, arguments1Value_);
                }
                if ((state_0 & 2) != 0) {
                    CreateForeignNullOrInvalidPrototype0Data s2_ = this.createForeignNullOrInvalidPrototype0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value_) && !JSGuards.isJSNull(arguments0Value_) && !JSGuards.isJSObject(arguments0Value_)) {
                            return this.createForeignNullOrInvalidPrototype(arguments0Value_, arguments1Value_, s2_.interop_, s2_.isNull_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && !JSGuards.isJSNull(arguments0Value_) && !JSGuards.isJSObject(arguments0Value_)) {
                    return this.createForeignNullOrInvalidPrototype1Boundary(state_0, arguments0Value_, arguments1Value_);
                }
            }
            if ((state_0 & 0x38) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 8) != 0 && JSTypes.isDynamicObject(arguments1Value_)) {
                    DynamicObject arguments1Value__ = (DynamicObject)arguments1Value_;
                    if (JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSObject(arguments1Value__)) {
                        return this.createObjectObject(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state_0 & 0x30) != 0) {
                    if ((state_0 & 0x10) != 0 && JSGuards.isJSObject(arguments0Value__) && !JSGuards.isJSNull(arguments1Value_)) {
                        return this.createObjectNotNull(arguments0Value__, arguments1Value_);
                    }
                    if ((state_0 & 0x20) != 0 && JSGuards.isJSObject(arguments0Value__) && JSGuards.isJSNull(arguments1Value_)) {
                        return this.createObjectNull(arguments0Value__, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object createForeignNullOrInvalidPrototype1Boundary(int state_0, Object arguments0Value_, Object arguments1Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary createForeignNullOrInvalidPrototype1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                DynamicObject dynamicObject = this.createForeignNullOrInvalidPrototype(arguments0Value_, arguments1Value_, createForeignNullOrInvalidPrototype1_interop__, this.createForeignNullOrInvalidPrototype1_isNull_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (JSGuards.isJSNull(arguments0Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.createPrototypeNull(arguments0Value, arguments1Value);
                    return dynamicObject;
                }
                if (exclude == 0) {
                    int count2_ = 0;
                    CreateForeignNullOrInvalidPrototype0Data s2_ = this.createForeignNullOrInvalidPrototype0_cache;
                    if ((state_0 & 2) != 0) {
                        while (s2_ != null && (!s2_.interop_.accepts(arguments0Value) || JSGuards.isJSNull(arguments0Value) || JSGuards.isJSObject(arguments0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && !JSGuards.isJSNull(arguments0Value) && !JSGuards.isJSObject(arguments0Value) && count2_ < 5) {
                        s2_ = (CreateForeignNullOrInvalidPrototype0Data)super.insert((Node)new CreateForeignNullOrInvalidPrototype0Data(this.createForeignNullOrInvalidPrototype0_cache));
                        s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s2_.isNull_ = ConditionProfile.createBinaryProfile();
                        this.createForeignNullOrInvalidPrototype0_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.createForeignNullOrInvalidPrototype(arguments0Value, arguments1Value, s2_.interop_, s2_.isNull_);
                        return dynamicObject;
                    }
                }
                InteropLibrary createForeignNullOrInvalidPrototype1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (!JSGuards.isJSNull(arguments0Value) && !JSGuards.isJSObject(arguments0Value)) {
                        createForeignNullOrInvalidPrototype1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        this.createForeignNullOrInvalidPrototype1_isNull_ = ConditionProfile.createBinaryProfile();
                        this.exclude_ = exclude |= 1;
                        this.createForeignNullOrInvalidPrototype0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.createForeignNullOrInvalidPrototype(arguments0Value, arguments1Value, createForeignNullOrInvalidPrototype1_interop__, this.createForeignNullOrInvalidPrototype1_isNull_);
                        return dynamicObject;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject dynamicObject;
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSTypes.isDynamicObject(arguments1Value)) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSObject(arguments1Value_)) {
                            this.state_0_ = state_0 |= 8;
                            lock.unlock();
                            hasLock = false;
                            DynamicObject dynamicObject2 = this.createObjectObject(arguments0Value_, arguments1Value_);
                            return dynamicObject2;
                        }
                    }
                    if (JSGuards.isJSObject(arguments0Value_) && !JSGuards.isJSNull(arguments1Value)) {
                        this.state_0_ = state_0 |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        dynamicObject = this.createObjectNotNull(arguments0Value_, arguments1Value);
                        return dynamicObject;
                    }
                    if (JSGuards.isJSObject(arguments0Value_) && JSGuards.isJSNull(arguments1Value)) {
                        this.state_0_ = state_0 |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        dynamicObject = this.createObjectNull(arguments0Value_, arguments1Value);
                        return dynamicObject;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CreateForeignNullOrInvalidPrototype0Data s2_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.createForeignNullOrInvalidPrototype0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[7];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "createPrototypeNull";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "createForeignNullOrInvalidPrototype";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                CreateForeignNullOrInvalidPrototype0Data s2_ = this.createForeignNullOrInvalidPrototype0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.interop_, s2_.isNull_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "createForeignNullOrInvalidPrototype";
            if ((state_0 & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.createForeignNullOrInvalidPrototype1_isNull_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "createObjectObject";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "createObjectNotNull";
            s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "createObjectNull";
            s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectCreateNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectCreateNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectCreateNode.class)
        private static final class CreateForeignNullOrInvalidPrototype0Data
        extends Node {
            @Node.Child
            CreateForeignNullOrInvalidPrototype0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile isNull_;

            CreateForeignNullOrInvalidPrototype0Data(CreateForeignNullOrInvalidPrototype0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode.class)
    public static final class ObjectGetOwnPropertyNamesOrSymbolsNodeGen
    extends ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private JSClassProfile jsclassProfile;
        @Node.Child
        private ListSizeNode listSize;
        @Node.Child
        private GetForeignObjectNames0Data getForeignObjectNames0_cache;
        @Node.Child
        private InteropLibrary getForeignObjectNames1_members_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile getForeignObjectNames1_errorBranch_;

        private ObjectGetOwnPropertyNamesOrSymbolsNodeGen(JSContext context, JSBuiltin builtin, boolean symbols, JavaScriptNode[] arguments) {
            super(context, builtin, symbols);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.getJSObject(arguments0Value__, this.jsclassProfile, this.listSize);
            }
            if ((state_0 & 0x1E) != 0) {
                if ((state_0 & 2) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                    return this.getDefault(arguments0Value_, this.jsclassProfile, this.listSize);
                }
                if ((state_0 & 4) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    assert (this.symbols);
                    return this.getForeignObjectSymbols(arguments0Value_);
                }
                if ((state_0 & 8) != 0) {
                    GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                    while (s4_ != null) {
                        if (s4_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            assert (!this.symbols);
                            return this.getForeignObjectNames(arguments0Value_, s4_.interop_, s4_.members_, s4_.errorBranch_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0x10) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    assert (!this.symbols);
                    return this.getForeignObjectNames1Boundary(state_0, arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getForeignObjectNames1Boundary(int state_0, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary getForeignObjectNames1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                DynamicObject dynamicObject = this.getForeignObjectNames(arguments0Value_, getForeignObjectNames1_interop__, this.getForeignObjectNames1_members_, this.getForeignObjectNames1_errorBranch_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    if (this.jsclassProfile == null) {
                        this.jsclassProfile = JSClassProfile.create();
                    }
                    if (this.listSize == null) {
                        this.listSize = (ListSizeNode)super.insert((Node)ListSizeNode.create());
                    }
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getJSObject(arguments0Value_, this.jsclassProfile, this.listSize);
                    return dynamicObject;
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    if (this.jsclassProfile == null) {
                        this.jsclassProfile = JSClassProfile.create();
                    }
                    if (this.listSize == null) {
                        this.listSize = (ListSizeNode)super.insert((Node)ListSizeNode.create());
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.getDefault(arguments0Value, this.jsclassProfile, this.listSize);
                    return arguments0Value_;
                }
                if (JSGuards.isForeignObject(arguments0Value) && this.symbols) {
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.getForeignObjectSymbols(arguments0Value);
                    return arguments0Value_;
                }
                if (exclude == 0) {
                    int count4_ = 0;
                    GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                    if ((state_0 & 8) != 0) {
                        while (s4_ != null) {
                            if (s4_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value)) {
                                assert (!this.symbols);
                                break;
                            }
                            s4_ = s4_.next_;
                            ++count4_;
                        }
                    }
                    if (s4_ == null && JSGuards.isForeignObject(arguments0Value) && !this.symbols && count4_ < 5) {
                        s4_ = (GetForeignObjectNames0Data)super.insert((Node)new GetForeignObjectNames0Data(this.getForeignObjectNames0_cache));
                        s4_.interop_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s4_.members_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s4_.errorBranch_ = BranchProfile.create();
                        this.getForeignObjectNames0_cache = s4_;
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObjectNames(arguments0Value, s4_.interop_, s4_.members_, s4_.errorBranch_);
                        return dynamicObject;
                    }
                }
                InteropLibrary getForeignObjectNames1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value) && !this.symbols) {
                        getForeignObjectNames1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        this.getForeignObjectNames1_members_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                        this.getForeignObjectNames1_errorBranch_ = BranchProfile.create();
                        this.exclude_ = exclude |= 1;
                        this.getForeignObjectNames0_cache = null;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObjectNames(arguments0Value, getForeignObjectNames1_interop__, this.getForeignObjectNames1_members_, this.getForeignObjectNames1_errorBranch_);
                        return dynamicObject;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetForeignObjectNames0Data s4_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s4_ = this.getForeignObjectNames0_cache) == null || s4_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[6];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "getJSObject";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                cached.add(Arrays.asList(new Cloneable[]{this.jsclassProfile, this.listSize}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getDefault";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(new Cloneable[]{this.jsclassProfile, this.listSize}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObjectSymbols";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "getForeignObjectNames";
            if ((state_0 & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                GetForeignObjectNames0Data s4_ = this.getForeignObjectNames0_cache;
                while (s4_ != null) {
                    cached.add(Arrays.asList(s4_.interop_, s4_.members_, s4_.errorBranch_));
                    s4_ = s4_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "getForeignObjectNames";
            if ((state_0 & 0x10) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.getForeignObjectNames1_members_, this.getForeignObjectNames1_errorBranch_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode create(JSContext context, JSBuiltin builtin, boolean symbols, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyNamesOrSymbolsNodeGen(context, builtin, symbols, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyNamesOrSymbolsNode.class)
        private static final class GetForeignObjectNames0Data
        extends Node {
            @Node.Child
            GetForeignObjectNames0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            GetForeignObjectNames0Data(GetForeignObjectNames0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode.class)
    public static final class ObjectGetOwnPropertyDescriptorsNodeGen
    extends ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private GetJSObjectData getJSObject_cache;
        @Node.Child
        private GetForeignObject0Data getForeignObject0_cache;
        @Node.Child
        private GetForeignObject1Data getForeignObject1_cache;
        @Node.Child
        private ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode getDefault_recursive_;

        private ObjectGetOwnPropertyDescriptorsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop
        protected DynamicObject executeEvaluated(Object arguments0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                GetJSObjectData s1_ = this.getJSObject_cache;
                if (s1_ != null && JSGuards.isJSObject(arguments0Value_)) {
                    return this.getJSObject(arguments0Value_, s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                }
            }
            if ((state_0 & 0xE) != 0) {
                GetForeignObject1Data s3_;
                if ((state_0 & 2) != 0) {
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value)) {
                            return this.getForeignObject(arguments0Value, s2_.interop_, s2_.members_, s2_.toJSType_, s2_.errorBranch_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && (s3_ = this.getForeignObject1_cache) != null && JSGuards.isForeignObject(arguments0Value)) {
                    return this.getForeignObject1Boundary(state_0, s3_, arguments0Value);
                }
                if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    return this.getDefault(arguments0Value, this.getDefault_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private DynamicObject getForeignObject1Boundary(int state_0, GetForeignObject1Data s3_, Object arguments0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                DynamicObject dynamicObject = this.getForeignObject(arguments0Value, interop__, s3_.members_, s3_.toJSType_, s3_.errorBranch_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                GetJSObjectData s1_ = this.getJSObject_cache;
                if (s1_ != null && JSGuards.isJSObject(arguments0Value__)) {
                    return this.getJSObject(arguments0Value__, s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                }
            }
            if ((state_0 & 0xE) != 0) {
                GetForeignObject1Data s3_;
                if ((state_0 & 2) != 0) {
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            return this.getForeignObject(arguments0Value_, s2_.interop_, s2_.members_, s2_.toJSType_, s2_.errorBranch_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && (s3_ = this.getForeignObject1_cache) != null && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.getForeignObject1Boundary0(state_0, s3_, arguments0Value_);
                }
                if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                    return this.getDefault(arguments0Value_, this.getDefault_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getForeignObject1Boundary0(int state_0, GetForeignObject1Data s3_, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                DynamicObject dynamicObject = this.getForeignObject(arguments0Value_, interop__, s3_.members_, s3_.toJSType_, s3_.errorBranch_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    GetJSObjectData s1_ = (GetJSObjectData)super.insert((Node)new GetJSObjectData());
                    s1_.getOwnPropertyNode_ = s1_.insertAccessor(JSGetOwnPropertyNode.create());
                    s1_.listSize_ = s1_.insertAccessor(ListSizeNode.create());
                    s1_.listGet_ = s1_.insertAccessor(ListGetNode.create());
                    s1_.classProfile_ = JSClassProfile.create();
                    this.getJSObject_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getJSObject(arguments0Value_, s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_);
                    return dynamicObject;
                }
                if (exclude == 0) {
                    int count2_ = 0;
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    if ((state_0 & 2) != 0) {
                        while (!(s2_ == null || s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && JSGuards.isForeignObject(arguments0Value) && count2_ < 5) {
                        s2_ = (GetForeignObject0Data)super.insert((Node)new GetForeignObject0Data(this.getForeignObject0_cache));
                        s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s2_.members_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s2_.toJSType_ = s2_.insertAccessor(ImportValueNode.create());
                        s2_.errorBranch_ = BranchProfile.create();
                        this.getForeignObject0_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObject(arguments0Value, s2_.interop_, s2_.members_, s2_.toJSType_, s2_.errorBranch_);
                        return dynamicObject;
                    }
                }
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        GetForeignObject1Data s3_ = (GetForeignObject1Data)super.insert((Node)new GetForeignObject1Data());
                        interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        s3_.members_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s3_.toJSType_ = s3_.insertAccessor(ImportValueNode.create());
                        s3_.errorBranch_ = BranchProfile.create();
                        this.getForeignObject1_cache = s3_;
                        this.exclude_ = exclude |= 1;
                        this.getForeignObject0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObject(arguments0Value, interop__, s3_.members_, s3_.toJSType_, s3_.errorBranch_);
                        return dynamicObject;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    this.getDefault_recursive_ = (ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getDefault(arguments0Value, this.getDefault_recursive_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetForeignObject0Data s2_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.getForeignObject0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "getJSObject";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                GetJSObjectData s1_ = this.getJSObject_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s1_.getOwnPropertyNode_, s1_.listSize_, s1_.listGet_, s1_.classProfile_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s2_.interop_, s2_.members_, s2_.toJSType_, s2_.errorBranch_}));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state_0 & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                GetForeignObject1Data s3_ = this.getForeignObject1_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(new Cloneable[]{s3_.members_, s3_.toJSType_, s3_.errorBranch_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getDefault";
            if ((state_0 & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.getDefault_recursive_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyDescriptorsNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode.class)
        private static final class GetForeignObject1Data
        extends Node {
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            ImportValueNode toJSType_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            GetForeignObject1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode.class)
        private static final class GetForeignObject0Data
        extends Node {
            @Node.Child
            GetForeignObject0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            InteropLibrary members_;
            @Node.Child
            ImportValueNode toJSType_;
            @CompilerDirectives.CompilationFinal
            BranchProfile errorBranch_;

            GetForeignObject0Data(GetForeignObject0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorsNode.class)
        private static final class GetJSObjectData
        extends Node {
            @Node.Child
            JSGetOwnPropertyNode getOwnPropertyNode_;
            @Node.Child
            ListSizeNode listSize_;
            @Node.Child
            ListGetNode listGet_;
            @CompilerDirectives.CompilationFinal
            JSClassProfile classProfile_;

            GetJSObjectData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode.class)
    public static final class ObjectGetOwnPropertyDescriptorNodeGen
    extends ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private GetForeignObject0Data getForeignObject0_cache;
        @Node.Child
        private ImportValueNode getForeignObject1_toJSType_;

        private ObjectGetOwnPropertyDescriptorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                DynamicObject arguments0Value__;
                if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.getJSObject(arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 0xE) != 0) {
                    if ((state_0 & 2) != 0) {
                        GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                        while (s2_ != null) {
                            if (s2_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                                return this.getForeignObject(arguments0Value_, arguments1Value_, s2_.interop_, s2_.toJSType_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                        return this.getForeignObject1Boundary(state_0, arguments0Value_, arguments1Value_);
                    }
                    if ((state_0 & 8) != 0 && !JSGuards.isJSObject(arguments0Value_) && !JSGuards.isForeignObject(arguments0Value_)) {
                        return this.getDefault(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object getForeignObject1Boundary(int state_0, Object arguments0Value_, Object arguments1Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary getForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                DynamicObject dynamicObject = this.getForeignObject(arguments0Value_, arguments1Value_, getForeignObject1_interop__, this.getForeignObject1_toJSType_);
                return dynamicObject;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getJSObject(arguments0Value_, arguments1Value);
                    return dynamicObject;
                }
                if (exclude == 0) {
                    int count2_ = 0;
                    GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                    if ((state_0 & 2) != 0) {
                        while (!(s2_ == null || s2_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && JSGuards.isForeignObject(arguments0Value) && count2_ < 5) {
                        s2_ = (GetForeignObject0Data)super.insert((Node)new GetForeignObject0Data(this.getForeignObject0_cache));
                        s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        s2_.toJSType_ = s2_.insertAccessor(ImportValueNode.create());
                        this.getForeignObject0_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObject(arguments0Value, arguments1Value, s2_.interop_, s2_.toJSType_);
                        return dynamicObject;
                    }
                }
                InteropLibrary getForeignObject1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        getForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        this.getForeignObject1_toJSType_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                        this.exclude_ = exclude |= 1;
                        this.getForeignObject0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.getForeignObject(arguments0Value, arguments1Value, getForeignObject1_interop__, this.getForeignObject1_toJSType_);
                        return dynamicObject;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if (!JSGuards.isJSObject(arguments0Value) && !JSGuards.isForeignObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getDefault(arguments0Value, arguments1Value);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            GetForeignObject0Data s2_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.getForeignObject0_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "getJSObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                GetForeignObject0Data s2_ = this.getForeignObject0_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(new Node[]{s2_.interop_, s2_.toJSType_}));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "getForeignObject";
            if ((state_0 & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.getForeignObject1_toJSType_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "getDefault";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetOwnPropertyDescriptorNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetOwnPropertyDescriptorNode.class)
        private static final class GetForeignObject0Data
        extends Node {
            @Node.Child
            GetForeignObject0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            ImportValueNode toJSType_;

            GetForeignObject0Data(GetForeignObject0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ObjectFunctionBuiltins.ObjectGetPrototypeOfNode.class)
    public static final class ObjectGetPrototypeOfNodeGen
    extends ObjectFunctionBuiltins.ObjectGetPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private GetPrototypeNode getPrototypeOfJSObject_getPrototypeNode_;

        private ObjectGetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && !JSGuards.isJSObject(arguments0Value_)) {
                return this.getPrototypeOfNonObject(arguments0Value_);
            }
            if ((state_0 & 2) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSObject(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.getPrototypeOfJSObject(arguments0Value__, this.getPrototypeOfJSObject_getPrototypeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                DynamicObject arguments0Value_;
                if (!JSGuards.isJSObject(arguments0Value)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getPrototypeOfNonObject(arguments0Value);
                    return dynamicObject;
                }
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSObject(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.getPrototypeOfJSObject_getPrototypeNode_ = (GetPrototypeNode)super.insert((Node)GetPrototypeNode.create());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.getPrototypeOfJSObject(arguments0Value_, this.getPrototypeOfJSObject_getPrototypeNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s = new Object[3];
            s[0] = "getPrototypeOfNonObject";
            s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "getPrototypeOfJSObject";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<GetPrototypeNode>> cached = new ArrayList<List<GetPrototypeNode>>();
                cached.add(Arrays.asList(this.getPrototypeOfJSObject_getPrototypeNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ObjectFunctionBuiltins.ObjectGetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ObjectGetPrototypeOfNodeGen(context, builtin, arguments);
        }
    }
}

