/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.connectivity.internal.platform.schema.SemanticTermsHelper;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.property.SourceClusterSupportModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SdkSourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaExecutableComponentModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.source.JavaParserSourceUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.type.CustomStaticTypeUtils;
import org.mule.runtime.module.extension.internal.loader.utils.JavaModelLoaderUtils;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSdkSourceFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.source.ClusterSupport;
import org.mule.sdk.api.annotation.source.SourceClusterSupport;

public class JavaSourceModelParser
extends AbstractJavaExecutableComponentModelParser
implements SourceModelParser {
    private final SourceElement sourceElement;
    private final Class<?> sourceClass;
    private final Optional<ExtensionParameter> configParameter;
    private final Optional<ExtensionParameter> connectionParameter;

    public JavaSourceModelParser(ExtensionElement extensionElement, SourceElement sourceElement, ExtensionLoadingContext loadingContext) {
        super(extensionElement, loadingContext);
        this.sourceElement = sourceElement;
        this.sourceClass = sourceElement.getDeclaringClass().orElse(null);
        this.configParameter = JavaExtensionModelParserUtils.getConfigParameter(sourceElement);
        this.connectionParameter = JavaExtensionModelParserUtils.getConnectionParameter(sourceElement);
        this.parseStructure();
        this.collectAdditionalModelProperties();
    }

    @Override
    public String getName() {
        return this.sourceElement.getAlias();
    }

    @Override
    public String getDescription() {
        return this.sourceElement.getDescription();
    }

    @Override
    public boolean emitsResponse() {
        return JavaModelLoaderUtils.emitsResponse(this.sourceElement);
    }

    @Override
    public Optional<SdkSourceFactoryModelProperty> getSourceFactoryModelProperty() {
        if (this.sourceClass == null) {
            return Optional.empty();
        }
        return Optional.of(new SdkSourceFactoryModelProperty(new DefaultSdkSourceFactory(this.sourceClass)));
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return JavaExtensionModelParserUtils.getSourceParameterGroupParsers(this.sourceElement.getParameters(), ParameterDeclarationContext.forSource(this.getName()));
    }

    @Override
    public Optional<SourceModelParser.SourceCallbackModelParser> getOnSuccessCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnResponseMethod());
    }

    @Override
    public Optional<SourceModelParser.SourceCallbackModelParser> getOnErrorCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnErrorMethod());
    }

    @Override
    public Optional<SourceModelParser.SourceCallbackModelParser> getOnTerminateCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnTerminateMethod());
    }

    @Override
    public Optional<SourceModelParser.SourceCallbackModelParser> getOnBackPressureCallbackParser() {
        return this.parseSourceCallback(this.sourceElement.getOnBackPressureMethod());
    }

    @Override
    public boolean isIgnored() {
        return IntrospectionUtils.isIgnored(this.sourceElement, this.loadingContext);
    }

    @Override
    public Optional<MediaTypeModelProperty> getMediaTypeModelProperty() {
        return JavaExtensionModelParserUtils.getMediaTypeModelProperty(this.sourceElement, "Source", this.getName());
    }

    @Override
    public Optional<ExceptionHandlerModelProperty> getExceptionHandlerModelProperty() {
        return JavaErrorModelParserUtils.getExceptionHandlerModelProperty(this.sourceElement, "Source", this.getName());
    }

    @Override
    public boolean hasConfig() {
        return this.configParameter.isPresent();
    }

    @Override
    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(SemanticTermsHelper.getAllTermsFromAnnotations(this.sourceElement::isAnnotatedWith));
        SemanticTermsParserUtils.addCustomTerms(this.sourceElement, terms);
        return terms;
    }

    private void collectAdditionalModelProperties() {
        this.additionalModelProperties.add(new ExtensionTypeDescriptorModelProperty(this.sourceElement));
        if (this.sourceClass != null) {
            this.additionalModelProperties.add(new ImplementingTypeModelProperty(this.sourceClass));
        }
        this.additionalModelProperties.add(new SourceCallbackModelProperty(this.extractJavaMethod(this.sourceElement.getOnResponseMethod()), this.extractJavaMethod(this.sourceElement.getOnErrorMethod()), this.extractJavaMethod(this.sourceElement.getOnTerminateMethod()), this.extractJavaMethod(this.sourceElement.getOnBackPressureMethod())));
    }

    private Optional<Method> extractJavaMethod(Optional<MethodElement> method) {
        return method.flatMap(MethodElement::getMethod);
    }

    @Override
    public List<String> getEmittedNotifications() {
        return NotificationModelParserUtils.getEmittedNotifications(this.sourceElement, this.getComponentTypeName(), this.getName());
    }

    @Override
    protected String getComponentTypeName() {
        return "Source";
    }

    private void parseStructure() {
        this.validateLifecycle(this.sourceElement, Startable.class);
        this.validateLifecycle(this.sourceElement, Stoppable.class);
        List<Type> sourceGenerics = this.sourceElement.getSuperClassGenerics();
        if (sourceGenerics.size() != 2) {
            throw new IllegalModelDefinitionException(String.format("Message source class '%s' was expected to have 2 generic types (one for the Payload type and another for the Attributes type) but %d were found", this.getName(), sourceGenerics.size()));
        }
        this.resolveOutputTypes();
        this.parseComponentByteStreaming(this.sourceElement);
        this.connected = this.connectionParameter.isPresent();
        this.parseComponentConnectivity(this.sourceElement);
    }

    private void resolveOutputTypes() {
        this.outputType = new DefaultOutputModelParser(CustomStaticTypeUtils.getSourceOutputType(this.sourceElement), false);
        this.outputAttributesType = new DefaultOutputModelParser(CustomStaticTypeUtils.getSourceAttributesType(this.sourceElement), false);
    }

    private void validateLifecycle(SourceElement sourceType, Class<?> lifecycleType) {
        if (sourceType.isAssignableTo(lifecycleType)) {
            throw new IllegalSourceModelDefinitionException(String.format("Source class '%s' implements lifecycle interface '%s'. Sources are only not allowed to implement '%s' and '%s'", sourceType.getName(), lifecycleType, Initialisable.class.getSimpleName(), Disposable.class.getSimpleName()));
        }
    }

    private Optional<SourceModelParser.SourceCallbackModelParser> parseSourceCallback(Optional<MethodElement> methodElement) {
        return methodElement.map(method -> new JavaSourceCallbackModelParser(JavaExtensionModelParserUtils.getParameterGroupParsers(method.getParameters(), ParameterDeclarationContext.forSource(this.getName()))));
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.sourceElement);
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.sourceElement, "source", this.sourceElement.getName());
    }

    @Override
    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return JavaStereotypeModelParserUtils.resolveStereotype(this.sourceElement, "Source", this.getName(), factory);
    }

    @Override
    public Optional<BackPressureStrategyModelProperty> getBackPressureStrategyModelProperty() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.sourceElement, "source", this.sourceElement.getName(), BackPressure.class, org.mule.sdk.api.annotation.source.BackPressure.class, legacyAnnotation -> new BackPressureStrategyModelProperty(legacyAnnotation.getEnumValue(BackPressure::defaultMode), new LinkedHashSet(legacyAnnotation.getEnumArrayValue(BackPressure::supportedModes))), sdkAnnotation -> new BackPressureStrategyModelProperty(JavaParserSourceUtils.fromSdkBackPressureMode(sdkAnnotation.getEnumValue(org.mule.sdk.api.annotation.source.BackPressure::defaultMode)), new LinkedHashSet(sdkAnnotation.getEnumArrayValue(org.mule.sdk.api.annotation.source.BackPressure::supportedModes).stream().map(JavaParserSourceUtils::fromSdkBackPressureMode).collect(Collectors.toList()))));
    }

    @Override
    public SourceClusterSupportModelProperty getSourceClusterSupportModelProperty() {
        SourceClusterSupport resultingSourceClusterSupport;
        Optional<SourceClusterSupport> sourceClusterSupport = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.sourceElement, "source", this.sourceElement.getName(), org.mule.runtime.extension.api.annotation.source.ClusterSupport.class, ClusterSupport.class, legacyAnnotation -> JavaParserSourceUtils.fromLegacySourceClusterSupport(legacyAnnotation.getEnumValue(org.mule.runtime.extension.api.annotation.source.ClusterSupport::value)), sdkAnnotation -> sdkAnnotation.getEnumValue(ClusterSupport::value));
        switch (sourceClusterSupport.orElse(SourceClusterSupport.DEFAULT_ALL_NODES)) {
            case DEFAULT_PRIMARY_NODE_ONLY: {
                resultingSourceClusterSupport = SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY;
                break;
            }
            case DEFAULT_ALL_NODES: {
                resultingSourceClusterSupport = SourceClusterSupport.DEFAULT_ALL_NODES;
                break;
            }
            default: {
                resultingSourceClusterSupport = SourceClusterSupport.NOT_SUPPORTED;
            }
        }
        return new SourceClusterSupportModelProperty(resultingSourceClusterSupport);
    }

    public boolean equals(Object o) {
        if (o instanceof JavaSourceModelParser) {
            return this.sourceElement.equals(((JavaSourceModelParser)o).sourceElement);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sourceElement);
    }

    private static class JavaSourceCallbackModelParser
    implements SourceModelParser.SourceCallbackModelParser {
        private final List<ParameterGroupModelParser> groupModelParsers;

        public JavaSourceCallbackModelParser(List<ParameterGroupModelParser> groupModelParsers) {
            this.groupModelParsers = groupModelParsers;
        }

        @Override
        public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
            return this.groupModelParsers;
        }
    }
}

