/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.CoreProfilingService;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.internal.profiling.tracing.DefaultComponentMetadata;
import org.mule.runtime.core.internal.profiling.tracing.DefaultExecutionContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ComponentProcessingStrategyReactiveProcessorBuilder {
    private final ReactiveProcessor processor;
    private final Scheduler contextScheduler;
    private final String artifactId;
    private final String artifactType;
    private int parallelism = 1;
    private ScheduledExecutorService dispatcherScheduler;
    private ScheduledExecutorService callbackScheduler;
    private CoreProfilingService profilingService;

    public ComponentProcessingStrategyReactiveProcessorBuilder(ReactiveProcessor processor, Scheduler contextScheduler, String artifactId, String artifactType) {
        this.processor = processor;
        this.contextScheduler = contextScheduler;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    public static ComponentProcessingStrategyReactiveProcessorBuilder processingStrategyReactiveProcessorFrom(ReactiveProcessor processor, Scheduler contextScheduler, String artifactId, String artifactType) {
        return new ComponentProcessingStrategyReactiveProcessorBuilder(processor, contextScheduler, artifactId, artifactType);
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withDispatcherScheduler(ScheduledExecutorService dispatcherScheduler) {
        this.dispatcherScheduler = dispatcherScheduler;
        return this;
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withCallbackScheduler(ScheduledExecutorService callbackScheduler) {
        this.callbackScheduler = callbackScheduler;
        return this;
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withProfilingService(CoreProfilingService profilingService) {
        this.profilingService = profilingService;
        return this;
    }

    public ReactiveProcessor build() {
        if (this.parallelism == 1) {
            return publisher -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)publisher)).build();
        }
        return publisher -> Flux.from((Publisher)publisher).flatMap(e -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildMono(e)).build(), this.parallelism);
    }

    private <T extends Publisher<?>> ReactorPublisherBuilder<T> baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder<T> builder) {
        ProfilingDataProducer psSchedulingOperationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION);
        ProfilingDataProducer startingOperationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION);
        ProfilingDataProducer operationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED);
        ProfilingDataProducer psFlowMessagePassingDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING);
        ComponentLocation location = ProfilingUtils.getLocation(this.processor);
        Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transformer = coreEvent -> new DefaultComponentProcessingStrategyProfilingEventContext((CoreEvent)coreEvent, location, Thread.currentThread().getName(), this.artifactId, this.artifactType, System.currentTimeMillis());
        return builder.setTracingContext(this.profilingService, coreEvent -> new DefaultExecutionContext(new DefaultComponentMetadata(coreEvent.getCorrelationId(), this.artifactId, this.artifactType, location))).profileProcessingStrategyEvent(this.profilingService, (ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent>)psSchedulingOperationExecutionDataProducer, transformer).publishOn(Optional.ofNullable(this.dispatcherScheduler)).profileProcessingStrategyEvent(this.profilingService, (ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent>)startingOperationExecutionDataProducer, transformer).transform(this.processor).profileProcessingStrategyEvent(this.profilingService, (ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent>)operationExecutionDataProducer, transformer).publishOn(Optional.ofNullable(this.callbackScheduler)).profileProcessingStrategyEvent(this.profilingService, (ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent>)psFlowMessagePassingDataProducer, transformer).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.contextScheduler));
    }
}

