/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.ProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.internal.profiling.CoreProfilingService;
import org.mule.runtime.core.internal.profiling.DefaultProfilingNotificationListener;
import org.mule.runtime.core.internal.profiling.notification.ProfilingNotification;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public abstract class AbstractProfilingService
implements CoreProfilingService,
Initialisable,
Startable,
Stoppable {
    @Inject
    protected ServerNotificationManager notificationManager;
    @Inject
    protected ProfilingFeatureFlaggingService featureFlaggingService;
    @Inject
    protected MuleContext muleContext;
    private final Set<NotificationListener<?>> addedListeners = new HashSet();

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        this.registerDataConsumers(this.getDiscoveryStrategy().discover());
    }

    private void registerDataConsumers(Set<ProfilingDataConsumer<?>> dataConsumers) {
        for (ProfilingDataConsumer<?> dataConsumer : dataConsumers) {
            Set profilingEventTypes = dataConsumer.getProfilingEventTypes();
            for (ProfilingEventType profilingEventType : profilingEventTypes) {
                this.featureFlaggingService.registerProfilingFeature(profilingEventType, dataConsumer.getClass().getName());
            }
        }
        this.registerNotificationListeners(dataConsumers);
        this.onDataConsumersRegistered();
    }

    protected abstract void onDataConsumersRegistered();

    private void registerNotificationListeners(Set<ProfilingDataConsumer<?>> profilingDataConsumers) {
        profilingDataConsumers.forEach(this::registerNotificationListener);
    }

    private <T extends ProfilingEventContext> void registerNotificationListener(ProfilingDataConsumer<T> profilingDataConsumer) {
        DefaultProfilingNotificationListener<T> profilingNotificationListener = new DefaultProfilingNotificationListener<T>(profilingDataConsumer);
        this.notificationManager.addListenerSubscription(profilingNotificationListener, pn -> this.filterByAction(profilingDataConsumer, (ProfilingNotification)((Object)pn)));
        this.addedListeners.add(profilingNotificationListener);
    }

    private <T extends ProfilingEventContext> boolean filterByAction(ProfilingDataConsumer<T> profilingDataConsumer, ProfilingNotification<T> profilingNotification) {
        return profilingDataConsumer.getProfilingEventTypes().stream().anyMatch(eventType -> ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(eventType).equalsIgnoreCase(profilingNotification.getActionName())) && profilingDataConsumer.getEventContextFilter().test((ProfilingEventContext)profilingNotification.getSource());
    }

    public void stop() {
        if (!this.notificationManager.isDisposed()) {
            this.addedListeners.forEach(listener -> this.notificationManager.removeListener((NotificationListener<?>)listener));
        }
    }

    protected abstract ProfilingDataConsumerDiscoveryStrategy getDiscoveryStrategy();

    public <T extends ProfilingEventContext> void notifyEvent(T profilingEventContext, ProfilingEventType<T> action) {
        this.notificationManager.fireNotification((Notification)new ProfilingNotification<T>(profilingEventContext, action));
    }

    public static void configureEnableProfilingService() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag((Feature)MuleRuntimeFeature.ENABLE_PROFILING_SERVICE, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(MuleRuntimeFeature.ENABLE_PROFILING_SERVICE.getEnabledByDefaultSince())).isPresent());
    }
}

