/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.internal.profiling.consumer.ComponentProfilingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerComponentProcessingStrategyDataConsumer
implements ProfilingDataConsumer<ComponentProcessingStrategyProfilingEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerComponentProcessingStrategyDataConsumer.class);
    private final Gson gson = new Gson();

    public void onProfilingEvent(ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> profilingEventType, ComponentProcessingStrategyProfilingEventContext profilingEventContext) {
        Logger logger = this.getDataConsumerLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.gson.toJson(ComponentProfilingUtils.getProcessingStrategyComponentInfoMap(profilingEventType, profilingEventContext)));
        }
    }

    public Set<ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>> getProfilingEventTypes() {
        return ImmutableSet.of((Object)RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, (Object)RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION, (Object)RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED, (Object)RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, (Object)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, (Object)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, (Object[])new ProfilingEventType[]{RuntimeProfilingEventTypes.FLOW_EXECUTED});
    }

    public Predicate<ComponentProcessingStrategyProfilingEventContext> getEventContextFilter() {
        return processingStrategyProfilingEventContext -> true;
    }

    protected Logger getDataConsumerLogger() {
        return LOGGER;
    }
}

