/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TaskSchedulingProfilingEventContext;
import org.mule.runtime.core.internal.profiling.consumer.ComponentProfilingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSchedulingLoggerDataConsumer
implements ProfilingDataConsumer<TaskSchedulingProfilingEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSchedulingLoggerDataConsumer.class);
    private final Gson gson = new Gson();

    public void onProfilingEvent(ProfilingEventType<TaskSchedulingProfilingEventContext> profilingEventType, TaskSchedulingProfilingEventContext profilingEventContext) {
        Logger logger = this.getDataConsumerLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.gson.toJson(ComponentProfilingUtils.getTaskSchedulingInfoMap(profilingEventType, profilingEventContext)));
        }
    }

    public Set<ProfilingEventType<TaskSchedulingProfilingEventContext>> getProfilingEventTypes() {
        return ImmutableSet.of((Object)RuntimeProfilingEventTypes.SCHEDULING_TASK_EXECUTION, (Object)RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION, (Object)RuntimeProfilingEventTypes.TASK_EXECUTED);
    }

    public Predicate<TaskSchedulingProfilingEventContext> getEventContextFilter() {
        return taskSchedulingProfilingEventContext -> taskSchedulingProfilingEventContext.getTaskTracingContext().isPresent();
    }

    protected Logger getDataConsumerLogger() {
        return LOGGER;
    }
}

