/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer.provider;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.threading.ThreadSnapshotCollector;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.profiling.type.context.ExtensionProfilingEventContext;
import org.mule.runtime.api.profiling.type.context.TaskSchedulingProfilingEventContext;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.ComponentThreadingDataProducerProvider;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ExtensionDataProducerProvider;
import org.mule.runtime.core.internal.profiling.ProcessingStrategyDataProducerProvider;
import org.mule.runtime.core.internal.profiling.ProfilingDataProducerProvider;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.core.internal.profiling.TaskSchedulingDataProducerProvider;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public class ProfilingDataProducerResolver {
    private final DefaultProfilingService profilingService;
    private final ThreadSnapshotCollector threadSnapshotCollector;
    private final Map<ProfilingEventType<? extends ProfilingEventContext>, ProfilingDataProducerProvider<?, ?>> profilingDataProducerProviders = new HashMap();
    private final ProfilingFeatureFlaggingService featureFlaggingService;

    public ProfilingDataProducerResolver(DefaultProfilingService profilingService, ThreadSnapshotCollector threadSnapshotCollector, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.profilingService = profilingService;
        this.threadSnapshotCollector = threadSnapshotCollector;
        this.featureFlaggingService = featureFlaggingService;
        this.defineProfilerDataProducersProviders();
    }

    private void defineProfilerDataProducersProviders() {
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.FLOW_EXECUTED, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.FLOW_EXECUTED, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION, new ProcessingStrategyDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION, new ComponentThreadingDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentThreadingProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION, this.threadSnapshotCollector, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.OPERATION_EXECUTED, new ComponentThreadingDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentThreadingProfilingEventContext>)RuntimeProfilingEventTypes.OPERATION_EXECUTED, this.threadSnapshotCollector, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.OPERATION_THREAD_RELEASE, new ComponentThreadingDataProducerProvider(this.profilingService, (ProfilingEventType<ComponentThreadingProfilingEventContext>)RuntimeProfilingEventTypes.OPERATION_THREAD_RELEASE, this.threadSnapshotCollector, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.EXTENSION_PROFILING_EVENT, new ExtensionDataProducerProvider(this.profilingService, (ProfilingEventType<ExtensionProfilingEventContext>)RuntimeProfilingEventTypes.EXTENSION_PROFILING_EVENT, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.SCHEDULING_TASK_EXECUTION, new TaskSchedulingDataProducerProvider(this.profilingService, (ProfilingEventType<TaskSchedulingProfilingEventContext>)RuntimeProfilingEventTypes.SCHEDULING_TASK_EXECUTION, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION, new TaskSchedulingDataProducerProvider(this.profilingService, (ProfilingEventType<TaskSchedulingProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION, this.featureFlaggingService));
        this.profilingDataProducerProviders.put((ProfilingEventType<? extends ProfilingEventContext>)RuntimeProfilingEventTypes.TASK_EXECUTED, new TaskSchedulingDataProducerProvider(this.profilingService, (ProfilingEventType<TaskSchedulingProfilingEventContext>)RuntimeProfilingEventTypes.TASK_EXECUTED, this.featureFlaggingService));
    }

    public <T extends ProfilingEventContext, S> ResettableProfilingDataProducer<T, S> getProfilingDataProducer(ProfilingEventType<T> profilingEventType, ProfilingProducerScope producerScope) {
        return this.profilingDataProducerProviders.computeIfAbsent(profilingEventType, profEventType -> {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Profiling event type not registered: %s", ProfilingUtils.getFullyQualifiedProfilingEventTypeIdentifier(profilingEventType))));
        }).getProfilingDataProducer(producerScope);
    }
}

