/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.connectivity.internal.platform.schema.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.ExchangeAssetDescriptor;
import org.mule.runtime.connectivity.api.platform.schema.builder.ConnectivitySchemaBuilder;
import org.mule.runtime.connectivity.api.platform.schema.generator.ConnectivitySchemaGenerator;
import org.mule.runtime.connectivity.internal.platform.schema.SemanticTermsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectivitySchemaGenerator
implements ConnectivitySchemaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnectivitySchemaGenerator.class);
    public static final String SCHEMA_GROUP_ID = "com.mulesoft.schemas";
    private final Function<ConnectionProviderModel, Set<String>> connectionTermsExtractor;
    private final Function<ParameterModel, Set<String>> parameterTermsExtractor;
    private final Function<MetadataType, Set<String>> typeTermsExtractor;
    private final Function<ConnectionProviderModel, Boolean> connectionPredicate;
    private final BiFunction<ConnectionProviderModel, ParameterModel, Boolean> parameterPredicate;
    private final Map<MetadataType, String> customRanges = new HashMap<MetadataType, String>();

    public DefaultConnectivitySchemaGenerator(Function<ConnectionProviderModel, Set<String>> connectionTermsExtractor, Function<ParameterModel, Set<String>> parameterTermsExtractor, Function<MetadataType, Set<String>> typeTermsExtractor, Function<ConnectionProviderModel, Boolean> connectionPredicate, BiFunction<ConnectionProviderModel, ParameterModel, Boolean> parameterPredicate) {
        this.connectionTermsExtractor = connectionTermsExtractor;
        this.parameterTermsExtractor = parameterTermsExtractor;
        this.typeTermsExtractor = typeTermsExtractor;
        this.connectionPredicate = connectionPredicate;
        this.parameterPredicate = parameterPredicate;
    }

    @Override
    public List<ConnectivitySchema> generateSchemas(final ExtensionModel extensionModel, final ExchangeAssetDescriptor assetDescriptor) {
        final ArrayList<ConnectivitySchema> schemas = new ArrayList<ConnectivitySchema>();
        new IdempotentExtensionWalker(){

            protected void onConnectionProvider(ConnectionProviderModel model) {
                if (((Boolean)DefaultConnectivitySchemaGenerator.this.connectionPredicate.apply(model)).booleanValue()) {
                    schemas.add(DefaultConnectivitySchemaGenerator.this.createSchema(extensionModel, model, assetDescriptor));
                }
            }
        }.walk(extensionModel);
        return schemas;
    }

    private ConnectivitySchema createSchema(ExtensionModel extensionModel, ConnectionProviderModel connectionProviderModel, ExchangeAssetDescriptor assetDescriptor) {
        String connectionTerm = this.getConnectionTerm(connectionProviderModel);
        String connectionType = this.extractConnectionType(connectionTerm);
        ConnectivitySchemaBuilder builder = ConnectivitySchemaBuilder.newInstance();
        String artifactId = this.buildSchemaArtifactId(assetDescriptor, connectionType);
        String version = extensionModel.getVersion();
        LOGGER.debug("Declaring schema {}:{}:{}", new Object[]{SCHEMA_GROUP_ID, artifactId, version});
        builder.gav(SCHEMA_GROUP_ID, artifactId, version).authenticationType(connectionType).connectionClassTerm(connectionTerm).connectionProviderName(connectionProviderModel.getName()).system(this.getSystemName(extensionModel)).addAsset(assetDescriptor);
        this.parseParameters(connectionProviderModel, builder);
        this.customRanges.clear();
        return builder.build();
    }

    private String extractConnectionType(String connectionTerm) {
        if (connectionTerm.startsWith("connectivity.")) {
            connectionTerm = connectionTerm.substring("connectivity.".length());
        }
        return connectionTerm;
    }

    private void parseParameters(ConnectionProviderModel model, ConnectivitySchemaBuilder builder) {
        HashSet seenTerms = new HashSet();
        model.getAllParameterModels().forEach(param -> {
            if (!this.shouldIncludeInSchema(model, (ParameterModel)param)) {
                return;
            }
            builder.withParameter(param.getName(), attr -> {
                attr.setMandatory(param.isRequired()).setPropertyTerm(this.getParameterTerm((ParameterModel)param, seenTerms)).setRange(this.asRange(param.getType(), builder, param.getName()));
                param.getType().getAnnotation(EnumAnnotation.class).ifPresent(enumAnnotation -> attr.enumOf((String[])Arrays.stream(enumAnnotation.getValues()).toArray(String[]::new)));
            });
        });
    }

    private String buildSchemaArtifactId(ExchangeAssetDescriptor assetDescriptor, String connectionType) {
        return assetDescriptor.getAssetId() + ("-" + NameUtils.hyphenize((String)connectionType)).replaceAll("-o-auth-", "-oauth-");
    }

    private String asRange(MetadataType type, final ConnectivitySchemaBuilder builder, final String memberName) {
        final Reference term = new Reference();
        type.accept(new MetadataTypeVisitor(){

            public void visitString(StringType stringType) {
                term.set((Object)"string");
            }

            public void visitNumber(NumberType numberType) {
                term.set((Object)"number");
            }

            public void visitBoolean(BooleanType booleanType) {
                term.set((Object)"boolean");
            }

            public void visitObject(ObjectType objectType) {
                term.set((Object)DefaultConnectivitySchemaGenerator.this.customRanges.computeIfAbsent(objectType, k -> {
                    String rangeName = this.getRangeName(objectType);
                    DefaultConnectivitySchemaGenerator.this.declareCustomRange(objectType, rangeName, builder);
                    return rangeName;
                }));
            }

            private String getRangeName(ObjectType objectType) {
                return MetadataTypeUtils.getTypeId((MetadataType)objectType).map(typeId -> {
                    String[] classSegments = typeId.split("\\.");
                    if (classSegments.length > 1) {
                        typeId = classSegments[classSegments.length - 1];
                    }
                    return typeId;
                }).orElse(StringUtils.capitalize((String)memberName));
            }
        });
        return (String)term.get();
    }

    private void declareCustomRange(ObjectType objectType, String rangeName, ConnectivitySchemaBuilder builder) {
        LOGGER.debug("Declaring custom range '{}'", (Object)rangeName);
        builder.withCustomRange(rangeName, range -> {
            range.setClassTerm(this.getTypeTerm((MetadataType)objectType, null, rangeName));
            objectType.getFields().forEach(field -> {
                MetadataType fieldType = field.getValue();
                if (!this.isSupported(fieldType)) {
                    return;
                }
                String fieldName = field.getKey().getName().toString();
                HashSet seenTerms = new HashSet();
                range.addParameter(fieldName, attr -> attr.setPropertyTerm(this.getTypeTerm((MetadataType)field, seenTerms, fieldName)).setMandatory(field.isRequired()).setRange(this.asRange(fieldType, builder, fieldName)));
            });
        });
    }

    private boolean shouldIncludeInSchema(ConnectionProviderModel connectionProviderModel, ParameterModel parameterModel) {
        if (!this.parameterPredicate.apply(connectionProviderModel, parameterModel).booleanValue()) {
            return false;
        }
        if (parameterModel.getName().toLowerCase().contains("timeout")) {
            return false;
        }
        return this.isSupported(parameterModel.getType()) ? !this.isInfrastructure(parameterModel) : false;
    }

    private boolean isInfrastructure(ParameterModel parameterModel) {
        return parameterModel.getModelProperties().stream().anyMatch(p -> "infrastructureParameter".equals(p.getName()));
    }

    private boolean isSupported(MetadataType type) {
        if (type instanceof StringType || type instanceof NumberType || type instanceof BooleanType) {
            return true;
        }
        if (type instanceof ObjectType) {
            return !((ObjectType)type).getFields().isEmpty();
        }
        return false;
    }

    private String getConnectionTerm(ConnectionProviderModel model) {
        return SemanticTermsHelper.getConnectionTerms(this.connectionTermsExtractor.apply(model)).stream().filter(t -> t.endsWith("Connection")).findFirst().orElse("connectivity.Connection");
    }

    private String getParameterTerm(ParameterModel model, Set<String> seenTerms) {
        return this.getTermForProperty(SemanticTermsHelper.getParameterTerms(this.parameterTermsExtractor.apply(model)), seenTerms, model.getName());
    }

    private String getTermForProperty(Set<String> terms, Set<String> seenTerms, String propertyName) {
        if (!terms.isEmpty()) {
            for (String term : terms) {
                if (seenTerms == null) {
                    return term;
                }
                if (seenTerms.add(term)) {
                    return term;
                }
                LOGGER.debug("Property {} contains term {} which has already been used in its owner node. Term discarded for this property", (Object)propertyName);
            }
        }
        LOGGER.debug("No property term could be determined for Parameter {}", (Object)propertyName);
        return null;
    }

    private String getTypeTerm(MetadataType type, Set<String> seenTerms, String typeName) {
        return this.getTermForProperty(SemanticTermsHelper.getParameterTerms(this.typeTermsExtractor.apply(type)), seenTerms, typeName);
    }

    private String getSystemName(ExtensionModel extensionModel) {
        return extensionModel.getName().replaceAll("Connector", "").replaceAll("connector", "").replaceAll("Mule", "").replaceAll("mule", "").trim();
    }
}

