/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;

public class GroupBoundaries
implements JsonConvertible {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private final CompilationFinalBitSet updateIndices;
    private final CompilationFinalBitSet clearIndices;
    private final int cachedHash;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] updateArrayByte;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] clearArrayByte;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private short[] updateArray;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private short[] clearArray;

    GroupBoundaries(CompilationFinalBitSet updateIndices, CompilationFinalBitSet clearIndices) {
        this.updateIndices = updateIndices;
        this.clearIndices = clearIndices;
        this.cachedHash = Objects.hashCode(updateIndices) * 31 + Objects.hashCode(clearIndices);
    }

    public static GroupBoundaries[] createCachedGroupBoundaries() {
        GroupBoundaries[] instances = new GroupBoundaries[CompilationFinalBitSet.getNumberOfStaticInstances()];
        for (int i = 0; i < instances.length; ++i) {
            instances[i] = new GroupBoundaries(CompilationFinalBitSet.getStaticInstance(i), CompilationFinalBitSet.getEmptyInstance());
        }
        return instances;
    }

    public static GroupBoundaries getStaticInstance(RegexLanguage language, CompilationFinalBitSet updateIndices, CompilationFinalBitSet clearIndices) {
        int key;
        if (clearIndices.isEmpty() && (key = updateIndices.getStaticCacheKey()) >= 0) {
            return language.getCachedGroupBoundaries()[key];
        }
        return null;
    }

    public static GroupBoundaries getEmptyInstance(RegexLanguage language) {
        return language.getCachedGroupBoundaries()[0];
    }

    public boolean isEmpty() {
        return this.updateIndices.isEmpty() && this.clearIndices.isEmpty();
    }

    public byte[] updatesToByteArray() {
        if (this.updateArrayByte == null) {
            this.updateArrayByte = GroupBoundaries.indicesToByteArray(this.updateIndices);
        }
        return this.updateArrayByte;
    }

    public byte[] clearsToByteArray() {
        if (this.clearArrayByte == null) {
            this.clearArrayByte = GroupBoundaries.indicesToByteArray(this.clearIndices);
        }
        return this.clearArrayByte;
    }

    private static byte[] indicesToByteArray(CompilationFinalBitSet indices) {
        if (indices.isEmpty()) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[indices.numberOfSetBits()];
        int i = 0;
        PrimitiveIterator.OfInt ofInt = indices.iterator();
        while (ofInt.hasNext()) {
            int j = (Integer)ofInt.next();
            assert (j < 256);
            array[i++] = (byte)j;
        }
        return array;
    }

    public void materializeArrays() {
        if (this.updateArray == null) {
            this.updateArray = GroupBoundaries.indicesToShortArray(this.updateIndices);
            this.clearArray = GroupBoundaries.indicesToShortArray(this.clearIndices);
        }
    }

    private static short[] indicesToShortArray(CompilationFinalBitSet indices) {
        if (indices.isEmpty()) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] array = new short[indices.numberOfSetBits()];
        GroupBoundaries.writeIndicesToArray(indices, array, 0);
        return array;
    }

    private static void writeIndicesToArray(CompilationFinalBitSet indices, short[] array, int offset) {
        int i = offset;
        PrimitiveIterator.OfInt ofInt = indices.iterator();
        while (ofInt.hasNext()) {
            int j = (Integer)ofInt.next();
            assert (j < 65536);
            array[i++] = (short)j;
        }
    }

    public CompilationFinalBitSet getUpdateIndices() {
        return this.updateIndices;
    }

    public CompilationFinalBitSet getClearIndices() {
        return this.clearIndices;
    }

    public boolean hasIndexUpdates() {
        return !this.updateIndices.isEmpty();
    }

    public boolean hasIndexClears() {
        return !this.clearIndices.isEmpty();
    }

    public void updateBitSets(CompilationFinalBitSet foreignUpdateIndices, CompilationFinalBitSet foreignClearIndices) {
        foreignUpdateIndices.union(this.updateIndices);
        foreignClearIndices.subtract(this.updateIndices);
        foreignClearIndices.union(this.clearIndices);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupBoundaries)) {
            return false;
        }
        GroupBoundaries o = (GroupBoundaries)obj;
        return Objects.equals(this.updateIndices, o.updateIndices) && Objects.equals(this.clearIndices, o.clearIndices);
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public void applyToResultFactory(PreCalculatedResultFactory resultFactory, int index) {
        if (this.hasIndexUpdates()) {
            resultFactory.updateIndices(this.updateIndices, index);
        }
    }

    @ExplodeLoop
    public void applyExploded(int[] array, int offset, int index) {
        int i;
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((Object)this.clearArray);
        CompilerAsserts.partialEvaluationConstant((Object)this.updateArray);
        for (i = 0; i < this.clearArray.length; ++i) {
            array[offset + Short.toUnsignedInt((short)this.clearArray[i])] = -1;
        }
        for (i = 0; i < this.updateArray.length; ++i) {
            array[offset + Short.toUnsignedInt((short)this.updateArray[i])] = index;
        }
    }

    public void apply(int[] array, int offset, int index) {
        int i;
        for (i = 0; i < this.clearArray.length; ++i) {
            array[offset + Short.toUnsignedInt((short)this.clearArray[i])] = -1;
        }
        for (i = 0; i < this.updateArray.length; ++i) {
            array[offset + Short.toUnsignedInt((short)this.updateArray[i])] = index;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasIndexUpdates()) {
            GroupBoundaries.appendBitSet(sb, this.updateIndices, false).append(")(");
            GroupBoundaries.appendBitSet(sb, this.updateIndices, true);
        }
        if (this.hasIndexClears()) {
            sb.append(" clr{");
            GroupBoundaries.appendBitSet(sb, this.clearIndices, false).append(")(");
            GroupBoundaries.appendBitSet(sb, this.clearIndices, true);
            sb.append("}");
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static StringBuilder appendBitSet(StringBuilder sb, CompilationFinalBitSet gbBitSet, boolean entries) {
        boolean first = true;
        if (gbBitSet != null) {
            PrimitiveIterator.OfInt ofInt = gbBitSet.iterator();
            while (ofInt.hasNext()) {
                int i = (Integer)ofInt.next();
                if ((i & 1) != (entries ? 0 : 1)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(Json.val(i / 2));
            }
        }
        return sb;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("updateEnter", GroupBoundaries.gbBitSetGroupEntriesToJsonArray(this.updateIndices)), Json.prop("updateExit", GroupBoundaries.gbBitSetGroupExitsToJsonArray(this.updateIndices)), Json.prop("clearEnter", GroupBoundaries.gbBitSetGroupEntriesToJsonArray(this.clearIndices)), Json.prop("clearExit", GroupBoundaries.gbBitSetGroupExitsToJsonArray(this.clearIndices)));
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupEntriesToJsonArray(CompilationFinalBitSet gbArray) {
        return GroupBoundaries.gbBitSetGroupPartToJsonArray(gbArray, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupExitsToJsonArray(CompilationFinalBitSet gbArray) {
        return GroupBoundaries.gbBitSetGroupPartToJsonArray(gbArray, false);
    }

    @CompilerDirectives.TruffleBoundary
    private static JsonArray gbBitSetGroupPartToJsonArray(CompilationFinalBitSet gbBitSet, boolean entries) {
        JsonArray array = Json.array(new JsonConvertible[0]);
        if (gbBitSet != null) {
            PrimitiveIterator.OfInt ofInt = gbBitSet.iterator();
            while (ofInt.hasNext()) {
                int i = (Integer)ofInt.next();
                if ((i & 1) != (entries ? 0 : 1)) continue;
                array.append(Json.val(i / 2));
            }
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    public JsonArray indexUpdateSourceSectionsToJson(RegexAST ast) {
        if (!this.hasIndexUpdates()) {
            return Json.array(new JsonConvertible[0]);
        }
        return RegexAST.sourceSectionsToJson(this.getUpdateIndices().stream().mapToObj(x -> ast.getSourceSections(ast.getGroupByBoundaryIndex(x)).get(x & 1)));
    }
}

