/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.routing.Foreach;
import org.mule.runtime.core.internal.routing.ForeachContext;
import org.mule.runtime.core.internal.routing.ForeachInternalContextManager;
import org.mule.runtime.core.internal.routing.ForeachUtils;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurer;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class ForeachRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForeachRouter.class);
    static final String MAP_NOT_SUPPORTED_MESSAGE = "Foreach does not support 'java.util.Map' with no collection expression. To iterate over Map entries use '#[dw::core::Objects::entrySet(payload)]'";
    private final Foreach owner;
    private final StreamingManager streamingManager;
    private Flux<CoreEvent> upstreamFlux;
    private Flux<CoreEvent> innerFlux;
    private Flux<CoreEvent> downstreamFlux;
    private final FluxSinkRecorder<CoreEvent> innerRecorder = new FluxSinkRecorder();
    private final FluxSinkRecorder<Either<Throwable, CoreEvent>> downstreamRecorder = new FluxSinkRecorder();
    private final AtomicReference<Context> downstreamCtxReference = new AtomicReference<Context>(Context.empty());
    private final AtomicInteger inflightEvents = new AtomicInteger(0);
    private final AtomicBoolean completeDeferred = new AtomicBoolean(false);

    ForeachRouter(Foreach owner, StreamingManager streamingManager, Publisher<CoreEvent> publisher, String expression, int batchSize, MessageProcessorChain nestedChain) {
        this.owner = owner;
        this.streamingManager = streamingManager;
        this.upstreamFlux = Flux.from(publisher).doOnNext(event -> {
            if (owner.validateExpression((CoreEvent)event)) {
                this.downstreamRecorder.next((Object)Either.left((Object)new IllegalArgumentException(MAP_NOT_SUPPORTED_MESSAGE)));
            }
            this.inflightEvents.getAndIncrement();
            CoreEvent responseEvent = this.prepareEvent((CoreEvent)event, expression);
            if (responseEvent != null) {
                this.innerRecorder.next((Object)responseEvent);
            }
        }).doOnComplete(() -> {
            if (this.inflightEvents.get() == 0) {
                this.completeRouter();
            } else {
                this.completeDeferred.set(true);
            }
        });
        this.innerFlux = Flux.create(this.innerRecorder).map(event -> {
            ForeachContext foreachContext = ForeachInternalContextManager.getContext(event);
            Iterator<TypedValue<?>> iterator = foreachContext.getIterator();
            if (!iterator.hasNext() && foreachContext.getElementNumber().get() == 0) {
                this.downstreamRecorder.next((Object)Either.right(Throwable.class, (Object)event));
                this.completeRouterIfNecessary();
            }
            TypedValue currentValue = owner.setCurrentValue(batchSize, foreachContext, (CoreEvent)event);
            return this.createTypedValuePartToProcess(owner, (CoreEvent)event, foreachContext, currentValue);
        }).transform(innerPub -> MessageProcessors.applyWithChildContext((Publisher)innerPub, (ReactiveProcessor)nestedChain, Optional.of(owner.getLocation()))).doOnNext(evt -> {
            try {
                ForeachContext foreachContext = ForeachInternalContextManager.getContext(evt);
                if (foreachContext.getOnComplete().isPresent()) {
                    foreachContext.getOnComplete().get().run();
                }
                if (foreachContext.getIterator().hasNext()) {
                    this.innerRecorder.next(evt);
                } else {
                    this.downstreamRecorder.next((Object)Either.right((Object)evt));
                    this.completeRouterIfNecessary();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception in foreach after iteration", (Throwable)e);
                this.eventWithCurrentContextDeleted((CoreEvent)evt);
                this.downstreamRecorder.next((Object)Either.left((Object)((Object)new MessagingException(evt, (Throwable)e, (Component)owner))));
                this.completeRouterIfNecessary();
            }
        }).onErrorContinue(MessagingException.class, (e, o) -> {
            this.eventWithCurrentContextDeleted(((MessagingException)((Object)e)).getEvent());
            this.downstreamRecorder.next((Object)Either.left((Object)e));
            this.completeRouterIfNecessary();
        });
        this.downstreamFlux = Flux.create(sink -> {
            this.downstreamRecorder.accept(sink);
            this.subscribeUpstreamChains(this.downstreamCtxReference.get());
        }).doOnNext(event -> this.inflightEvents.decrementAndGet()).map(either -> {
            if (either.isLeft()) {
                throw Exceptions.propagate((Throwable)((Throwable)either.getLeft()));
            }
            return this.createResponseEvent((CoreEvent)either.getRight());
        });
    }

    private void completeRouterIfNecessary() {
        if (this.completeDeferred.get() && this.inflightEvents.get() == 0) {
            this.completeRouter();
        }
    }

    private void completeRouter() {
        this.innerRecorder.complete();
        this.downstreamRecorder.complete();
    }

    private CoreEvent eventWithCurrentContextDeleted(CoreEvent event) {
        ForeachInternalContextManager.removeContext(event);
        return event;
    }

    private CoreEvent prepareEvent(CoreEvent event, String expression) {
        CoreEvent responseEvent = CoreEvent.builder((CoreEvent)event).addVariable(this.owner.getRootMessageVariableName(), (Object)event.getMessage(), DataType.MULE_MESSAGE).build();
        try {
            Iterator<TypedValue<?>> typedValueIterator = this.owner.splitRequest(responseEvent, expression);
            if (!typedValueIterator.hasNext()) {
                this.downstreamRecorder.next((Object)Either.right(Throwable.class, (Object)event));
                this.completeRouterIfNecessary();
                return null;
            }
            ForeachContext foreachContext = this.createForeachContext(event, typedValueIterator);
            ForeachInternalContextManager.addContext(responseEvent, foreachContext);
        }
        catch (Exception e) {
            this.eventWithCurrentContextDeleted(responseEvent);
            this.downstreamRecorder.next((Object)Either.left((Object)((Object)new MessagingException(responseEvent, (Throwable)e, (Component)this.owner))));
            this.completeRouterIfNecessary();
            return null;
        }
        return responseEvent;
    }

    private CoreEvent createTypedValuePartToProcess(Foreach owner, CoreEvent event, ForeachContext foreachContext, TypedValue currentValue) {
        Optional<ItemSequenceInfo> itemSequenceInfo = Optional.of(ItemSequenceInfo.of((int)foreachContext.getElementNumber().get()));
        CoreEvent.Builder partEventBuilder = CoreEvent.builder((CoreEvent)event).itemSequenceInfo(itemSequenceInfo);
        TypedValue managedValue = ForeachUtils.manageTypedValueForStreaming(currentValue, event, this.streamingManager);
        if (currentValue.getValue() instanceof EventBuilderConfigurer) {
            EventBuilderConfigurer configurer = (EventBuilderConfigurer)currentValue.getValue();
            configurer.configure(partEventBuilder);
            Runnable onCompleteConsumer = () -> ((EventBuilderConfigurer)configurer).eventCompleted();
            foreachContext.setOnComplete(onCompleteConsumer);
        } else if (currentValue.getValue() instanceof Message) {
            Message message = (Message)currentValue.getValue();
            partEventBuilder.message(Message.builder((Message)message).payload(managedValue).build());
        } else {
            partEventBuilder.message(Message.builder().payload(managedValue).build());
        }
        return partEventBuilder.addVariable(owner.getCounterVariableName(), (Object)foreachContext.getElementNumber().incrementAndGet(), DataType.NUMBER).build();
    }

    private ForeachContext createForeachContext(CoreEvent event, Iterator<TypedValue<?>> iterator) {
        Object previousCounterVar = event.getVariables().containsKey(this.owner.getCounterVariableName()) ? ((TypedValue)event.getVariables().get(this.owner.getCounterVariableName())).getValue() : null;
        Object previousRootMessageVar = event.getVariables().containsKey(this.owner.getRootMessageVariableName()) ? ((TypedValue)event.getVariables().get(this.owner.getRootMessageVariableName())).getValue() : null;
        return new ForeachContext(previousCounterVar, previousRootMessageVar, event.getMessage(), event.getItemSequenceInfo(), iterator);
    }

    Publisher<CoreEvent> getDownstreamPublisher() {
        return this.downstreamFlux.compose(downstreamPublisher -> Mono.subscriberContext().flatMapMany(downstreamContext -> downstreamPublisher.doOnSubscribe(s -> this.downstreamCtxReference.set((Context)downstreamContext))));
    }

    private void subscribeUpstreamChains(Context downstreamContext) {
        this.innerFlux.subscriberContext(downstreamContext).subscribe();
        this.upstreamFlux.subscriberContext(downstreamContext).subscribe();
    }

    private CoreEvent createResponseEvent(CoreEvent event) {
        ForeachContext foreachContext = ForeachInternalContextManager.getContext(event);
        if (foreachContext == null) {
            return event;
        }
        CoreEvent.Builder responseBuilder = CoreEvent.builder((CoreEvent)event).message(foreachContext.getOriginalMessage()).itemSequenceInfo(foreachContext.getItemSequenceInfo());
        this.restoreVariables(foreachContext.getPreviousCounter(), foreachContext.getPreviousRootMessage(), responseBuilder);
        return this.eventWithCurrentContextDeleted(responseBuilder.build());
    }

    private void restoreVariables(Object previousCounterVar, Object previousRootMessageVar, CoreEvent.Builder responseBuilder) {
        if (previousCounterVar != null) {
            responseBuilder.addVariable(this.owner.getCounterVariableName(), previousCounterVar, DataType.NUMBER);
        } else {
            responseBuilder.removeVariable(this.owner.getCounterVariableName());
        }
        if (previousRootMessageVar != null) {
            responseBuilder.addVariable(this.owner.getRootMessageVariableName(), previousRootMessageVar, DataType.MULE_MESSAGE);
        } else {
            responseBuilder.removeVariable(this.owner.getRootMessageVariableName());
        }
    }
}

