/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.weave.dwb.api.IWeaveValue;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.dwb.reader.NumberPrecisionHelper$;
import org.mule.weave.v2.module.dwb.reader.WeaveArrayValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBigDecimalValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBigIntValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBooleanValue;
import org.mule.weave.v2.module.dwb.reader.WeaveDateTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveDoubleValue;
import org.mule.weave.v2.module.dwb.reader.WeaveIntValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLocalDateTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLocalDateValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLocalTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLongValue;
import org.mule.weave.v2.module.dwb.reader.WeaveNullValue;
import org.mule.weave.v2.module.dwb.reader.WeaveObjectValue;
import org.mule.weave.v2.module.dwb.reader.WeavePeriodValue;
import org.mule.weave.v2.module.dwb.reader.WeaveTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveTimeZoneValue;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import spire.math.Number;

public final class WeaveValue$ {
    public static WeaveValue$ MODULE$;

    static {
        new WeaveValue$();
    }

    public IWeaveValue<?> apply(Value<?> value, EvaluationContext ctx) {
        Object object;
        Value<?> value2 = value;
        if (StringType$.MODULE$.accepts(value2, ctx)) {
            object = new IWeaveValue(value, ctx);
        } else if (NumberType$.MODULE$.accepts(value2, ctx)) {
            Value<?> numberValue = value;
            object = this.processNumber(numberValue, ctx);
        } else if (BooleanType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveBooleanValue(value, ctx);
        } else if (ObjectType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveObjectValue(value, ctx);
        } else if (ArrayType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveArrayValue(value, ctx);
        } else if (BinaryType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveBinaryValue(value, ctx);
        } else if (NullType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveNullValue(value, ctx);
        } else if (DateTimeType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveDateTimeValue(value, ctx);
        } else if (LocalDateType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveLocalDateValue(value, ctx);
        } else if (PeriodType$.MODULE$.accepts(value2, ctx)) {
            object = new WeavePeriodValue(value, ctx);
        } else if (LocalDateTimeType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveLocalDateTimeValue(value, ctx);
        } else if (TimeType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveTimeValue(value, ctx);
        } else if (LocalTimeType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveLocalTimeValue(value, ctx);
        } else if (TimeZoneType$.MODULE$.accepts(value2, ctx)) {
            object = new WeaveTimeZoneValue(value, ctx);
        } else {
            throw new DWBRuntimeExecutionException(new StringBuilder(19).append("Can't handle type: ").append(value.valueType(ctx).toString()).toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
        }
        return object;
    }

    private IWeaveValue<?> processNumber(Value<Number> numberValue, EvaluationContext ctx) {
        IWeaveValue<?> iWeaveValue;
        Option schemaMaybe = numberValue.schema(ctx);
        Option option = schemaMaybe;
        if (option instanceof Some) {
            IWeaveValue<?> iWeaveValue2;
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Option maybeClass = schema.valueOf("class", ctx);
            Option option2 = maybeClass;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Value classPropValue = (Value)some2.value();
                iWeaveValue2 = this.processNumberWithClass(numberValue, classPropValue, ctx);
            } else if (None$.MODULE$.equals(option2)) {
                iWeaveValue2 = this.processNumberWithoutClass(numberValue, ctx);
            } else {
                throw new MatchError((Object)option2);
            }
            iWeaveValue = iWeaveValue2;
        } else if (None$.MODULE$.equals(option)) {
            iWeaveValue = this.processNumberWithoutClass(numberValue, ctx);
        } else {
            throw new MatchError((Object)option);
        }
        return iWeaveValue;
    }

    private IWeaveValue<?> processNumberWithClass(Value<Number> numberValue, Value<?> classPropValue, EvaluationContext ctx) {
        Object object;
        String className = StringType$.MODULE$.coerce(classPropValue, ctx).evaluate(ctx).toString();
        if (NumberPrecisionHelper$.MODULE$.isInt(className)) {
            object = new WeaveIntValue(numberValue, ctx);
        } else if (NumberPrecisionHelper$.MODULE$.isLong(className)) {
            object = new WeaveLongValue(numberValue, ctx);
        } else if (NumberPrecisionHelper$.MODULE$.isDouble(className)) {
            object = new WeaveDoubleValue(numberValue, ctx);
        } else if (NumberPrecisionHelper$.MODULE$.isBigInt(className)) {
            object = new WeaveBigIntValue(numberValue, ctx);
        } else if (NumberPrecisionHelper$.MODULE$.isBigDecimal(className)) {
            object = new WeaveBigDecimalValue(numberValue, ctx);
        } else {
            String message = new StringBuilder(55).append("Number class '").append(className).append("' not present in data-weave binary format").toString();
            throw new DWBRuntimeExecutionException(message, classPropValue.location());
        }
        return object;
    }

    private IWeaveValue<?> processNumberWithoutClass(Value<Number> numberValue, EvaluationContext ctx) {
        Number number = (Number)numberValue.evaluate(ctx);
        return number.isWhole() ? (number.withinInt() ? new WeaveIntValue(numberValue, ctx) : (number.withinLong() ? new WeaveLongValue(numberValue, ctx) : new WeaveBigIntValue(numberValue, ctx))) : (number.withinDouble() ? new WeaveDoubleValue(numberValue, ctx) : new WeaveBigDecimalValue(numberValue, ctx));
    }

    public Map<String, IWeaveValue<?>> getSchema(Value<?> value, EvaluationContext ctx) {
        Map<String, IWeaveValue<?>> map;
        Option option = value.schema(ctx);
        if (option instanceof Some) {
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            map = this.toWeaveValueMap(schema, ctx);
        } else if (None$.MODULE$.equals(option)) {
            map = Collections.emptyMap();
        } else {
            throw new MatchError((Object)option);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, IWeaveValue<?>> toWeaveValueMap(Schema schema, EvaluationContext ctx) {
        void var3_3;
        LinkedHashMap map = new LinkedHashMap();
        Seq props = schema.properties(ctx);
        props.foreach((Function1 & Serializable & scala.Serializable)prop -> {
            String propName = (String)prop.name().evaluate(ctx);
            IWeaveValue<?> propValue = MODULE$.apply(prop.value(), ctx);
            return map.put(propName, propValue);
        });
        return var3_3;
    }

    private WeaveValue$() {
        MODULE$ = this;
    }
}

