/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.registry.TransientRegistry;
import org.mule.runtime.core.internal.util.InjectionUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.reflections.ReflectionUtils;

public class SimpleRegistry
extends TransientRegistry
implements Injector {
    private static final String REGISTRY_ID = "org.mule.runtime.core.Registry.Simple";

    public SimpleRegistry(MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor) {
        super(REGISTRY_ID, muleContext, lifecycleInterceptor);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.injectFieldDependencies();
        super.doInitialise();
    }

    @Override
    public <T> T lookupObject(String key, boolean applyLifecycle) {
        return this.lookupObject(key);
    }

    @Override
    protected void doRegisterObject(String key, Object object, Object metadata) throws RegistrationException {
        Object previous = this.doGet(key);
        if (previous != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("An entry already exists for key %s. It will be replaced", key));
            }
            this.unregisterObject(key);
        }
        this.doPut(key, object);
        try {
            this.getLifecycleManager().applyCompletedPhases(object);
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        if (phase == null) {
            this.getLifecycleManager().applyCompletedPhases(object);
        } else {
            this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        }
        return object;
    }

    @Override
    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, startPhase, toPhase);
    }

    @Override
    public <T> T inject(T object) {
        object = InjectionUtils.getInjectionTarget(object);
        return (T)this.applyProcessors(object, null);
    }

    @Override
    protected Object applyProcessors(Object object, Object metadata) {
        return this.injectInto(super.applyProcessors(object, metadata));
    }

    private void injectFieldDependencies() throws InitialisationException {
        this.lookupObjects(Object.class).forEach(this::injectInto);
    }

    private <T> T injectInto(T object) {
        Object dependency;
        for (Field field : ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)})) {
            try {
                dependency = this.resolveTypedDependency(field.getType(), field.getAnnotation(Named.class), () -> ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
                field.setAccessible(true);
                if (dependency == null) continue;
                field.set(object, dependency);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not inject dependency on field %s of type %s", field.getName(), object.getClass().getName()), e);
            }
        }
        for (Method method : ReflectionUtils.getAllMethods(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)})) {
            if (method.getParameters().length != 1) continue;
            try {
                dependency = this.resolveTypedDependency(method.getParameterTypes()[0], method.getAnnotation(Named.class), () -> ((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0]);
                if (dependency == null) continue;
                method.invoke(object, dependency);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not inject dependency on method %s of type %s", method.getName(), object.getClass().getName()), e);
            }
        }
        return object;
    }

    private Object resolveTypedDependency(Class<?> dependencyType, Named namedAnnotation, Supplier<Type> typeSupplier) throws RegistrationException {
        boolean nullToOptional = false;
        boolean collection = false;
        if (dependencyType.equals(Optional.class)) {
            nullToOptional = true;
        } else if (Collection.class.isAssignableFrom(dependencyType)) {
            collection = true;
        }
        if (nullToOptional || collection) {
            Type type = typeSupplier.get();
            dependencyType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        }
        return this.resolveDependency(dependencyType, nullToOptional, collection, namedAnnotation);
    }

    private Object resolveDependency(Class<?> dependencyType, boolean nullToOptional, boolean collection, Named nameAnnotation) throws RegistrationException {
        if (collection) {
            return this.resolveObjectsToInject(dependencyType);
        }
        return this.resolveObjectToInject(dependencyType, nameAnnotation != null ? nameAnnotation.value() : null, nullToOptional);
    }

    private Object resolveObjectToInject(Class<?> dependencyType, String name, boolean nullToOptional) throws RegistrationException {
        Object dependency = name != null ? this.lookupObject(name) : this.lookupObject(dependencyType);
        if (dependency == null && MuleContext.class.isAssignableFrom(dependencyType)) {
            dependency = this.muleContext;
        }
        return nullToOptional ? Optional.ofNullable(dependency) : dependency;
    }

    private <T> Collection<T> resolveObjectsToInject(Class<T> dependencyType) throws RegistrationException {
        Collection<T> dependencies = this.lookupObjects(dependencyType);
        return dependencies;
    }
}

