/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.regex.ForeignRegexCompiler;
import com.oracle.truffle.regex.RegexCompiler;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.Loggers;
import java.util.logging.Level;

public class RegexCompilerWithFallback
implements RegexCompiler {
    private final RegexCompiler mainCompiler;
    private final RegexCompiler fallbackCompiler;

    public RegexCompilerWithFallback(RegexCompiler mainCompiler, TruffleObject fallbackCompiler) {
        this.mainCompiler = mainCompiler;
        this.fallbackCompiler = ForeignRegexCompiler.importRegexCompiler(fallbackCompiler);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object compile(RegexSource regexSource) throws RegexSyntaxException, UnsupportedRegexException {
        Object regex;
        long elapsedTimeMain = 0L;
        long elapsedTimeFallback = 0L;
        DebugUtil.Timer timer = null;
        boolean shouldLog = RegexCompilerWithFallback.shouldLogCompilationTime();
        if (shouldLog) {
            timer = new DebugUtil.Timer();
        }
        try {
            if (shouldLog) {
                timer.start();
            }
            regex = this.mainCompiler.compile(regexSource);
            if (shouldLog) {
                elapsedTimeMain = timer.getElapsed();
            }
            Loggers.LOG_COMPILER_FALLBACK.finer(() -> "Primary compiler used: " + regexSource);
        }
        catch (UnsupportedRegexException mainBailout) {
            Loggers.LOG_BAILOUT_MESSAGES.fine(() -> mainBailout.getReason() + ": " + regexSource);
            try {
                if (shouldLog) {
                    timer.start();
                }
                regex = this.fallbackCompiler.compile(regexSource);
                if (shouldLog) {
                    elapsedTimeFallback = timer.getElapsed();
                }
                Loggers.LOG_COMPILER_FALLBACK.fine(() -> String.format("Secondary compiler used (primary bailout due to '%s'): %s", mainBailout.getReason(), regexSource));
            }
            catch (UnsupportedRegexException fallbackBailout) {
                Loggers.LOG_COMPILER_FALLBACK.fine(() -> String.format("No compiler handled following regex (primary bailout: '%s'; secondary bailout: '%s'): %s", mainBailout.getReason(), fallbackBailout.getReason(), regexSource));
                String bailoutReasons = String.format("%s; %s", mainBailout.getReason(), fallbackBailout.getReason());
                throw new UnsupportedRegexException(bailoutReasons, regexSource);
            }
        }
        if (shouldLog) {
            RegexCompilerWithFallback.logCompilationTime(regexSource, elapsedTimeMain, elapsedTimeFallback);
        }
        return regex;
    }

    private static boolean shouldLogCompilationTime() {
        return Loggers.LOG_TOTAL_COMPILATION_TIME.isLoggable(Level.FINE);
    }

    private static void logCompilationTime(RegexSource regexSource, long elapsedTimeMain, long elapsedTimeFallback) {
        Loggers.LOG_TOTAL_COMPILATION_TIME.log(Level.FINE, "{0}, {1}, {2}, {3}", new Object[]{DebugUtil.Timer.elapsedToString(elapsedTimeMain + elapsedTimeFallback), DebugUtil.Timer.elapsedToString(elapsedTimeMain), DebugUtil.Timer.elapsedToString(elapsedTimeFallback), DebugUtil.jsStringEscape(regexSource.toString())});
    }
}

