/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.internal.management.stats.NoOpCursorComponentDecoratorFactory;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilderUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.annotation.param.Content;

public class ParameterGroupObjectBuilder<T> {
    private final Class<T> prototypeClass;
    private final ExpressionManager expressionManager;
    private final List<FieldElement> groupDescriptorFields;

    public ParameterGroupObjectBuilder(ParameterGroupDescriptor groupDescriptor, ReflectionCache reflectionCache, ExpressionManager expressionManager) {
        this.prototypeClass = groupDescriptor.getType().getDeclaringClass().get();
        IntrospectionUtils.checkInstantiable(this.prototypeClass, reflectionCache);
        this.expressionManager = expressionManager;
        this.groupDescriptorFields = reflectionCache.fieldElementsFor(groupDescriptor);
    }

    public T build(EventedExecutionContext executionContext) throws MuleException {
        try (ValueResolvingContext context = ValueResolvingContext.builder(executionContext.getEvent()).withExpressionManager(this.expressionManager).withConfig(executionContext.getConfiguration()).build();){
            T t = this.doBuild(arg_0 -> ((EventedExecutionContext)executionContext).hasParameter(arg_0), arg_0 -> ((EventedExecutionContext)executionContext).getParameter(arg_0), context, this.resolveCursorComponentDecoratorFactory(executionContext));
            return t;
        }
    }

    private CursorComponentDecoratorFactory resolveCursorComponentDecoratorFactory(EventedExecutionContext executionContext) {
        if (executionContext instanceof ExecutionContextAdapter) {
            return ((ExecutionContextAdapter)executionContext).getComponentDecoratorFactory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T build(ResolverSetResult result) throws MuleException {
        Map<String, Object> resultMap = result.asMap();
        CoreEvent initializerEvent = null;
        ValueResolvingContext context = null;
        try {
            initializerEvent = MuleExtensionUtils.getInitialiserEvent();
            context = ValueResolvingContext.builder(initializerEvent).build();
            T t = this.doBuild(resultMap::containsKey, resultMap::get, context, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
            return t;
        }
        finally {
            if (initializerEvent != null) {
                ((BaseEventContext)initializerEvent.getContext()).success();
            }
            if (context != null) {
                context.close();
            }
        }
    }

    private T doBuild(Predicate<String> hasParameter, Function<String, Object> parameters, ValueResolvingContext context, CursorComponentDecoratorFactory componentDecoratorFactory) throws MuleException {
        T object = ObjectBuilderUtils.createInstance(this.prototypeClass);
        for (FieldElement field : this.groupDescriptorFields) {
            String name = field.getName();
            if (!hasParameter.test(name)) continue;
            boolean isContent = field.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Content.class) || field.isAnnotatedWith(Content.class);
            Object resolvedValue = ResolverUtils.resolveValue(new StaticValueResolver<Object>(parameters.apply(name)), context);
            Object value = context == null || context.resolveCursors() ? ResolverUtils.resolveCursor(resolvedValue, isContent ? v -> MessageUtils.decorateInput((Object)v, (String)context.getEvent().getCorrelationId(), (CursorComponentDecoratorFactory)componentDecoratorFactory) : UnaryOperator.identity()) : resolvedValue;
            field.set(object, value);
        }
        return object;
    }
}

