/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.io.Serializable;

public final class FlowStackElement
implements Serializable {
    private static final long serialVersionUID = -2372094725681872367L;
    private final String flowName;
    private final String processorPath;
    private final long creationTime;

    public FlowStackElement(String flowName, String processorPath) {
        this.flowName = flowName;
        this.processorPath = processorPath;
        this.creationTime = System.currentTimeMillis();
    }

    public String getProcessorPath() {
        return this.processorPath;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public long getCreationTimeLong() {
        return this.creationTime;
    }

    public long getElapsedTimeLong() {
        return System.currentTimeMillis() - this.creationTime;
    }

    @Deprecated
    public Long getCreationTime() {
        return this.creationTime;
    }

    @Deprecated
    public Long getElapsedTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public String toString() {
        if (this.processorPath == null) {
            return this.flowName;
        }
        return this.flowName.concat("(").concat(this.processorPath).concat(")");
    }

    public String toStringWithElapsedTime() {
        return this.toString().concat(" ").concat(Long.toString(this.getElapsedTimeLong())).concat(" ms");
    }
}

