/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.boot;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoaderProvider;

public final class ExtensionLoaderUtils {
    public static Stream<ExtensionModelLoader> lookupExtensionModelLoaders() {
        return ExtensionLoaderUtils.lookupExtensionModelLoaders(Thread.currentThread().getContextClassLoader());
    }

    public static Stream<ExtensionModelLoader> lookupExtensionModelLoaders(ClassLoader classLoader) {
        return new SpiServiceRegistry().lookupProviders(ExtensionModelLoaderProvider.class, classLoader).stream().flatMap(p -> p.getExtensionModelLoaders().stream());
    }

    public static ExtensionModelLoader getLoaderById(String id) {
        return ExtensionLoaderUtils.getLoaderById(Thread.currentThread().getContextClassLoader(), id);
    }

    public static ExtensionModelLoader getLoaderById(ClassLoader classLoader, String id) {
        return ExtensionLoaderUtils.getOptionalLoaderById(classLoader, id).orElseThrow(() -> new NoSuchElementException("No loader found for id:{" + id + "}"));
    }

    public static Optional<ExtensionModelLoader> getOptionalLoaderById(ClassLoader classLoader, String id) {
        return ExtensionLoaderUtils.lookupExtensionModelLoaders(classLoader).filter(extensionModelLoader -> extensionModelLoader.getId().equals(id)).findFirst();
    }

    private ExtensionLoaderUtils() {
    }
}

