/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;

public abstract class AbstractSystemExceptionStrategy
extends AbstractExceptionListener
implements SystemExceptionHandler {
    @Inject
    private SchedulerService schedulerService;
    protected Scheduler retryScheduler;

    @Override
    public void handleException(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.doHandleException(ex, rollbackMethod, null);
    }

    private void rollback(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.rollback(ex);
        if (rollbackMethod != null) {
            rollbackMethod.rollback();
        }
    }

    @Override
    public void handleException(Exception ex) {
        this.doHandleException(ex, null, null);
    }

    @Override
    public void handleException(Exception ex, ComponentLocation componentLocation) {
        this.doHandleException(ex, null, componentLocation);
    }

    private void doHandleException(Exception ex, RollbackSourceCallback rollbackMethod, ComponentLocation componentLocation) {
        this.fireNotification(ex, PrivilegedEvent.getCurrentEvent(), componentLocation);
        this.resolveAndLogException(ex);
        this.logger.debug("Rolling back transaction");
        this.rollback(ex, rollbackMethod);
        if (PrivilegedEvent.getCurrentEvent() != null) {
            PrivilegedEvent currentEvent = PrivilegedEvent.getCurrentEvent();
            currentEvent = PrivilegedEvent.builder(currentEvent).message(InternalMessage.builder(currentEvent.getMessage()).build()).build();
            PrivilegedEvent.setCurrentEvent(currentEvent);
        }
        if (ex instanceof ConnectException) {
            ((ConnectException)((Object)ex)).handleReconnection((Executor)this.retryScheduler);
        }
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.retryScheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withShutdownTimeout(0L, TimeUnit.MILLISECONDS));
        super.doInitialise();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.retryScheduler != null) {
            this.retryScheduler.stop();
            this.retryScheduler = null;
        }
    }
}

