/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.editor.refactor;

import java.io.Serializable;
import org.mule.weave.v2.WeaveEditorSupport;
import org.mule.weave.v2.editor.CodeRefactor;
import org.mule.weave.v2.editor.refactor.ExtractFunctionRefactor;
import org.mule.weave.v2.editor.refactor.ExtractVariableRefactor;
import org.mule.weave.v2.grammar.Tokens$;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.DirectivesCapableNode;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import org.mule.weave.v2.parser.ast.functions.DoBlockNode;
import org.mule.weave.v2.parser.ast.functions.FunctionNode;
import org.mule.weave.v2.parser.ast.header.HeaderNode;
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode;
import org.mule.weave.v2.scope.AstNavigator;
import org.mule.weave.v2.scope.DependenciesAnalyzerService;
import org.mule.weave.v2.scope.VariableDependency;
import org.mule.weave.v2.scope.VariableScope;
import org.mule.weave.v2.utils.WeaveNameHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A\u0001C\u0005\u0001-!AA\u0002\u0001B\u0001B\u0003%Q\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u00037\u0001\u0011\u0005q\u0007C\u0003;\u0001\u0011%1\bC\u0003J\u0001\u0011%!\nC\u0003Z\u0001\u0011%!LA\bSK\u001a\f7\r^8s'\u0016\u0014h/[2f\u0015\tQ1\"\u0001\u0005sK\u001a\f7\r^8s\u0015\taQ\"\u0001\u0004fI&$xN\u001d\u0006\u0003\u001d=\t!A\u001e\u001a\u000b\u0005A\t\u0012!B<fCZ,'B\u0001\n\u0014\u0003\u0011iW\u000f\\3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqr$D\u0001\u000e\u0013\t\u0001SB\u0001\nXK\u00064X-\u00123ji>\u00148+\u001e9q_J$\u0018A\u0002\u001fj]&$h\b\u0006\u0002$KA\u0011A\u0005A\u0007\u0002\u0013!)AB\u0001a\u0001;\u0005yQ\r\u001f;sC\u000e$h+\u0019:jC\ndW\rF\u0002)_Q\u00022\u0001G\u0015,\u0013\tQ\u0013D\u0001\u0004PaRLwN\u001c\t\u0003Y5j\u0011aC\u0005\u0003]-\u0011AbQ8eKJ+g-Y2u_JDQ\u0001M\u0002A\u0002E\n1b\u001d;beR|eMZ:fiB\u0011\u0001DM\u0005\u0003ge\u00111!\u00138u\u0011\u0015)4\u00011\u00012\u0003%)g\u000eZ(gMN,G/A\bfqR\u0014\u0018m\u0019;Gk:\u001cG/[8o)\rA\u0003(\u000f\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006k\u0011\u0001\r!M\u0001\u001bG\u0006d7-\u001e7bi\u0016\u0014V-];je\u0016\u001c8+\u001a9be\u0006$xN\u001d\u000b\u0003y}\u0002\"\u0001G\u001f\n\u0005yJ\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0001\u0016\u0001\r!Q\u0001\u0004I\u000et\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\r\t7\u000f\u001e\u0006\u0003\r6\ta\u0001]1sg\u0016\u0014\u0018B\u0001%D\u0005U!\u0015N]3di&4Xm]\"ba\u0006\u0014G.\u001a(pI\u0016\fqcY1mGVd\u0017\r^3J]N,'\u000f^5p]&sG-\u001a=\u0015\tEZ5\u000b\u0017\u0005\u0006\u0019\u001a\u0001\r!T\u0001\n]\u00064\u0018nZ1u_J\u0004\"AT)\u000e\u0003=S!\u0001U\u0007\u0002\u000bM\u001cw\u000e]3\n\u0005I{%\u0001D!ti:\u000bg/[4bi>\u0014\b\"\u0002+\u0007\u0001\u0004)\u0016!\u00048pI\u0016$v.\u0012=ue\u0006\u001cG\u000f\u0005\u0002C-&\u0011qk\u0011\u0002\b\u0003N$hj\u001c3f\u0011\u0015\u0001e\u00011\u0001B\u0003I!W\r^3di\u000e{'O]3diN\u001bw\u000e]3\u0015\u0005ms\u0006C\u0001(]\u0013\tivJA\u0007WCJL\u0017M\u00197f'\u000e|\u0007/\u001a\u0005\u0006?\u001e\u0001\raW\u0001\u0003mN\u0004")
public class RefactorService {
    private final WeaveEditorSupport editor;

    public Option<CodeRefactor> extractVariable(int startOffset, int endOffset) {
        return this.editor.astNavigator().flatMap((Function1 & Serializable & scala.Serializable)navigator -> {
            None$ none$;
            Some some;
            AstNode nodeToExtract;
            Option<AstNode> maybeNode = navigator.nodeAt(startOffset, endOffset);
            Option<AstNode> option = maybeNode;
            if (option instanceof Some && (AstNodeHelper$.MODULE$.isExpressionNode(nodeToExtract = (AstNode)(some = (Some)option).value()) || AstNodeHelper$.MODULE$.isWeaveTypeNode(nodeToExtract))) {
                AstNode astNode = nodeToExtract;
                String string = astNode instanceof WeaveTypeNode ? Tokens$.MODULE$.TYPE() : Tokens$.MODULE$.VAR();
                String tokenType = string;
                String defaultVarName = WeaveNameHelper$.MODULE$.inferVariableName(nodeToExtract, (AstNavigator)navigator, "Var");
                none$ = $this.editor.scopeGraph().flatMap((Function1 & Serializable & scala.Serializable)scopeGraph -> {
                    Option<VariableScope> maybeScope = scopeGraph.scopeOf(nodeToExtract);
                    return maybeScope.flatMap((Function1 & Serializable & scala.Serializable)vs -> {
                        Some some;
                        VariableScope valueScope = this.detectCorrectScope((VariableScope)vs);
                        AstNode astNode = valueScope.astNode();
                        if (astNode instanceof DirectivesCapableNode) {
                            DirectivesCapableNode directivesCapableNode = (DirectivesCapableNode)astNode;
                            int index = this.calculateInsertionIndex((AstNavigator)navigator, nodeToExtract, directivesCapableNode);
                            boolean insertSeparator = this.calculateRequiresSeparator(directivesCapableNode);
                            ExtractVariableRefactor refactor = new ExtractVariableRefactor(false, insertSeparator, nodeToExtract.location(), index, vs.astNode().location(), defaultVarName, tokenType);
                            some = new Some((Object)refactor);
                        } else {
                            ExtractVariableRefactor refactor = new ExtractVariableRefactor(true, true, nodeToExtract.location(), vs.astNode().location().startPosition().index(), vs.astNode().location(), defaultVarName, tokenType);
                            some = new Some((Object)refactor);
                        }
                        return some;
                    });
                });
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Option<CodeRefactor> extractFunction(int startOffset, int endOffset) {
        return this.editor.astNavigator().flatMap((Function1 & Serializable & scala.Serializable)navigator -> {
            None$ none$;
            Some some;
            AstNode nodeToExtract;
            Option<AstNode> maybeNode = navigator.nodeAt(startOffset, endOffset);
            Option<AstNode> option = maybeNode;
            if (option instanceof Some && AstNodeHelper$.MODULE$.isExpressionNode(nodeToExtract = (AstNode)(some = (Some)option).value())) {
                String defaultVarName = WeaveNameHelper$.MODULE$.inferVariableName(nodeToExtract, (AstNavigator)navigator, "Fun");
                none$ = $this.editor.scopeGraph().flatMap((Function1 & Serializable & scala.Serializable)scopeGraph -> {
                    Option<VariableScope> maybeScope = scopeGraph.scopeOf(nodeToExtract);
                    return maybeScope.flatMap((Function1 & Serializable & scala.Serializable)vs -> {
                        Some some;
                        VariableScope valueScope = vs.rootScope();
                        DependenciesAnalyzerService dependenciesAnalyzerService = new DependenciesAnalyzerService($this.editor);
                        VariableDependency[] dependencies = dependenciesAnalyzerService.externalScopeDependencies(startOffset, endOffset, (Option<VariableScope>)new Some((Object)valueScope));
                        AstNode astNode = valueScope.astNode();
                        if (astNode instanceof DirectivesCapableNode) {
                            DirectivesCapableNode directivesCapableNode = (DirectivesCapableNode)astNode;
                            int index = this.calculateInsertionIndex((AstNavigator)navigator, nodeToExtract, directivesCapableNode);
                            boolean insertSeparator = this.calculateRequiresSeparator(directivesCapableNode);
                            ExtractFunctionRefactor refactor = new ExtractFunctionRefactor(false, insertSeparator, nodeToExtract.location(), index, vs.astNode().location(), defaultVarName, (Seq<VariableDependency>)Predef$.MODULE$.wrapRefArray((Object[])dependencies));
                            some = new Some((Object)refactor);
                        } else {
                            ExtractFunctionRefactor refactor = new ExtractFunctionRefactor(true, true, nodeToExtract.location(), vs.astNode().location().startPosition().index(), vs.astNode().location(), defaultVarName, (Seq<VariableDependency>)Predef$.MODULE$.wrapRefArray((Object[])dependencies));
                            some = new Some((Object)refactor);
                        }
                        return some;
                    });
                });
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    private boolean calculateRequiresSeparator(DirectivesCapableNode dcn) {
        boolean bl;
        DirectivesCapableNode directivesCapableNode = dcn;
        if (directivesCapableNode instanceof DoBlockNode) {
            DoBlockNode doBlockNode = (DoBlockNode)directivesCapableNode;
            HeaderNode header = doBlockNode.header();
            bl = header.directives().isEmpty();
        } else if (directivesCapableNode instanceof DocumentNode) {
            DocumentNode documentNode = (DocumentNode)directivesCapableNode;
            HeaderNode header = documentNode.header();
            bl = header.directives().forall((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)AstNodeHelper$.MODULE$.isInjectedNode(n)));
        } else {
            bl = false;
        }
        return bl;
    }

    private int calculateInsertionIndex(AstNavigator navigator, AstNode nodeToExtract, DirectivesCapableNode dcn) {
        int n;
        if (dcn.directives().isEmpty()) {
            int n2;
            DirectivesCapableNode directivesCapableNode = dcn;
            if (directivesCapableNode instanceof DoBlockNode) {
                DoBlockNode doBlockNode = (DoBlockNode)directivesCapableNode;
                AstNode body = doBlockNode.body();
                n2 = body.location().startPosition().index();
            } else if (directivesCapableNode instanceof DocumentNode) {
                DocumentNode documentNode = (DocumentNode)directivesCapableNode;
                AstNode root = documentNode.root();
                n2 = root.location().startPosition().index();
            } else {
                n2 = dcn.location().startPosition().index();
            }
            n = n2;
        } else {
            int n3;
            Option<DirectiveNode> maybeDirectiveNode = navigator.parentWithType(nodeToExtract, DirectiveNode.class);
            Option<DirectiveNode> option = maybeDirectiveNode;
            if (option instanceof Some) {
                Some some = (Some)option;
                DirectiveNode dn = (DirectiveNode)some.value();
                int i = dcn.directives().indexOf((Object)dn);
                n3 = i <= 0 ? dn.location().startPosition().index() : ((WeaveLocationCapable)dcn.directives().apply(i - 1)).location().endPosition().index();
            } else if (None$.MODULE$.equals(option)) {
                n3 = ((WeaveLocationCapable)dcn.directives().maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)RefactorService.$anonfun$calculateInsertionIndex$1(x$1)), (Ordering)Ordering.Int$.MODULE$)).location().endPosition().index();
            } else {
                throw new MatchError(option);
            }
            n = n3;
        }
        return n;
    }

    private VariableScope detectCorrectScope(VariableScope vs) {
        AstNode astNode;
        while ((astNode = vs.astNode()) instanceof FunctionNode) {
            vs = (VariableScope)vs.parentScope().get();
        }
        VariableScope variableScope = vs;
        return variableScope;
    }

    public static final /* synthetic */ int $anonfun$calculateInsertionIndex$1(DirectiveNode x$1) {
        return x$1.location().endPosition().index();
    }

    public RefactorService(WeaveEditorSupport editor) {
        this.editor = editor;
    }
}

