/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerateNodeGen;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.ForInIterator;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class EnumerateNode
extends JavaScriptNode {
    private final boolean values;
    private final boolean requireIterable;
    protected final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    private PropertySetNode setEnumerateIteratorNode;
    @Node.Child
    private PropertySetNode setForInIteratorNode;

    protected EnumerateNode(JSContext context, boolean values, boolean requireIterable, JavaScriptNode targetNode) {
        this.context = context;
        this.values = values;
        this.requireIterable = requireIterable;
        this.targetNode = targetNode;
    }

    public static EnumerateNode create(JSContext context, JavaScriptNode target, boolean values) {
        return EnumerateNodeGen.create(context, values, false, target);
    }

    public static EnumerateNode create(JSContext context, boolean values, boolean requireIterable) {
        return EnumerateNodeGen.create(context, values, requireIterable, null);
    }

    EnumerateNode copyRecursive() {
        return EnumerateNode.create(this.context, this.values, this.requireIterable);
    }

    public abstract DynamicObject execute(VirtualFrame var1);

    public abstract DynamicObject execute(Object var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return EnumerateNodeGen.create(this.context, this.values, this.requireIterable, EnumerateNode.cloneUninitialized(this.targetNode, materializedTags));
    }

    @Specialization(guards={"isJSDynamicObject(iteratedObject)", "!isJSAdapter(iteratedObject)"})
    protected DynamicObject doEnumerateObject(DynamicObject iteratedObject, @Cached(value="createBinaryProfile()") ConditionProfile isObject) {
        if (isObject.profile(JSRuntime.isObject(iteratedObject))) {
            return this.newForInIterator(iteratedObject);
        }
        Iterator iterator = Collections.emptyIterator();
        return this.newEnumerateIterator(iterator);
    }

    @Specialization(guards={"isJSAdapter(iteratedObject)"})
    protected DynamicObject doEnumerateJSAdapter(DynamicObject iteratedObject, @Cached(value="createValues()") EnumerateNode enumerateCallbackResultNode) {
        Object returnValue;
        DynamicObject adaptee = JSAdapter.getAdaptee(iteratedObject);
        assert (JSRuntime.isObject(adaptee));
        Object getIds = JSObject.get(adaptee, (Object)(this.values ? "__getValues__" : "__getIds__"));
        if (JSFunction.isJSFunction(getIds) && JSRuntime.isObject(returnValue = JSFunction.call((DynamicObject)getIds, adaptee, JSArguments.EMPTY_ARGUMENTS_ARRAY))) {
            return enumerateCallbackResultNode.execute(returnValue);
        }
        return this.newEnumerateIterator(Collections.emptyIterator());
    }

    EnumerateNode createValues() {
        return EnumerateNode.create(this.context, true, false);
    }

    @Specialization(guards={"isForeignObject(iteratedObject)"}, limit="InteropLibraryLimit")
    protected DynamicObject doEnumerateTruffleObject(Object iteratedObject, @CachedLibrary(value="iteratedObject") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary keysInterop, @Cached(value="createBinaryProfile()") ConditionProfile isHostObject, @Cached BranchProfile notIterable) {
        Object hostObject;
        Iterator<?> iterator;
        TruffleLanguage.Env env = this.context.getRealm().getEnv();
        if (isHostObject.profile(env.isHostObject(iteratedObject)) && (iterator = EnumerateNode.getHostObjectIterator(hostObject = env.asHostObject(iteratedObject), this.values, env)) != null) {
            return this.newEnumerateIterator(iterator);
        }
        try {
            if (!interop.isNull(iteratedObject)) {
                if (interop.hasArrayElements(iteratedObject)) {
                    return this.enumerateForeignArrayLike(iteratedObject, interop);
                }
                if (interop.hasMembers(iteratedObject)) {
                    Object keysObj = interop.getMembers(iteratedObject);
                    assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).hasArrayElements(keysObj));
                    long longSize = keysInterop.getArraySize(keysObj);
                    return this.enumerateForeignNonArray(iteratedObject, keysObj, longSize, interop, keysInterop);
                }
                if (interop.isString(iteratedObject)) {
                    String string = interop.asString(iteratedObject);
                    return this.enumerateString(string);
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        notIterable.enter();
        if (this.requireIterable) {
            throw Errors.createTypeErrorNotIterable(iteratedObject, this);
        }
        return this.newEnumerateIterator(Collections.emptyIterator());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private static Iterator<?> getHostObjectIterator(Object hostObject, boolean values, TruffleLanguage.Env env) {
        void var3_7;
        if (hostObject == null) return null;
        if (hostObject instanceof Map) {
            Map map = (Map)hostObject;
            Iterator<Object> iterator = values ? map.values().iterator() : map.keySet().iterator();
            return IteratorUtil.convertIterator(var3_7, arg_0 -> ((TruffleLanguage.Env)env).asGuestValue(arg_0));
        } else if (hostObject.getClass().isArray()) {
            if (!values) return IteratorUtil.rangeIterator(Array.getLength(hostObject));
            ArrayIterator arrayIterator = new ArrayIterator(hostObject);
            return IteratorUtil.convertIterator(var3_7, arg_0 -> ((TruffleLanguage.Env)env).asGuestValue(arg_0));
        } else {
            if (!values && hostObject instanceof List) {
                return IteratorUtil.rangeIterator(((List)hostObject).size());
            }
            if (!values || !(hostObject instanceof Iterable)) return null;
            Iterator iterator = ((Iterable)hostObject).iterator();
        }
        return IteratorUtil.convertIterator(var3_7, arg_0 -> ((TruffleLanguage.Env)env).asGuestValue(arg_0));
    }

    private DynamicObject enumerateForeignArrayLike(Object iteratedObject, InteropLibrary interop) {
        return this.newEnumerateIterator(new ForeignArrayIterator(iteratedObject, this.values, interop));
    }

    private DynamicObject enumerateForeignNonArray(Object iteratedObject, Object keysObject, long keysSize, InteropLibrary objInterop, InteropLibrary keysInterop) {
        return this.newEnumerateIterator(new ForeignMembersIterator(iteratedObject, keysObject, keysSize, this.values, objInterop, keysInterop));
    }

    private DynamicObject enumerateString(String string) {
        return this.newForInIterator(JSString.create(this.context, string));
    }

    private DynamicObject newEnumerateIterator(Iterator<?> iterator) {
        if (this.setEnumerateIteratorNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setEnumerateIteratorNode = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(JSRuntime.ENUMERATE_ITERATOR_ID, this.context));
        }
        DynamicObject obj = JSOrdinary.create(this.context, this.context.getEnumerateIteratorFactory());
        this.setEnumerateIteratorNode.setValue(obj, iterator);
        return obj;
    }

    private DynamicObject newForInIterator(DynamicObject obj) {
        if (this.setForInIteratorNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setForInIteratorNode = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(JSRuntime.FOR_IN_ITERATOR_ID, this.context));
        }
        DynamicObject iteratorObj = JSOrdinary.create(this.context, this.context.getForInIteratorFactory());
        this.setForInIteratorNode.setValue(iteratorObj, new ForInIterator(obj, this.values));
        return iteratorObj;
    }

    @Specialization(guards={"!isJSObject(iteratedObject)", "!isForeignObject(iteratedObject)"})
    protected DynamicObject doNonObject(Object iteratedObject, @Cached(value="createToObjectNoCheck(context)") JSToObjectNode toObjectNode, @Cached(value="copyRecursive()") EnumerateNode enumerateNode) {
        return enumerateNode.execute(toObjectNode.execute(iteratedObject));
    }

    private static final class ForeignMembersIterator
    implements Iterator<Object> {
        private final Object iteratedObject;
        private final Object keysObject;
        private final long keysSize;
        private final boolean values;
        private final InteropLibrary objInterop;
        private final InteropLibrary keysInterop;
        private long cursor;

        private ForeignMembersIterator(Object iteratedObject, Object keysObject, long keysSize, boolean values, InteropLibrary objInterop, InteropLibrary keysInterop) {
            this.iteratedObject = iteratedObject;
            this.keysObject = keysObject;
            this.keysSize = keysSize;
            this.values = values;
            this.objInterop = objInterop;
            this.keysInterop = keysInterop;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.keysSize;
        }

        @Override
        public Object next() {
            block7: {
                if (this.hasNext()) {
                    long index = this.cursor++;
                    try {
                        Object key = this.keysInterop.readArrayElement(this.keysObject, index);
                        if (this.values) {
                            try {
                                assert (((InteropLibrary)InteropLibrary.getFactory().getUncached()).isString(key));
                                String stringKey = key instanceof String ? (String)key : ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asString(key);
                                return this.objInterop.readMember(this.iteratedObject, stringKey);
                            }
                            catch (UnknownIdentifierException | UnsupportedMessageException throwable) {
                                break block7;
                            }
                        }
                        return key;
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {
                        // empty catch block
                    }
                }
            }
            throw new NoSuchElementException();
        }
    }

    private static final class ForeignArrayIterator
    implements Iterator<Object> {
        private final Object iteratedObject;
        private final boolean values;
        private final InteropLibrary interop;
        private long cursor;

        private ForeignArrayIterator(Object iteratedObject, boolean values, InteropLibrary interop) {
            this.iteratedObject = iteratedObject;
            this.values = values;
            this.interop = interop;
        }

        @Override
        public boolean hasNext() {
            try {
                long currentSize = this.interop.getArraySize(this.iteratedObject);
                return this.cursor < currentSize;
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                long index = this.cursor++;
                if (this.values) {
                    try {
                        return this.interop.readArrayElement(this.iteratedObject, index);
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException throwable) {
                    }
                } else {
                    return index;
                }
            }
            throw new NoSuchElementException();
        }
    }

    private static final class ArrayIterator
    implements Iterator<Object> {
        private final Object array;
        private final int length;
        private int index;

        ArrayIterator(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return Array.get(this.array, this.index++);
            }
            throw new NoSuchElementException();
        }
    }
}

