/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNodeGen;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={JSConfig.class})
public abstract class JSToPrimitiveNode
extends JavaScriptBaseNode {
    @Node.Child
    private OrdinaryToPrimitiveNode ordinaryToPrimitiveNode;
    @Node.Child
    private IsPrimitiveNode isPrimitiveNode;
    protected final Hint hint;

    protected JSToPrimitiveNode(Hint hint) {
        this.hint = hint;
    }

    public abstract Object execute(Object var1);

    public static JSToPrimitiveNode createHintNone() {
        return JSToPrimitiveNode.create(Hint.None);
    }

    public static JSToPrimitiveNode createHintString() {
        return JSToPrimitiveNode.create(Hint.String);
    }

    public static JSToPrimitiveNode createHintNumber() {
        return JSToPrimitiveNode.create(Hint.Number);
    }

    public static JSToPrimitiveNode create(Hint hint) {
        return JSToPrimitiveNodeGen.create(hint);
    }

    @Specialization
    protected int doInt(int value) {
        return value;
    }

    @Specialization
    protected SafeInteger doSafeInteger(SafeInteger value) {
        return value;
    }

    @Specialization
    protected long doLong(long value) {
        return value;
    }

    @Specialization
    protected double doDouble(double value) {
        return value;
    }

    @Specialization
    protected boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization
    protected CharSequence doString(CharSequence value) {
        return value;
    }

    @Specialization
    protected Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization
    protected BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected DynamicObject doNull(Object value) {
        return Null.instance;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected DynamicObject doUndefined(Object value) {
        return Undefined.instance;
    }

    @Specialization(guards={"isJSObject(object)"})
    protected Object doJSObject(DynamicObject object, @Cached(value="createGetToPrimitive(object)") PropertyNode getToPrimitive, @Cached(value="create()") IsPrimitiveNode isPrimitive, @Cached(value="createOrdinaryToPrimitive(object)") OrdinaryToPrimitiveNode ordinaryToPrimitive, @Cached(value="createBinaryProfile()") ConditionProfile exoticToPrimProfile, @Cached(value="createCall()") JSFunctionCallNode callExoticToPrim) {
        Object exoticToPrim = getToPrimitive.executeWithTarget(object);
        if (exoticToPrimProfile.profile(!JSRuntime.isNullOrUndefined(exoticToPrim))) {
            Object result = callExoticToPrim.executeCall(JSArguments.createOneArg(object, exoticToPrim, this.getHintName()));
            if (isPrimitive.executeBoolean(result)) {
                return result;
            }
            throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", this);
        }
        return ordinaryToPrimitive.execute(object);
    }

    private String getHintName() {
        switch (this.hint) {
            case Number: {
                return "number";
            }
            case String: {
                return "string";
            }
        }
        return "default";
    }

    protected final boolean isHintString() {
        return this.hint == Hint.String;
    }

    protected final boolean isHintNumber() {
        return this.hint == Hint.Number || this.hint == Hint.None;
    }

    @Specialization(guards={"isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected Object doTruffleJavaObject(Object object, @CachedLibrary(value="object") InteropLibrary interop, @CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef, @Cached(value="create()") ImportValueNode toJSType) {
        if (interop.isNull(object)) {
            return Null.instance;
        }
        JSRealm realm = (JSRealm)contextRef.get();
        TruffleLanguage.Env env = realm.getEnv();
        if (env.isHostObject(object)) {
            Object javaObject = env.asHostObject(object);
            if (javaObject == null) {
                return Null.instance;
            }
            if (JSGuards.isJavaPrimitiveNumber(javaObject)) {
                return toJSType.executeWithTarget(javaObject);
            }
            if (realm.getContext().isOptionNashornCompatibilityMode() && javaObject instanceof Number) {
                return JSRuntime.doubleValueVirtual((Number)javaObject);
            }
            if (JSGuards.isJavaArray(javaObject)) {
                return JSRuntime.javaArrayToString(javaObject);
            }
            if (interop.isInstant(object)) {
                return JSDate.getDateValueFromInstant(object, interop);
            }
            return this.hostToPrimitive(object, interop, javaObject);
        }
        try {
            if (interop.isBoolean(object)) {
                return interop.asBoolean(object);
            }
            if (interop.isString(object)) {
                return interop.asString(object);
            }
            if (interop.isNumber(object)) {
                if (interop.fitsInInt(object)) {
                    return interop.asInt(object);
                }
                if (interop.fitsInLong(object)) {
                    return interop.asLong(object);
                }
                if (interop.fitsInDouble(object)) {
                    return interop.asDouble(object);
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(object, (InteropException)((Object)e), this);
        }
        Object result = this.ordinaryToPrimitive(realm.getContext(), object);
        InteropLibrary resultInterop = (InteropLibrary)InteropLibrary.getFactory().getUncached(result);
        try {
            if (resultInterop.isBoolean(result)) {
                return resultInterop.asBoolean(result);
            }
            if (resultInterop.isString(result)) {
                return resultInterop.asString(result);
            }
            if (resultInterop.isNumber(result)) {
                if (resultInterop.fitsInInt(result)) {
                    return resultInterop.asInt(result);
                }
                if (resultInterop.fitsInLong(result)) {
                    return resultInterop.asLong(result);
                }
                if (resultInterop.fitsInDouble(result)) {
                    return resultInterop.asDouble(result);
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(result, (InteropException)((Object)e), this);
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    private Object hostToPrimitive(Object object, InteropLibrary interop, Object javaObject) {
        if (this.isHintNumber() && interop.hasMembers(object) && interop.isMemberInvocable(object, "valueOf")) {
            Object result;
            try {
                result = JSRuntime.importValue(interop.invokeMember(object, "valueOf", new Object[0]));
            }
            catch (InteropException e) {
                result = null;
            }
            if (result != null && this.isPrimitive(result)) {
                return result;
            }
        }
        return JSRuntime.toJSNull(Boundaries.javaToString(javaObject));
    }

    @Fallback
    protected Object doFallback(Object value) {
        assert (value != null);
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    private Object ordinaryToPrimitive(JSContext context, Object object) {
        if (this.ordinaryToPrimitiveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ordinaryToPrimitiveNode = (OrdinaryToPrimitiveNode)this.insert(OrdinaryToPrimitiveNode.create(context, this.isHintString() ? Hint.String : Hint.Number));
        }
        return this.ordinaryToPrimitiveNode.execute(object);
    }

    private boolean isPrimitive(Object object) {
        if (this.isPrimitiveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isPrimitiveNode = (IsPrimitiveNode)this.insert(IsPrimitiveNode.create());
        }
        return this.isPrimitiveNode.executeBoolean(object);
    }

    protected static PropertyNode createGetToPrimitive(DynamicObject object) {
        JSContext context = JSObject.getJSContext(object);
        return PropertyNode.createMethod(context, null, Symbol.SYMBOL_TO_PRIMITIVE);
    }

    protected OrdinaryToPrimitiveNode createOrdinaryToPrimitive(DynamicObject object) {
        JSContext context = JSObject.getJSContext(object);
        return OrdinaryToPrimitiveNode.create(context, this.isHintString() ? Hint.String : Hint.Number);
    }

    public static enum Hint {
        None,
        String,
        Number;

    }
}

