/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.lang.reflect.Field;
import java.util.Map;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.BaseOAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.UpdatingClientCredentialsState;
import org.mule.runtime.module.extension.internal.util.FieldSetter;

public class ClientCredentialsConnectionProviderWrapper<C>
extends BaseOAuthConnectionProviderWrapper<C> {
    private final ClientCredentialsConfig oauthConfig;
    private final ClientCredentialsOAuthHandler oauthHandler;
    private final FieldSetter<Object, Object> oauthStateSetter;
    private final Once.RunOnce dance;
    private ClientCredentialsOAuthDancer dancer;

    public ClientCredentialsConnectionProviderWrapper(ConnectionProvider<C> delegate, ClientCredentialsConfig oauthConfig, Map<Field, String> callbackValues, ClientCredentialsOAuthHandler oauthHandler, ReconnectionConfig reconnectionConfig) {
        super(delegate, reconnectionConfig, callbackValues);
        this.oauthConfig = oauthConfig;
        this.oauthHandler = oauthHandler;
        this.oauthStateSetter = ExtensionsOAuthUtils.getOAuthStateSetter(this.getDelegateForInjection(), ExtensionsOAuthUtils.CLIENT_CREDENTIALS_STATE_INTERFACES, (OAuthGrantType)oauthConfig.getGrantType());
        this.dance = Once.of(this::updateOAuthState);
    }

    public C connect() throws ConnectionException {
        this.dance.runOnce();
        return (C)super.connect();
    }

    @Override
    public void refreshToken(String resourceOwnerId) {
        this.oauthHandler.refreshToken(this.oauthConfig);
    }

    @Override
    public void invalidate(String resourceOwnerId) {
        this.oauthHandler.invalidate(this.oauthConfig);
    }

    @Override
    public OAuthGrantType getGrantType() {
        return this.oauthConfig.getGrantType();
    }

    private void updateOAuthState() {
        Object delegate = this.getDelegateForInjection();
        ResourceOwnerOAuthContext context = this.getContext();
        this.oauthStateSetter.set(delegate, new UpdatingClientCredentialsState(this.dancer, context, updatedContext -> ExtensionsOAuthUtils.updateOAuthParameters(delegate, this.callbackValues, updatedContext)));
        ExtensionsOAuthUtils.updateOAuthParameters(delegate, this.callbackValues, context);
    }

    @Override
    protected ResourceOwnerOAuthContext getContext() {
        return this.oauthHandler.getOAuthContext(this.oauthConfig);
    }

    public void start() throws MuleException {
        this.dancer = this.oauthHandler.register(this.oauthConfig);
        super.start();
    }
}

