/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelSource;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.exception.BundleDependencyNotFoundException;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.BundleDependencyHelper;
import org.mule.maven.client.internal.DefaultModelCache;
import org.mule.maven.client.internal.DefaultPomFileSupplierFactory;
import org.mule.maven.client.internal.DefaultVersionRangeResult;
import org.mule.maven.client.internal.MuleMavenRepositoryState;
import org.mule.maven.client.internal.MuleMavenRepositoryStateFactory;
import org.mule.maven.client.internal.MuleMavenResolutionContext;
import org.mule.maven.client.internal.RemoteRepositoryModelResolver;
import org.mule.maven.client.internal.pom.UrlModelSource;
import org.mule.maven.client.internal.util.MavenModelUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.api.model.PomParentCoordinates;
import org.mule.maven.pom.parser.internal.MavenPomParserImpl;
import org.mule.maven.pom.parser.internal.model.MavenPomModelWrapper;
import org.mule.maven.pom.parser.internal.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMavenClient
implements MavenClient {
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    public static final String MULE_DOMAIN_CLASSIFIER = "mule-domain";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleMavenClient.class);
    private static final String POM = "pom";
    private static final String JAR = "jar";
    private static final String ANY = "*";
    private final PomFileSupplierFactory pomFileSupplierFactory = new DefaultPomFileSupplierFactory();
    private final MavenConfiguration mavenConfiguration;
    private final MuleMavenResolutionContext muleMavenResolutionContext;
    private final MuleMavenRepositoryStateFactory muleMavenRepositoryStateFactory;
    private Optional<Consumer<DefaultRepositorySystemSession>> sessionConfigurator = Optional.empty();

    public MuleMavenClient(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        this.muleMavenResolutionContext = new MuleMavenResolutionContext(mavenConfiguration);
        this.muleMavenRepositoryStateFactory = new MuleMavenRepositoryStateFactory();
    }

    private MuleMavenRepositoryState getRepositoryState(File localRepositoryLocation, Optional<WorkspaceReader> workspaceReader) {
        return this.muleMavenRepositoryStateFactory.createMavenRepositoryState(localRepositoryLocation, this.muleMavenResolutionContext, this.mavenConfiguration, this.sessionConfigurator, workspaceReader);
    }

    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public void setSessionConfigurator(Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.sessionConfigurator = Optional.of(sessionConfigurator);
    }

    public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
        return this.resolveArtifactDependencies(artifactFile, includeTestDependencies, includeProvidedDependencies, localRepositoryLocationSupplier, Optional.empty(), temporaryFolder);
    }

    public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<MavenReactorResolver> mavenReactorResolver, Optional<File> temporaryFolder) {
        Objects.requireNonNull(artifactFile, "artifactFile cannot be null");
        try {
            List<Object> remoteRepositories;
            List<Dependency> managedDependencies;
            File localRepositoryLocation = localRepositoryLocationSupplier.orElse(this.muleMavenResolutionContext.getLocalRepositoryLocation());
            MuleMavenRepositoryState repositoryState = this.getRepositoryState(localRepositoryLocation, Optional.empty());
            Model model = this.getMavenEffectiveModel(artifactFile, temporaryFolder, Optional.of(repositoryState));
            if (model.getProfiles().stream().map(Profile::getActivation).filter(Objects::nonNull).anyMatch(activation -> activation.getFile() != null)) {
                throw new UnsupportedOperationException(String.format("Error while resolving dependencies for %s due to profiles activation by file are not supported", model.getId()));
            }
            DefaultArtifact artifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), null, POM, model.getVersion());
            mavenReactorResolver.ifPresent(reactor -> repositoryState.getSession().setWorkspaceReader((WorkspaceReader)new MavenWorkspaceReaderAdapter((MavenReactorResolver)reactor)));
            List<Dependency> dependencies = model.getDependencies().stream().map(modelDependency -> MuleMavenClient.convertModelDependency(modelDependency, repositoryState.getSession().getArtifactTypeRegistry())).collect(Collectors.toList());
            List<Object> list = managedDependencies = model.getDependencyManagement() == null ? Collections.emptyList() : model.getDependencyManagement().getDependencies().stream().map(modelDependency -> MuleMavenClient.convertModelDependency(modelDependency, repositoryState.getSession().getArtifactTypeRegistry())).collect(Collectors.toList());
            if (!this.mavenConfiguration.getIgnoreArtifactDescriptorRepositories()) {
                remoteRepositories = model.getRepositories() == null ? Collections.emptyList() : model.getRepositories().stream().map(modelRepository -> MavenModelUtils.convertModelRepository(modelRepository)).collect(Collectors.toList());
                remoteRepositories = new RemoteRepositoryModelResolver(repositoryState.getRemoteRepositoryManager(), (RepositorySystemSession)repositoryState.getSession()).resolveRepositories(this.muleMavenResolutionContext.getRemoteRepositoriesWithoutSuperPomModelRepositories(), remoteRepositories);
            } else {
                remoteRepositories = this.muleMavenResolutionContext.getRemoteRepositories();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("About to fetch required dependencies for artifact: {}. This may take a while...", (Object)ArtifactIdUtils.toId((Artifact)artifact));
            }
            return this.resolveDependencies(dependencies, managedDependencies, remoteRepositories, includeTestDependencies, includeProvidedDependencies, repositoryState);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException(String.format("There was an issue solving the dependencies for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
    }

    public List<BundleDependency> resolveArtifactDependencies(List<BundleDescriptor> dependencies, Optional<File> localRepositoryLocationSupplier, Optional<MavenReactorResolver> mavenReactorResolver) {
        try {
            File localRepositoryLocation = localRepositoryLocationSupplier.orElse(this.muleMavenResolutionContext.getLocalRepositoryLocation());
            MuleMavenRepositoryState repositoryState = this.getRepositoryState(localRepositoryLocation, mavenReactorResolver.map(MavenWorkspaceReaderAdapter::new));
            List<Dependency> dependenciesToResolve = dependencies.stream().map(bundleDescriptor -> new Dependency((Artifact)new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), (String)bundleDescriptor.getClassifier().orElse(null), bundleDescriptor.getType(), bundleDescriptor.getVersion()), null)).collect(Collectors.toList());
            return this.resolveDependencies(dependenciesToResolve, Collections.emptyList(), this.muleMavenResolutionContext.getRemoteRepositories(), false, false, repositoryState);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException("There was an issue solving the dependencies", e);
        }
    }

    public MavenPomModel getEffectiveModel(File artifactFile, Optional<File> temporaryFolder, Optional<MuleMavenRepositoryState> repositoryStateOptional) {
        return new MavenPomModelWrapper(this.getMavenEffectiveModel(artifactFile, temporaryFolder, repositoryStateOptional));
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, BundleDescriptor bundleDescriptor) {
        return this.resolveBundleDescriptorDependencies(includeTestDependencies, false, bundleDescriptor);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor) {
        try {
            MuleMavenRepositoryState repositoryState = this.getRepositoryState(this.muleMavenResolutionContext.getLocalRepositoryLocation(), Optional.empty());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactDescriptorResult artifactDescriptorResult = repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)repositoryState.getSession(), new ArtifactDescriptorRequest(artifact, this.muleMavenResolutionContext.getRemoteRepositories(), null));
            List<RemoteRepository> remoteRepositories = this.mavenConfiguration.getIgnoreArtifactDescriptorRepositories() ? this.muleMavenResolutionContext.getRemoteRepositories() : new RemoteRepositoryModelResolver(repositoryState.getRemoteRepositoryManager(), (RepositorySystemSession)repositoryState.getSession()).resolveRepositories(this.muleMavenResolutionContext.getRemoteRepositoriesWithoutSuperPomModelRepositories(), artifactDescriptorResult.getRepositories());
            return this.resolveDependencies(artifactDescriptorResult.getDependencies(), artifactDescriptorResult.getManagedDependencies(), remoteRepositories, includeTestDependencies, includeProvidedDependencies, repositoryState);
        }
        catch (RepositoryException e) {
            if (this.isArtifactNotFound(e.getCause())) {
                throw new BundleDependencyNotFoundException((Throwable)e);
            }
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    private Artifact createArtifactFromBundleDescriptor(BundleDescriptor bundleDescriptor) {
        return new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), (String)bundleDescriptor.getClassifier().orElse(null), bundleDescriptor.getType(), bundleDescriptor.getVersion());
    }

    public BundleDependency resolveBundleDescriptor(BundleDescriptor bundleDescriptor) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving artifact with resolution context: " + this.muleMavenResolutionContext.toString());
            }
            MuleMavenRepositoryState repositoryState = this.getRepositoryState(this.mavenConfiguration.getLocalMavenRepositoryLocation(), Optional.empty());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.muleMavenResolutionContext.getRemoteRepositories(), null);
            ArtifactResult artifactResult = repositoryState.getSystem().resolveArtifact((RepositorySystemSession)repositoryState.getSession(), artifactRequest);
            Artifact resolvedArtifact = artifactResult.getArtifact();
            return BundleDependencyHelper.artifactToBundleDependency(resolvedArtifact, "compile").build();
        }
        catch (ArtifactResolutionException e) {
            if (this.isArtifactNotFound(e.getCause())) {
                throw new BundleDependencyNotFoundException((Throwable)e);
            }
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    private boolean isArtifactNotFound(Throwable e) {
        return e instanceof ArtifactNotFoundException;
    }

    public MavenPomModel getRawPomModel(File artifactFile) {
        return new MavenPomParserImpl(artifactFile.toPath()).getModel();
    }

    public MavenPomModel getEffectiveModel(File artifactFile, Optional<File> temporaryFolder) {
        return this.getEffectiveModel(artifactFile, temporaryFolder, Optional.empty());
    }

    public List<BundleDependency> resolvePluginBundleDescriptorsDependencies(List<BundleDescriptor> bundleDescriptors) {
        MuleMavenRepositoryState repositoryState = this.getRepositoryState(this.mavenConfiguration.getLocalMavenRepositoryLocation(), Optional.empty());
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRepositories(this.muleMavenResolutionContext.getRemoteRepositories());
            collectRequest.setDependencies(bundleDescriptors.stream().map(bundleDescriptor -> new Dependency((Artifact)new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), MULE_PLUGIN_CLASSIFIER, JAR, bundleDescriptor.getVersion()), "compile")).collect(Collectors.toList()));
            return this.doResolveDependencies(repositoryState, collectRequest);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException(String.format("There was an issue solving the dependencies for the bundleDescriptors [%s]", bundleDescriptors), e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public org.mule.maven.client.api.VersionRangeResult resolveVersionRange(BundleDescriptor bundleDescriptor) {
        MuleMavenRepositoryState repositoryState = this.getRepositoryState(this.muleMavenResolutionContext.getLocalRepositoryLocation(), Optional.empty());
        try {
            VersionRange.createFromVersionSpec((String)bundleDescriptor.getVersion());
            VersionRangeResult versionRangeResult = repositoryState.getSystem().resolveVersionRange((RepositorySystemSession)repositoryState.getSession(), new VersionRangeRequest(this.createArtifactFromBundleDescriptor(bundleDescriptor), this.muleMavenResolutionContext.getRemoteRepositories(), null));
            return new DefaultVersionRangeResult(versionRangeResult);
        }
        catch (InvalidVersionSpecificationException | VersionRangeResolutionException e) {
            throw new RuntimeException(String.format("Couldn't resolve version range for bundleDescriptor: '%s'", bundleDescriptor.toString(), e));
        }
    }

    private List<BundleDependency> resolveDependencies(List<Dependency> dependencies, List<Dependency> managedDependencies, List<RemoteRepository> remoteRepositories, boolean enableTestDependencies, boolean enableProvidedDependencies, MuleMavenRepositoryState repositoryState) throws DependencyResolutionException {
        CollectRequest collectRequest = new CollectRequest();
        if (!dependencies.isEmpty()) {
            collectRequest.setDependencies(dependencies);
        }
        if (!managedDependencies.isEmpty()) {
            collectRequest.setManagedDependencies(managedDependencies);
        }
        if (!remoteRepositories.isEmpty()) {
            collectRequest.setRepositories(remoteRepositories);
        }
        return this.doResolveDependencies(repositoryState, collectRequest, enableTestDependencies, enableProvidedDependencies);
    }

    private List<BundleDependency> doResolveDependencies(MuleMavenRepositoryState repositoryState, CollectRequest collectRequest) throws DependencyResolutionException {
        return this.doResolveDependencies(repositoryState, collectRequest, false, false);
    }

    private List<BundleDependency> doResolveDependencies(MuleMavenRepositoryState repositoryState, CollectRequest collectRequest, boolean enableTestDependencies, boolean enableProvidedDependencies) throws DependencyResolutionException {
        Set domainDependencies = collectRequest.getDependencies().stream().filter(dependency -> MULE_DOMAIN_CLASSIFIER.equals(dependency.getArtifact().getClassifier()) && dependency.getScope().equalsIgnoreCase("provided")).collect(Collectors.toSet());
        collectRequest.setDependencies(collectRequest.getDependencies().stream().filter(dependency -> !domainDependencies.contains(dependency)).collect(Collectors.toList()));
        ArrayList<String> resolutionScopesToExclude = new ArrayList<String>(2);
        resolutionScopesToExclude.add("provided");
        resolutionScopesToExclude.add("test");
        if (enableTestDependencies) {
            resolutionScopesToExclude.remove("test");
        }
        ScopeDependencyFilter resolutionScopeDependencyFilter = new ScopeDependencyFilter(null, resolutionScopesToExclude);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        dependencyRequest.setFilter((DependencyFilter)new AndDependencyFilter(new DependencyFilter[]{resolutionScopeDependencyFilter, (node, parents) -> !node.getData().containsKey("conflict.winner")}));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Collecting and resolving transitive dependencies for request: {}", (Object)collectRequest);
        }
        DependencyResult dependencyResult = repositoryState.getSystem().resolveDependencies((RepositorySystemSession)repositoryState.getSession(), dependencyRequest);
        DependencyNode root = dependencyResult.getRoot();
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept((DependencyVisitor)nlg);
        BundleDependencyHelper bundleDependencyHelper = new BundleDependencyHelper();
        ArrayList<String> scopesToFilterFromResult = new ArrayList<String>(resolutionScopesToExclude);
        if (enableProvidedDependencies && !enableTestDependencies) {
            scopesToFilterFromResult.clear();
            scopesToFilterFromResult.add("test");
        } else if (enableTestDependencies && enableProvidedDependencies) {
            scopesToFilterFromResult.clear();
        }
        ScopeDependencyFilter bundleDependenciesFilter = new ScopeDependencyFilter(null, scopesToFilterFromResult);
        AndDependencyFilter childDependenciesFilter = new AndDependencyFilter(new DependencyFilter[]{new ScopeDependencyFilter(new String[]{null, "provided"}), bundleDependenciesFilter});
        List<BundleDependency> bundleDependencies = nlg.getNodes().stream().filter(node -> !node.getData().containsKey("conflict.winner")).filter(node -> !node.getData().containsKey("plugin-ancestor") || node.getData().get("plugin-ancestor").equals(root)).filter(arg_0 -> MuleMavenClient.lambda$doResolveDependencies$12((DependencyFilter)bundleDependenciesFilter, arg_0)).map(arg_0 -> MuleMavenClient.lambda$doResolveDependencies$13(bundleDependencyHelper, (DependencyFilter)childDependenciesFilter, arg_0)).collect(Collectors.toList());
        if (enableProvidedDependencies) {
            bundleDependencies.addAll(domainDependencies.stream().map(dependency -> BundleDependencyHelper.artifactToBundleDependency(dependency.getArtifact(), dependency.getScope()).build()).collect(Collectors.toList()));
        }
        return bundleDependencies;
    }

    private static Dependency convertModelDependency(org.apache.maven.model.Dependency modelDependency, ArtifactTypeRegistry artifactTypeRegistry) {
        ArtifactType artifactType = artifactTypeRegistry.get(modelDependency.getType());
        if (artifactType == null) {
            artifactType = new DefaultArtifactType(modelDependency.getType(), modelDependency.getType(), modelDependency.getClassifier(), "none");
        }
        DefaultArtifact artifactDependency = new DefaultArtifact(modelDependency.getGroupId(), modelDependency.getArtifactId(), modelDependency.getClassifier() != null ? modelDependency.getClassifier() : artifactType.getClassifier(), artifactType.getExtension(), modelDependency.getVersion(), (Map)("system".equals(modelDependency.getScope()) ? ImmutableMap.of((Object)"localPath", (Object)modelDependency.getSystemPath()) : Collections.emptyMap()), "system".equals(modelDependency.getScope()) ? new File(modelDependency.getSystemPath()) : null);
        Dependency dependency = new Dependency((Artifact)artifactDependency, modelDependency.getScope());
        dependency = dependency.setOptional(Boolean.valueOf(modelDependency.isOptional()));
        dependency = dependency.setExclusions((Collection)modelDependency.getExclusions().stream().map(modelExclusion -> new Exclusion(modelExclusion.getGroupId(), modelExclusion.getArtifactId(), ANY, ANY)).collect(Collectors.toList()));
        return dependency;
    }

    private void setPom(ModelBuildingRequest modelBuildingRequest, File artifactFile, Optional<File> temporaryFolder) {
        Object modelSource;
        if (artifactFile.isFile() && !FilenameUtils.getExtension((String)artifactFile.getName()).equalsIgnoreCase(JAR)) {
            modelSource = new FileModelSource(artifactFile);
        } else {
            MavenPomParserImpl parser = new MavenPomParserImpl(artifactFile.toPath());
            MavenPomModel rawPomModel = parser.getModel();
            BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setGroupId(rawPomModel.getGroupId() != null ? rawPomModel.getGroupId() : ((PomParentCoordinates)rawPomModel.getParent().get()).getGroupId()).setArtifactId(rawPomModel.getArtifactId()).setVersion(rawPomModel.getVersion() != null ? rawPomModel.getVersion() : ((PomParentCoordinates)rawPomModel.getParent().get()).getVersion()).build();
            modelSource = artifactFile.isDirectory() ? new FileModelSource((File)this.pomFileSupplierFactory.uncompressPomArtifactSupplier(artifactFile, bundleDescriptor).get()) : temporaryFolder.map(t -> new FileModelSource((File)this.pomFileSupplierFactory.compressedArtifactSupplier(artifactFile, bundleDescriptor, t).get())).orElse(new UrlModelSource(FileUtils.getPomUrlFromJar((File)artifactFile)));
        }
        if (modelSource instanceof FileModelSource) {
            modelBuildingRequest.setPomFile(modelSource.getFile());
        }
        modelBuildingRequest.setModelSource((ModelSource)modelSource);
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Dependency path to not resolved artifacts -> " + unresolvedArtifactPath);
            }
        });
    }

    public void close() throws Exception {
        this.muleMavenRepositoryStateFactory.close();
    }

    private Model getMavenEffectiveModel(File artifactFile, Optional<File> temporaryFolder, Optional<MuleMavenRepositoryState> repositoryStateOptional) {
        Model model;
        try {
            MuleMavenRepositoryState repositoryState = repositoryStateOptional.orElseGet(() -> this.getRepositoryState(this.muleMavenResolutionContext.getLocalRepositoryLocation(), Optional.empty()));
            DefaultModelBuildingRequest defaultModelBuildingRequest = new DefaultModelBuildingRequest();
            this.setPom((ModelBuildingRequest)defaultModelBuildingRequest, artifactFile, temporaryFolder);
            this.mavenConfiguration.getUserProperties().ifPresent(properties -> defaultModelBuildingRequest.setUserProperties(properties));
            this.mavenConfiguration.getActiveProfiles().ifPresent(profiles -> defaultModelBuildingRequest.setActiveProfileIds(profiles));
            this.mavenConfiguration.getInactiveProfiles().ifPresent(profiles -> defaultModelBuildingRequest.setInactiveProfileIds(profiles));
            defaultModelBuildingRequest.setTwoPhaseBuilding(false);
            defaultModelBuildingRequest.setProcessPlugins(false);
            defaultModelBuildingRequest.setModelCache(DefaultModelCache.newInstance((RepositorySystemSession)repositoryState.getSession()));
            defaultModelBuildingRequest.setModelResolver(repositoryState.createModelResolver(this.muleMavenResolutionContext.getRemoteRepositories()));
            defaultModelBuildingRequest.setSystemProperties(System.getProperties());
            defaultModelBuildingRequest.setValidationLevel(0);
            model = new DefaultModelBuilderFactory().newInstance().build((ModelBuildingRequest)defaultModelBuildingRequest).getEffectiveModel();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return model;
    }

    private static /* synthetic */ BundleDependency lambda$doResolveDependencies$13(BundleDependencyHelper bundleDependencyHelper, DependencyFilter childDependenciesFilter, DependencyNode node) {
        return bundleDependencyHelper.getBundleDependency(node, childDependenciesFilter);
    }

    private static /* synthetic */ boolean lambda$doResolveDependencies$12(DependencyFilter bundleDependenciesFilter, DependencyNode node) {
        return bundleDependenciesFilter.accept(node, Collections.emptyList());
    }

    private static class MavenWorkspaceReaderAdapter
    implements WorkspaceReader {
        private final WorkspaceRepository workspaceRepository = new WorkspaceRepository(String.format("worskpace-repository-reactor", new Object[0]));
        private final MavenReactorResolver mavenReactorResolver;

        MavenWorkspaceReaderAdapter(MavenReactorResolver mavenReactorResolver) {
            this.mavenReactorResolver = mavenReactorResolver;
        }

        public WorkspaceRepository getRepository() {
            return this.workspaceRepository;
        }

        public File findArtifact(Artifact artifact) {
            return this.mavenReactorResolver.findArtifact(this.toBundleDescriptor(artifact));
        }

        public BundleDescriptor toBundleDescriptor(Artifact artifact) {
            return new BundleDescriptor.Builder().setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension()).build();
        }

        public List<String> findVersions(Artifact artifact) {
            return this.mavenReactorResolver.findVersions(this.toBundleDescriptor(artifact));
        }
    }
}

