/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.model;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManagerFactory;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeHandlerManagerFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class ExtensionModelHelper {
    private static final String ON_ERROR_MODEL = "onError";
    private static final String ON_ERROR_CONTINUE_MODEL = "onErrorContinue";
    private static final String ON_ERROR_PROPAGATE_MODEL = "onErrorPropagate";
    private static final String ON_ERROR_CONTINUE = "on-error-continue";
    private static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    public static final ComponentIdentifier ON_ERROR_CONTINUE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-continue").build();
    public static final ComponentIdentifier ON_ERROR_PROPAGATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-propagate").build();
    private final Set<ExtensionModel> extensionsModels;
    private final Cache<ComponentIdentifier, Optional<ComponentModel>> extensionComponentModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<ConnectionProviderModel>> extensionConnectionProviderModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<ConfigurationModel>> extensionConfigurationModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Optional<DslSyntaxResolver> muleTopLevelDslSyntaxResolver;
    private final LoadingCache<ExtensionModel, DslSyntaxResolver> dslSyntaxResolversByExtension;
    private final JavaTypeLoader javaTypeLoader = new JavaTypeLoader(ExtensionModelHelper.class.getClassLoader(), (TypeHandlerManagerFactory)new ExtensionsTypeHandlerManagerFactory());
    private final DslResolvingContext dslResolvingContext;

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels) {
        this(extensionModels, DslResolvingContext.getDefault(extensionModels));
    }

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels, DslResolvingContext dslResolvingCtx) {
        this.extensionsModels = extensionModels;
        this.muleTopLevelDslSyntaxResolver = extensionModels.stream().filter(extModel -> extModel.getName().equals("mule")).map(extModel -> DslSyntaxResolver.getDefault((ExtensionModel)extModel, (DslResolvingContext)dslResolvingCtx)).findAny();
        this.dslSyntaxResolversByExtension = Caffeine.newBuilder().build(key -> DslSyntaxResolver.getDefault((ExtensionModel)key, (DslResolvingContext)dslResolvingCtx));
        this.dslResolvingContext = dslResolvingCtx;
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentIdentifier componentIdentifier) {
        return this.findComponentModel(componentIdentifier).map(this::findComponentType).orElse(TypedComponentIdentifier.ComponentType.UNKNOWN);
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentModel extensionComponentModel) {
        final Reference componentTypeReference = new Reference();
        extensionComponentModel.accept(new ComponentModelVisitor(){

            public void visit(OperationModel model) {
                componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.OPERATION);
                this.determineFromNested((Reference<TypedComponentIdentifier.ComponentType>)componentTypeReference, (ComposableModel)model);
            }

            public void visit(SourceModel model) {
                componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.SOURCE);
            }

            public void visit(ConstructModel model) {
                StereotypeModel st = model.getStereotype();
                if (st.equals(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                    return;
                }
                if (st.equals(MuleStereotypes.ON_ERROR)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.ON_ERROR);
                    return;
                }
                if (st.equals(MuleStereotypes.FLOW)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.FLOW);
                    return;
                }
                if (st.equals(MuleStereotypes.CHAIN)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.CHAIN);
                    return;
                }
                if (st.equals(MuleStereotypes.OPERATION_DEF_STEREOTYPE)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.OPERATION_DEF);
                    return;
                }
                if (st.equals(MuleStereotypes.OUTPUT_PAYLOAD_STEREOTYPE)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.OUTPUT_PAYLOAD_TYPE);
                    return;
                }
                if (st.equals(MuleStereotypes.OUTPUT_ATTRIBUTES_STEREOTYPE)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.OUTPUT_ATTRIBUTES_TYPE);
                    return;
                }
                this.determineFromNested((Reference<TypedComponentIdentifier.ComponentType>)componentTypeReference, (ComposableModel)model);
            }

            protected void determineFromNested(Reference<TypedComponentIdentifier.ComponentType> componentTypeReference2, ComposableModel model) {
                NestedComponentVisitor nestedComponentVisitor = new NestedComponentVisitor(componentTypeReference2);
                for (NestableElementModel nestableElementModel : model.getNestedComponents()) {
                    nestableElementModel.accept((ComponentModelVisitor)nestedComponentVisitor);
                    if (componentTypeReference2.get() == null) continue;
                    return;
                }
            }

            public void visit(NestedComponentModel model) {
                if (model.getAllowedStereotypes().contains(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                    return;
                }
                if (model.getAllowedStereotypes().contains(MuleStereotypes.ON_ERROR)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.ON_ERROR);
                    return;
                }
            }

            public void visit(NestedChainModel model) {
                componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.CHAIN);
            }

            public void visit(NestedRouteModel model) {
                componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.ROUTE);
            }
        });
        return componentTypeReference.get() == null ? TypedComponentIdentifier.ComponentType.UNKNOWN : (TypedComponentIdentifier.ComponentType)componentTypeReference.get();
    }

    public Optional<ComponentModel> findComponentModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionComponentModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(extensionModel -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)extensionModel, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$extensionModel;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$extensionModel = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$extensionModel);
                }

                protected void onOperation(OperationModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, (ComponentModel)model);
                }

                protected void onSource(SourceModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, (ComponentModel)model);
                }

                protected void onConstruct(ConstructModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, (ComponentModel)model);
                }

                protected void onNestable(NestableElementModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, (ComponentModel)model);
                }

                protected void onModel(ComponentIdentifier componentIdentifier, AtomicReference<ComponentModel> modelRef, ComponentModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(componentIdentifier.getName())) {
                        modelRef.set(model);
                    }
                }
            }.walk(extensionModel);
            return Optional.ofNullable((ComponentModel)modelRef.get());
        }));
    }

    public Optional<ConnectionProviderModel> findConnectionProviderModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConnectionProviderModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
                }

                protected void onConnectionProvider(ConnectionProviderModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk(currentExtension);
            return Optional.ofNullable((ConnectionProviderModel)modelRef.get());
        }));
    }

    public Optional<ConfigurationModel> findConfigurationModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConfigurationModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
                }

                protected void onConfiguration(ConfigurationModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk(currentExtension);
            return Optional.ofNullable((ConfigurationModel)modelRef.get());
        }));
    }

    public Optional<ParameterModel> findParameterModel(ComponentIdentifier nestedComponentId, ParameterizedModel model) {
        return this.lookupExtensionModelFor(nestedComponentId).flatMap(currentExtension -> {
            DslSyntaxResolver dslSyntaxResolver = (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get(currentExtension);
            return model.getAllParameterModels().stream().filter(pm -> dslSyntaxResolver.resolve(pm).getElementName().equals(nestedComponentId.getName())).findAny();
        });
    }

    public void walkToComponent(final ComponentIdentifier componentIdentifier, final Optional<ComponentIdentifier> parentIdentifier, final ExtensionWalkerModelDelegate delegate, final ExtensionModel currentExtension) {
        new IdempotentExtensionWalker(){
            final DslSyntaxResolver dslSyntaxResolver;
            final List<ConstructModel> overriders;
            {
                this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)currentExtension);
                this.overriders = currentExtension.getConstructModels();
            }

            protected void onConfiguration(ConfigurationModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConfiguration(model);
                    this.stop();
                }
            }

            protected void onConnectionProvider(ConnectionProviderModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConnectionProvider(model);
                    this.stop();
                }
            }

            protected void onOperation(OperationModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onOperation(model);
                    this.stop();
                }
            }

            protected void onSource(SourceModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onSource(model);
                    this.stop();
                }
            }

            protected void onConstruct(ConstructModel model) {
                DslElementSyntax dslSyntax = ExtensionModelHelper.this.muleTopLevelDslSyntaxResolver.map(resolver -> resolver.resolve((NamedObject)model)).orElseGet(() -> this.dslSyntaxResolver.resolve((NamedObject)model));
                if (dslSyntax.getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConstruct(model);
                    this.stop();
                }
            }

            private Optional<ConstructModel> findOnErrorOverrider(NestableElementModel model) {
                if (!ExtensionModelHelper.ON_ERROR_MODEL.equals(model.getName())) {
                    return Optional.empty();
                }
                return this.overriders.stream().filter(e -> e.getName().equals(model.getName())).findFirst();
            }

            protected void onNestable(ComposableModel owner, NestableElementModel model) {
                if (!parentIdentifier.isPresent()) {
                    return;
                }
                if (!this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(componentIdentifier.getName())) {
                    return;
                }
                if (!this.dslSyntaxResolver.resolve((NamedObject)owner).getElementName().equals(((ComponentIdentifier)parentIdentifier.get()).getName())) {
                    return;
                }
                Optional<ConstructModel> overrider = this.findOnErrorOverrider(model);
                if (overrider.isPresent()) {
                    delegate.onConstruct(overrider.get());
                } else {
                    if (this.shouldSkipNestable(model, currentExtension)) {
                        return;
                    }
                    delegate.onNestableElement(model);
                }
                this.stop();
            }

            private boolean shouldSkipNestable(NestableElementModel model, ExtensionModel currentExtension2) {
                if (ExtensionModelHelper.ON_ERROR_PROPAGATE_MODEL.equals(model.getName())) {
                    return false;
                }
                if (ExtensionModelHelper.ON_ERROR_CONTINUE_MODEL.equals(model.getName())) {
                    return false;
                }
                return currentExtension2.getConstructModel(model.getName()).isPresent();
            }

            protected void onType(MetadataType type) {
                ExtensionModelHelper.this.resolveDslElementModel(type, currentExtension).filter(dsl -> ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build().equals(componentIdentifier)).ifPresent(dsl -> {
                    if (ExtensionModelHelper.this.walkableType(type, dsl)) {
                        delegate.onType(type);
                    }
                    this.stop();
                });
            }
        }.walk(currentExtension);
    }

    private boolean walkableType(MetadataType type, DslElementSyntax dsl) {
        return dsl.supportsTopLevelDeclaration() || dsl.supportsChildDeclaration() && dsl.isWrapped() || ExtensionMetadataTypeUtils.getSubstitutionGroup((MetadataType)type).isPresent() || this.getAllSubTypes().contains(type);
    }

    public Optional<MetadataType> findMetadataType(Class<?> type) {
        if (type != null) {
            return Optional.of(this.javaTypeLoader.load(type));
        }
        return Optional.empty();
    }

    public Optional<ExtensionModel> lookupExtensionModelFor(ComponentIdentifier componentIdentifier) {
        return this.lookupExtensionModelFor(componentIdentifier.getNamespace());
    }

    private Optional<ExtensionModel> lookupExtensionModelFor(String namespacePrefix) {
        return this.extensionsModels.stream().filter(e -> e.getXmlDslModel().getPrefix().equals(namespacePrefix.equals("tls") ? "mule" : namespacePrefix)).findFirst();
    }

    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType type, String namespacePrefix) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(namespacePrefix);
        return dslSyntaxResolver.resolve(type);
    }

    public DslElementSyntax resolveDslElementModel(NamedObject component, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(component);
    }

    private DslSyntaxResolver getDslSyntaxResolver(ComponentIdentifier componentIdentifier) {
        Optional<ExtensionModel> optionalExtensionModel = this.lookupExtensionModelFor(componentIdentifier);
        ExtensionModel extensionModel = optionalExtensionModel.orElseThrow(() -> new IllegalStateException("Extension Model in context not present for componentIdentifier: " + componentIdentifier));
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel);
    }

    private DslSyntaxResolver getDslSyntaxResolver(String namespacePrefix) {
        Optional<ExtensionModel> optionalExtensionModel = this.lookupExtensionModelFor(namespacePrefix);
        ExtensionModel extensionModel = optionalExtensionModel.orElseThrow(() -> new IllegalStateException("Extension Model in context not present for namespace: " + namespacePrefix));
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel);
    }

    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType metadataType, ExtensionModel extensionModel) {
        return ((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel)).resolve(metadataType);
    }

    public DslElementSyntax resolveDslElementModel(ParameterModel parameterModel, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(parameterModel);
    }

    public Map<ObjectType, Optional<DslElementSyntax>> resolveSubTypes(ObjectType type) {
        LinkedHashMap singletonizedSubTypes = new LinkedHashMap();
        MetadataTypeUtils.getTypeId((MetadataType)type).ifPresent(typeId -> this.getTypeCatalog().getDeclaringExtension(typeId).flatMap(arg_0 -> ((DslResolvingContext)this.dslResolvingContext).getExtension(arg_0)).ifPresent(declaringExtension -> singletonizedSubTypes.putIfAbsent(new Pair(declaringExtension, typeId), type)));
        for (ObjectType subType : this.getTypeCatalog().getSubTypes(type)) {
            MetadataTypeUtils.getTypeId((MetadataType)subType).ifPresent(subTypeId -> this.getTypeCatalog().getDeclaringExtension(subTypeId).flatMap(arg_0 -> ((DslResolvingContext)this.dslResolvingContext).getExtension(arg_0)).ifPresent(declaringExtension -> singletonizedSubTypes.putIfAbsent(new Pair(declaringExtension, subTypeId), subType)));
        }
        return singletonizedSubTypes.entrySet().stream().filter(t -> ((ObjectType)t.getValue()).getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isInstantiable).orElse(true)).collect(Collectors.toMap(Map.Entry::getValue, e -> ((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)((ExtensionModel)((Pair)e.getKey()).getFirst()))).resolve((MetadataType)e.getValue()), (x, y) -> x, LinkedHashMap::new));
    }

    private Collection<ObjectType> getAllSubTypes() {
        return this.getTypeCatalog().getAllSubTypes();
    }

    public TypeCatalog getTypeCatalog() {
        return this.dslResolvingContext.getTypeCatalog();
    }

    public Set<ExtensionModel> getExtensionsModels() {
        return this.extensionsModels;
    }

    static class NestedComponentVisitor
    implements ComponentModelVisitor {
        private final Reference<TypedComponentIdentifier.ComponentType> reference;

        public NestedComponentVisitor(Reference<TypedComponentIdentifier.ComponentType> reference) {
            this.reference = reference;
        }

        public void visit(NestedChainModel component) {
            this.reference.set((Object)TypedComponentIdentifier.ComponentType.SCOPE);
        }

        public void visit(NestedRouteModel component) {
            this.reference.set((Object)TypedComponentIdentifier.ComponentType.ROUTER);
        }

        public void visit(NestedComponentModel component) {
        }

        public void visit(OperationModel model) {
        }

        public void visit(SourceModel model) {
        }

        public void visit(ConstructModel model) {
        }
    }

    public static interface ExtensionWalkerModelDelegate {
        public void onConfiguration(ConfigurationModel var1);

        public void onConnectionProvider(ConnectionProviderModel var1);

        public void onOperation(OperationModel var1);

        public void onSource(SourceModel var1);

        public void onConstruct(ConstructModel var1);

        public void onNestableElement(NestableElementModel var1);

        public void onType(MetadataType var1);
    }
}

