/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AsynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private final AttributesProcessor attributesProcessor;
    private final int maxCardinality;
    private Map<Attributes, T> points = new HashMap<Attributes, T>();
    private Map<Attributes, T> lastPoints = new HashMap<Attributes, T>();

    private AsynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int maxCardinality) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality;
    }

    static <T extends PointData, U extends ExemplarData> AsynchronousMetricStorage<T, U> create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilter.alwaysOff());
        return new AsynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit());
    }

    void record(Measurement measurement) {
        Context context = Context.current();
        Attributes processedAttributes = this.attributesProcessor.process(measurement.attributes(), context);
        long start = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : measurement.startEpochNanos();
        measurement = measurement.hasDoubleValue() ? Measurement.doubleMeasurement(start, measurement.epochNanos(), measurement.doubleValue(), processedAttributes) : Measurement.longMeasurement(start, measurement.epochNanos(), measurement.longValue(), processedAttributes);
        this.recordPoint(this.aggregator.toPoint(measurement));
    }

    private void recordPoint(T point) {
        Attributes attributes = point.getAttributes();
        if (this.points.size() >= this.maxCardinality) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            return;
        }
        if (this.points.containsKey(attributes)) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded multiple values for the same attributes.");
            return;
        }
        this.points.put(attributes, point);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        Map<Attributes, T> result;
        if (this.aggregationTemporality == AggregationTemporality.DELTA) {
            Map points = this.points;
            Map<Attributes, T> lastPoints = this.lastPoints;
            lastPoints.entrySet().removeIf(entry -> !points.containsKey(entry.getKey()));
            points.forEach((k, v) -> lastPoints.compute((Attributes)k, (k2, v2) -> v2 == null ? v : this.aggregator.diff((PointData)v2, (PointData)v)));
            result = lastPoints;
            this.lastPoints = points;
        } else {
            result = this.points;
        }
        this.points = new HashMap<Attributes, T>();
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, result.values(), this.aggregationTemporality);
    }

    @Override
    public boolean isEmpty() {
        return this.aggregator == Aggregator.drop();
    }
}

