/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.DefaultMuleContainerClassLoaderWrapper;
import org.mule.runtime.container.internal.DefaultPreFilteredContainerClassLoaderCreator;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ContainerClassLoaderFactory {
    private final PreFilteredContainerClassLoaderCreator preFilteredContainerClassLoaderCreator;

    public ContainerClassLoaderFactory(PreFilteredContainerClassLoaderCreator preFilteredContainerClassLoaderCreator) {
        Preconditions.checkArgument((preFilteredContainerClassLoaderCreator != null ? 1 : 0) != 0, (String)"containerClassLoaderCreator cannot be null");
        this.preFilteredContainerClassLoaderCreator = preFilteredContainerClassLoaderCreator;
    }

    public ContainerClassLoaderFactory(ModuleRepository moduleRepository) {
        this(new DefaultPreFilteredContainerClassLoaderCreator(moduleRepository));
    }

    public ContainerClassLoaderFactory() {
        this(new DefaultModuleRepository(new ContainerModuleDiscoverer(ContainerClassLoaderFactory.class.getClassLoader())));
    }

    public MuleContainerClassLoaderWrapper createContainerClassLoader(ClassLoader parentClassLoader) {
        List<MuleModule> muleModules = this.preFilteredContainerClassLoaderCreator.getMuleModules();
        return new DefaultMuleContainerClassLoaderWrapper(this.createArtifactClassLoader(parentClassLoader, muleModules, new ArtifactDescriptor("mule")));
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ArtifactDescriptor artifactDescriptor) {
        return this.createContainerFilteringClassLoader(parentClassLoader, muleModules, this.preFilteredContainerClassLoaderCreator.getPreFilteredContainerClassLoader(artifactDescriptor, parentClassLoader));
    }

    protected FilteringArtifactClassLoader createContainerFilteringClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ArtifactClassLoader containerClassLoader) {
        return new FilteringContainerClassLoader(parentClassLoader, containerClassLoader, new ContainerClassLoaderFilterFactory().create(this.preFilteredContainerClassLoaderCreator.getBootPackages(), muleModules), this.getExportedServices(muleModules));
    }

    private List<ExportedService> getExportedServices(List<MuleModule> muleModules) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (MuleModule muleModule : muleModules) {
            exportedServices.addAll(muleModule.getExportedServices());
        }
        return exportedServices;
    }
}

