/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSArrayFirstElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayLastElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

public abstract class ForEachIndexCallNode
extends JavaScriptBaseNode {
    @Node.Child
    private IsArrayNode isArrayNode = IsArrayNode.createIsAnyArray();
    protected final JSClassProfile targetClassProfile = JSClassProfile.create();
    protected final LoopConditionProfile loopCond = LoopConditionProfile.createCountingProfile();
    @Node.Child
    private CallbackNode callbackNode;
    @Node.Child
    protected MaybeResultNode maybeResultNode;
    @Node.Child
    private ReadElementNode.ReadElementArrayDispatchNode readElementNode;
    @Node.Child
    private JSArrayFirstElementIndexNode firstElementIndexNode;
    @Node.Child
    private JSArrayLastElementIndexNode lastElementIndexNode;
    @Node.Child
    private JSHasPropertyNode hasPropertyNode;
    @Node.Child
    private ImportValueNode toJSTypeNode;
    @Node.Child
    private InteropLibrary interop;
    protected final JSContext context;

    protected ForEachIndexCallNode(JSContext context, CallbackNode callbackArgumentsNode, MaybeResultNode maybeResultNode) {
        this.callbackNode = callbackArgumentsNode;
        this.maybeResultNode = maybeResultNode;
        this.context = context;
        this.readElementNode = ReadElementNode.ReadElementArrayDispatchNode.create();
    }

    public static ForEachIndexCallNode create(JSContext context, CallbackNode callbackArgumentsNode, MaybeResultNode maybeResultNode, boolean forward) {
        if (forward) {
            return new ForwardForEachIndexCallNode(context, callbackArgumentsNode, maybeResultNode);
        }
        return new BackwardForEachIndexCallNode(context, callbackArgumentsNode, maybeResultNode);
    }

    public final Object executeForEachIndex(Object target, Object callback, Object callbackThisArg, long fromIndex, long length, Object initialResult) {
        boolean isArray = this.isArrayNode.execute(target);
        if (isArray && this.context.getArrayPrototypeNoElementsAssumption().isValid()) {
            return this.executeForEachIndexFast((DynamicObject)target, callback, callbackThisArg, fromIndex, length, initialResult);
        }
        return this.executeForEachIndexSlow(target, callback, callbackThisArg, fromIndex, length, initialResult);
    }

    protected abstract Object executeForEachIndexFast(DynamicObject var1, Object var2, Object var3, long var4, long var6, Object var8);

    protected abstract Object executeForEachIndexSlow(Object var1, Object var2, Object var3, long var4, long var6, Object var8);

    protected final long firstElementIndex(DynamicObject target, long length) {
        if (this.firstElementIndexNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.firstElementIndexNode = (JSArrayFirstElementIndexNode)this.insert(JSArrayFirstElementIndexNode.create(this.context));
        }
        return this.firstElementIndexNode.executeLong(target, length);
    }

    protected final long lastElementIndex(DynamicObject target, long length) {
        if (this.lastElementIndexNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lastElementIndexNode = (JSArrayLastElementIndexNode)this.insert(JSArrayLastElementIndexNode.create(this.context));
        }
        return this.lastElementIndexNode.executeLong(target, length);
    }

    protected final InteropLibrary getInterop() {
        if (this.interop == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.interop = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
        }
        return this.interop;
    }

    protected Object foreignRead(Object target, long index) {
        if (this.toJSTypeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toJSTypeNode = (ImportValueNode)this.insert(ImportValueNode.create());
        }
        return JSInteropUtil.readArrayElementOrDefault(target, index, (Object)Undefined.instance, this.getInterop(), this.toJSTypeNode, this);
    }

    protected Object getElement(Object target, long index, boolean isForeign) {
        if (!isForeign) {
            assert (JSDynamicObject.isJSDynamicObject(target));
            return JSObject.get((DynamicObject)target, index, this.targetClassProfile);
        }
        return this.foreignRead(target, index);
    }

    protected final void checkHasDetachedBuffer(Object view) {
        if (!this.context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBufferView.isJSArrayBufferView(view) && JSArrayBufferView.hasDetachedBuffer((DynamicObject)view)) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
    }

    protected final Object callback(long index, Object value, Object target, Object callback, Object callbackThisArg, Object currentResult) {
        if (this.callbackNode == null) {
            return callbackThisArg;
        }
        return this.callbackNode.apply(index, value, target, callback, callbackThisArg, currentResult);
    }

    protected final Object readElementInBounds(DynamicObject target, long index) {
        return this.readElementNode.executeArrayGet(target, JSObject.getArray(target), index, target, (Object)Undefined.instance, this.context);
    }

    protected final boolean hasProperty(Object target, long index) {
        if (this.hasPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.hasPropertyNode = (JSHasPropertyNode)this.insert(JSHasPropertyNode.create());
        }
        return this.hasPropertyNode.executeBoolean(target, index);
    }

    protected static final class BackwardForEachIndexCallNode
    extends ForEachIndexCallNode {
        @Node.Child
        protected JSArrayPreviousElementIndexNode previousElementIndexNode;

        public BackwardForEachIndexCallNode(JSContext context, CallbackNode callbackArgumentsNode, MaybeResultNode maybeResultNode) {
            super(context, callbackArgumentsNode, maybeResultNode);
        }

        @Override
        protected Object executeForEachIndexFast(DynamicObject target, Object callback, Object callbackThisArg, long fromIndex, long length, Object initialResult) {
            assert (fromIndex < length);
            long index = this.previousElementIndex(target, fromIndex + 1L);
            Object currentResult = initialResult;
            long count = 0L;
            while (this.loopCond.profile(index >= 0L && index >= this.firstElementIndex(target, length))) {
                Object value = this.readElementInBounds(target, index);
                Object callbackResult = this.callback(index, value, target, callback, callbackThisArg, currentResult);
                MaybeResult<Object> maybeResult = this.maybeResultNode.apply(index, value, callbackResult, currentResult);
                this.checkHasDetachedBuffer(target);
                currentResult = maybeResult.get();
                if (maybeResult.isPresent()) break;
                ++count;
                index = this.previousElementIndex(target, index);
            }
            ArrayPrototypeBuiltins.BasicArrayOperation.reportLoopCount(this, count);
            return currentResult;
        }

        @Override
        protected Object executeForEachIndexSlow(Object target, Object callback, Object callbackThisArg, long fromIndex, long length, Object initialResult) {
            Object currentResult = initialResult;
            boolean isForeign = JSRuntime.isForeignObject(target);
            if (isForeign && !this.getInterop().hasArrayElements(target)) {
                return currentResult;
            }
            for (long index = fromIndex; index >= 0L; --index) {
                if (!this.hasProperty(target, index)) continue;
                Object value = this.getElement(target, index, isForeign);
                Object callbackResult = this.callback(index, value, target, callback, callbackThisArg, currentResult);
                MaybeResult<Object> maybeResult = this.maybeResultNode.apply(index, value, callbackResult, currentResult);
                this.checkHasDetachedBuffer(target);
                currentResult = maybeResult.get();
                if (maybeResult.isPresent()) break;
            }
            ArrayPrototypeBuiltins.BasicArrayOperation.reportLoopCount(this, fromIndex);
            return currentResult;
        }

        private long previousElementIndex(DynamicObject target, long currentIndex) {
            if (this.previousElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.previousElementIndexNode = (JSArrayPreviousElementIndexNode)this.insert(JSArrayPreviousElementIndexNode.create(this.context));
            }
            return this.previousElementIndexNode.executeLong(target, currentIndex);
        }
    }

    protected static final class ForwardForEachIndexCallNode
    extends ForEachIndexCallNode {
        private final ConditionProfile fromIndexZero = ConditionProfile.createBinaryProfile();
        @Node.Child
        private JSArrayNextElementIndexNode nextElementIndexNode;

        public ForwardForEachIndexCallNode(JSContext context, CallbackNode callbackArgumentsNode, MaybeResultNode maybeResultNode) {
            super(context, callbackArgumentsNode, maybeResultNode);
        }

        @Override
        protected Object executeForEachIndexFast(DynamicObject target, Object callback, Object callbackThisArg, long fromIndex, long length, Object initialResult) {
            long index = this.fromIndexZero.profile(fromIndex == 0L) ? this.firstElementIndex(target, length) : this.nextElementIndex(target, fromIndex - 1L, length);
            Object currentResult = initialResult;
            long count = 0L;
            while (this.loopCond.profile(index < length && index <= this.lastElementIndex(target, length))) {
                Object value = this.readElementInBounds(target, index);
                Object callbackResult = this.callback(index, value, target, callback, callbackThisArg, currentResult);
                MaybeResult<Object> maybeResult = this.maybeResultNode.apply(index, value, callbackResult, currentResult);
                this.checkHasDetachedBuffer(target);
                currentResult = maybeResult.get();
                if (maybeResult.isPresent()) break;
                ++count;
                index = this.nextElementIndex(target, index, length);
            }
            ArrayPrototypeBuiltins.BasicArrayOperation.reportLoopCount(this, count);
            return currentResult;
        }

        @Override
        protected Object executeForEachIndexSlow(Object target, Object callback, Object callbackThisArg, long fromIndex, long length, Object initialResult) {
            Object currentResult = initialResult;
            boolean isForeign = JSRuntime.isForeignObject(target);
            if (isForeign && !this.getInterop().hasArrayElements(target)) {
                return currentResult;
            }
            for (long index = fromIndex; index < length; ++index) {
                if (!this.hasProperty(target, index)) continue;
                Object value = this.getElement(target, index, isForeign);
                Object callbackResult = this.callback(index, value, target, callback, callbackThisArg, currentResult);
                MaybeResult<Object> maybeResult = this.maybeResultNode.apply(index, value, callbackResult, currentResult);
                this.checkHasDetachedBuffer(target);
                currentResult = maybeResult.get();
                if (maybeResult.isPresent()) break;
            }
            ArrayPrototypeBuiltins.BasicArrayOperation.reportLoopCount(this, length - fromIndex);
            return currentResult;
        }

        private long nextElementIndex(DynamicObject target, long currentIndex, long length) {
            if (this.nextElementIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nextElementIndexNode = (JSArrayNextElementIndexNode)this.insert(JSArrayNextElementIndexNode.create(this.context));
            }
            return this.nextElementIndexNode.executeLong(target, currentIndex, length);
        }
    }

    public static abstract class MaybeResultNode
    extends JavaScriptBaseNode {
        public abstract MaybeResult<Object> apply(long var1, Object var3, Object var4, Object var5);
    }

    @CompilerDirectives.ValueType
    public static final class MaybeResult<T> {
        private final T result;
        private final boolean resultPresent;

        public MaybeResult(T result, boolean resultPresent) {
            this.result = result;
            this.resultPresent = resultPresent;
        }

        public static <T> MaybeResult<T> returnResult(T result) {
            return new MaybeResult<T>(result, true);
        }

        public static <T> MaybeResult<T> continueResult(T result) {
            return new MaybeResult<T>(result, false);
        }

        public boolean isPresent() {
            return this.resultPresent;
        }

        public T get() {
            return this.result;
        }
    }

    public static abstract class CallbackNode
    extends JavaScriptBaseNode {
        public abstract Object apply(long var1, Object var3, Object var4, Object var5, Object var6, Object var7);
    }
}

