/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.JSProxyHasPropertyNode;
import com.oracle.truffle.js.nodes.access.JSProxyHasPropertyNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

public class HasPropertyCacheNode
extends PropertyCacheNode<HasCacheNode> {
    private final boolean hasOwnProperty;
    private boolean propertyAssumptionCheckEnabled = true;

    public static HasPropertyCacheNode create(Object key, JSContext context, boolean hasOwnProperty) {
        return new HasPropertyCacheNode(key, context, hasOwnProperty);
    }

    public static HasPropertyCacheNode create(Object key, JSContext context) {
        return HasPropertyCacheNode.create(key, context, false);
    }

    protected HasPropertyCacheNode(Object key, JSContext context, boolean hasOwnProperty) {
        super(key, context);
        this.hasOwnProperty = hasOwnProperty;
    }

    @ExplodeLoop
    public boolean hasProperty(Object thisObj) {
        HasCacheNode c = (HasCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.hasProperty(thisObj, this);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.hasProperty(thisObj, this);
            }
            c = (HasCacheNode)c.next;
        }
        this.deoptimize();
        return this.hasPropertyAndSpecialize(thisObj);
    }

    @CompilerDirectives.TruffleBoundary
    private boolean hasPropertyAndSpecialize(Object thisObj) {
        HasCacheNode node = (HasCacheNode)((Object)this.specialize(thisObj));
        if (node.accepts(thisObj)) {
            return node.hasProperty(thisObj, this);
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError((Object)"Inconsistent guards.");
    }

    @Override
    protected HasCacheNode createCachedPropertyNode(Property property, Object thisObj, int depth, Object value, HasCacheNode currentHead) {
        PropertyCacheNode.ReceiverCheckNode check;
        assert (!this.isOwnProperty() || depth == 0);
        if (JSDynamicObject.isJSDynamicObject(thisObj)) {
            JSDynamicObject thisJSObj = (JSDynamicObject)((Object)thisObj);
            Shape cacheShape = thisJSObj.getShape();
            check = this.createShapeCheckNode(cacheShape, thisJSObj, depth, false, false);
        } else {
            check = this.createPrimitiveReceiverCheck(thisObj, depth);
        }
        return new PresentHasPropertyCacheNode(check);
    }

    @Override
    protected HasCacheNode createUndefinedPropertyNode(Object thisObj, Object store, int depth, Object value) {
        HasCacheNode specialized = this.createJavaPropertyNodeMaybe(thisObj, depth);
        if (specialized != null) {
            return specialized;
        }
        if (JSDynamicObject.isJSDynamicObject(thisObj)) {
            PropertyCacheNode.ReceiverCheckNode receiverCheck;
            JSDynamicObject thisJSObj = (JSDynamicObject)((Object)thisObj);
            Shape cacheShape = thisJSObj.getShape();
            PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(cacheShape, thisJSObj, depth, false, false);
            PropertyCacheNode.ReceiverCheckNode receiverCheckNode = receiverCheck = depth == 0 ? new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass(thisJSObj)) : shapeCheck;
            if (JSAdapter.isJSAdapter(store)) {
                return new JSAdapterHasPropertyCacheNode(this.key, receiverCheck);
            }
            if (JSProxy.isJSProxy(store)) {
                return new JSProxyDispatcherPropertyHasNode(this.context, this.key, receiverCheck, this.isOwnProperty());
            }
            if (JSModuleNamespace.isJSModuleNamespace(store)) {
                return new UnspecializedHasPropertyCacheNode(receiverCheck);
            }
            if (JSArrayBufferView.isJSArrayBufferView(store) && HasPropertyCacheNode.isNonIntegerIndex(this.key)) {
                return new ArrayBufferViewHasNonIntegerIndexNode(shapeCheck);
            }
            return new AbsentHasPropertyCacheNode(shapeCheck);
        }
        return new AbsentHasPropertyCacheNode(new PropertyCacheNode.InstanceofCheckNode(thisObj.getClass(), this.context));
    }

    @Override
    protected HasCacheNode createJavaPropertyNodeMaybe(Object thisObj, int depth) {
        if (JavaPackage.isJavaPackage(thisObj)) {
            return new PresentHasPropertyCacheNode(new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass((DynamicObject)thisObj)));
        }
        if (JavaImporter.isJavaImporter(thisObj)) {
            return new UnspecializedHasPropertyCacheNode(new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass((DynamicObject)thisObj)));
        }
        return null;
    }

    @Override
    protected HasCacheNode createGenericPropertyNode() {
        return new GenericHasPropertyCacheNode();
    }

    @Override
    protected boolean isPropertyAssumptionCheckEnabled() {
        return this.propertyAssumptionCheckEnabled && this.context.isSingleRealm();
    }

    @Override
    protected void setPropertyAssumptionCheckEnabled(boolean value) {
        this.propertyAssumptionCheckEnabled = value;
    }

    @Override
    protected boolean isGlobal() {
        return false;
    }

    @Override
    protected boolean isOwnProperty() {
        return this.hasOwnProperty;
    }

    @Override
    protected HasCacheNode createTruffleObjectPropertyNode() {
        return new ForeignHasPropertyCacheNode();
    }

    public static final class ForeignHasPropertyCacheNode
    extends LinkedHasPropertyCacheNode {
        @Node.Child
        private InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);

        public ForeignHasPropertyCacheNode() {
            super(new PropertyCacheNode.ForeignLanguageCheckNode());
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            assert (JSRuntime.isForeignObject(thisObj));
            Object key = root.getKey();
            if (key instanceof String) {
                return this.interop.isMemberExisting(thisObj, (String)key);
            }
            return false;
        }
    }

    @NodeInfo(cost=NodeCost.MEGAMORPHIC)
    public static final class GenericHasPropertyCacheNode
    extends HasCacheNode {
        @Node.Child
        private InteropLibrary interop;
        private final JSClassProfile jsclassProfile = JSClassProfile.create();

        public GenericHasPropertyCacheNode() {
            super(null);
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            if (JSDynamicObject.isJSDynamicObject(thisObj)) {
                Object key = root.getKey();
                if (root.isOwnProperty()) {
                    return JSObject.hasOwnProperty((DynamicObject)thisObj, key, this.jsclassProfile);
                }
                return JSObject.hasProperty((DynamicObject)thisObj, key, this.jsclassProfile);
            }
            assert (JSRuntime.isForeignObject(thisObj));
            Object key = root.getKey();
            if (key instanceof String) {
                return this.interop.isMemberExisting(thisObj, (String)key);
            }
            return false;
        }
    }

    public static final class UnspecializedHasPropertyCacheNode
    extends LinkedHasPropertyCacheNode {
        public UnspecializedHasPropertyCacheNode(PropertyCacheNode.ReceiverCheckNode receiverCheckNode) {
            super(receiverCheckNode);
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            Object key = root.getKey();
            if (root.isOwnProperty()) {
                return JSObject.hasOwnProperty((DynamicObject)thisObj, key);
            }
            return JSObject.hasProperty((DynamicObject)thisObj, key);
        }
    }

    public static final class JSProxyDispatcherPropertyHasNode
    extends LinkedHasPropertyCacheNode {
        private final boolean hasOwnProperty;
        @Node.Child
        private JSProxyHasPropertyNode proxyGet;
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode;

        public JSProxyDispatcherPropertyHasNode(JSContext context, Object key, PropertyCacheNode.ReceiverCheckNode receiverCheck, boolean hasOwnProperty) {
            super(receiverCheck);
            this.hasOwnProperty = hasOwnProperty;
            assert (JSRuntime.isPropertyKey(key));
            this.proxyGet = hasOwnProperty ? null : JSProxyHasPropertyNodeGen.create(context);
            this.getOwnPropertyNode = hasOwnProperty ? JSGetOwnPropertyNode.create() : null;
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            Object key = root.getKey();
            if (this.hasOwnProperty) {
                return this.getOwnPropertyNode.execute(this.receiverCheck.getStore(thisObj), key) != null;
            }
            return this.proxyGet.executeWithTargetAndKeyBoolean(this.receiverCheck.getStore(thisObj), key);
        }
    }

    public static final class JSAdapterHasPropertyCacheNode
    extends LinkedHasPropertyCacheNode {
        public JSAdapterHasPropertyCacheNode(Object key, PropertyCacheNode.ReceiverCheckNode receiverCheckNode) {
            super(receiverCheckNode);
            assert (JSRuntime.isPropertyKey(key));
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            return JSObject.hasOwnProperty((DynamicObject)thisObj, root.getKey());
        }
    }

    public static final class ArrayBufferViewHasNonIntegerIndexNode
    extends LinkedHasPropertyCacheNode {
        public ArrayBufferViewHasNonIntegerIndexNode(PropertyCacheNode.ReceiverCheckNode shapeCheckNode) {
            super(shapeCheckNode);
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            if (JSArrayBufferView.hasDetachedBuffer((DynamicObject)thisObj)) {
                throw Errors.createTypeErrorDetachedBuffer();
            }
            return false;
        }
    }

    public static final class AbsentHasPropertyCacheNode
    extends LinkedHasPropertyCacheNode {
        public AbsentHasPropertyCacheNode(PropertyCacheNode.ReceiverCheckNode shapeCheckNode) {
            super(shapeCheckNode);
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            return false;
        }
    }

    public static final class PresentHasPropertyCacheNode
    extends LinkedHasPropertyCacheNode {
        public PresentHasPropertyCacheNode(PropertyCacheNode.ReceiverCheckNode shapeCheck) {
            super(shapeCheck);
        }

        @Override
        protected boolean hasProperty(Object thisObj, HasPropertyCacheNode root) {
            return true;
        }
    }

    public static abstract class LinkedHasPropertyCacheNode
    extends HasCacheNode {
        protected LinkedHasPropertyCacheNode(PropertyCacheNode.ReceiverCheckNode receiverCheckNode) {
            super(receiverCheckNode);
        }
    }

    public static abstract class HasCacheNode
    extends PropertyCacheNode.CacheNode<HasCacheNode> {
        protected HasCacheNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        protected abstract boolean hasProperty(Object var1, HasPropertyCacheNode var2);
    }
}

