/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.AlwaysValidAssumption;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.JSProxyPropertySetNode;
import com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSGlobal;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.concurrent.locks.Lock;

public class PropertySetNode
extends PropertyCacheNode<SetCacheNode> {
    private final boolean isGlobal;
    private final boolean isStrict;
    private final boolean setOwnProperty;
    private final boolean declaration;
    private final boolean superProperty;
    private final byte attributeFlags;
    private boolean propertyAssumptionCheckEnabled;

    public static PropertySetNode create(Object key, boolean isGlobal, JSContext context, boolean isStrict) {
        boolean setOwnProperty = false;
        return PropertySetNode.createImpl(key, isGlobal, context, isStrict, false, JSAttributes.getDefault());
    }

    public static PropertySetNode createImpl(Object key, boolean isGlobal, JSContext context, boolean isStrict, boolean setOwnProperty, int attributeFlags) {
        return PropertySetNode.createImpl(key, isGlobal, context, isStrict, setOwnProperty, attributeFlags, false, false);
    }

    public static PropertySetNode createImpl(Object key, boolean isGlobal, JSContext context, boolean isStrict, boolean setOwnProperty, int attributeFlags, boolean declaration) {
        return PropertySetNode.createImpl(key, isGlobal, context, isStrict, setOwnProperty, attributeFlags, declaration, false);
    }

    public static PropertySetNode createImpl(Object key, boolean isGlobal, JSContext context, boolean isStrict, boolean setOwnProperty, int attributeFlags, boolean declaration, boolean superProperty) {
        return new PropertySetNode(key, context, isGlobal, isStrict, setOwnProperty, attributeFlags, declaration, superProperty);
    }

    public static PropertySetNode createSetHidden(HiddenKey key, JSContext context) {
        return PropertySetNode.createImpl(key, false, context, false, true, 0);
    }

    protected PropertySetNode(Object key, JSContext context, boolean isGlobal, boolean isStrict, boolean setOwnProperty, int attributeFlags, boolean declaration, boolean superProperty) {
        super(key, context);
        assert (!setOwnProperty ? attributeFlags == JSAttributes.getDefault() : attributeFlags == (attributeFlags & 0x27));
        this.isGlobal = isGlobal;
        this.isStrict = isStrict;
        this.setOwnProperty = setOwnProperty;
        this.attributeFlags = (byte)attributeFlags;
        this.declaration = declaration;
        this.superProperty = superProperty;
    }

    public final void setValue(Object obj, Object value) {
        this.setValue(obj, value, obj);
    }

    public final void setValueInt(Object obj, int value) {
        this.setValueInt(obj, value, obj);
    }

    public final void setValueDouble(Object obj, double value) {
        this.setValueDouble(obj, value, obj);
    }

    public final void setValueBoolean(Object obj, boolean value) {
        this.setValueBoolean(obj, value, obj);
    }

    @ExplodeLoop
    protected void setValue(Object thisObj, Object value, Object receiver) {
        SetCacheNode c = (SetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                c.setValue(thisObj, value, receiver, this, false);
                return;
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard && c.setValue(thisObj, value, receiver, this, guard)) {
                return;
            }
            c = (SetCacheNode)c.next;
        }
        this.deoptimize();
        this.setValueAndSpecialize(thisObj, value, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private boolean setValueAndSpecialize(Object thisObj, Object value, Object receiver) {
        return ((SetCacheNode)((Object)this.specialize(thisObj, value))).setValue(thisObj, value, receiver, this, false);
    }

    @ExplodeLoop
    protected void setValueInt(Object thisObj, int value, Object receiver) {
        SetCacheNode c = (SetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                c.setValueInt(thisObj, value, receiver, this, false);
                return;
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard && c.setValueInt(thisObj, value, receiver, this, guard)) {
                return;
            }
            c = (SetCacheNode)c.next;
        }
        this.deoptimize();
        this.setValueIntAndSpecialize(thisObj, value, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private void setValueIntAndSpecialize(Object thisObj, int value, Object receiver) {
        ((SetCacheNode)((Object)this.specialize(thisObj, value))).setValueInt(thisObj, value, receiver, this, false);
    }

    @ExplodeLoop
    protected void setValueDouble(Object thisObj, double value, Object receiver) {
        SetCacheNode c = (SetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                c.setValueDouble(thisObj, value, receiver, this, false);
                return;
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard && c.setValueDouble(thisObj, value, receiver, this, guard)) {
                return;
            }
            c = (SetCacheNode)c.next;
        }
        this.deoptimize();
        this.setValueDoubleAndSpecialize(thisObj, value, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private void setValueDoubleAndSpecialize(Object thisObj, double value, Object receiver) {
        ((SetCacheNode)((Object)this.specialize(thisObj, value))).setValueDouble(thisObj, value, receiver, this, false);
    }

    @ExplodeLoop
    protected void setValueBoolean(Object thisObj, boolean value, Object receiver) {
        SetCacheNode c = (SetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                c.setValueBoolean(thisObj, value, receiver, this, false);
                return;
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard && c.setValueBoolean(thisObj, value, receiver, this, guard)) {
                return;
            }
            c = (SetCacheNode)c.next;
        }
        this.deoptimize();
        this.setValueBooleanAndSpecialize(thisObj, value, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private void setValueBooleanAndSpecialize(Object thisObj, boolean value, Object receiver) {
        ((SetCacheNode)((Object)this.specialize(thisObj, value))).setValueBoolean(thisObj, value, receiver, this, false);
    }

    static DefinePropertyCache filterValid(DefinePropertyCache cache) {
        if (cache == null) {
            return null;
        }
        DefinePropertyCache filteredNext = PropertySetNode.filterValid(cache.next);
        if (cache.isValid()) {
            if (filteredNext == cache.next) {
                return cache;
            }
            return cache.withNext(filteredNext);
        }
        return filteredNext;
    }

    @Override
    protected SetCacheNode createCachedPropertyNode(Property property, Object thisObj, int depth, Object value, SetCacheNode currentHead) {
        if (JSDynamicObject.isJSDynamicObject(thisObj)) {
            return this.createCachedPropertyNodeJSObject(property, (JSDynamicObject)((Object)thisObj), depth, value);
        }
        return this.createCachedPropertyNodeNotJSObject(property, thisObj, depth);
    }

    private SetCacheNode createCachedPropertyNodeJSObject(Property property, JSDynamicObject thisObj, int depth, Object value) {
        Shape cacheShape = thisObj.getShape();
        PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(cacheShape, thisObj, depth, false, false);
        if (JSProperty.isData(property)) {
            return this.createCachedDataPropertyNodeJSObject(thisObj, depth, value, shapeCheck, property);
        }
        assert (JSProperty.isAccessor(property));
        return new AccessorPropertySetNode(property, shapeCheck, this.isStrict());
    }

    private SetCacheNode createCachedDataPropertyNodeJSObject(JSDynamicObject thisObj, int depth, Object value, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, Property property) {
        assert (!JSProperty.isConst(property) || depth == 0 && this.isGlobal() && property.getLocation().isValue() && property.getLocation().get(null) == Dead.instance()) : "const assignment";
        if (!JSProperty.isWritable(property)) {
            return new ReadOnlyPropertySetNode(shapeCheck, this.isStrict());
        }
        if (this.superProperty) {
            return this.createGenericPropertyNode();
        }
        if (depth > 0) {
            assert (JSProperty.isWritable(property));
            return this.createUndefinedPropertyNode((Object)thisObj, (Object)thisObj, depth, value);
        }
        if (JSProperty.isProxy(property)) {
            if (PropertySetNode.isArrayLengthProperty(property) && JSArray.isJSFastArray(thisObj)) {
                return new ArrayLengthPropertySetNode(property, shapeCheck, this.isStrict());
            }
            return new PropertyProxySetNode(property, shapeCheck, this.isStrict());
        }
        assert (JSProperty.isWritable(property) && depth == 0 && !JSProperty.isProxy(property));
        if (property.getLocation().isDeclared()) {
            return PropertySetNode.createRedefinePropertyNode(this.key, shapeCheck, shapeCheck.getShape(), property, value, this.context);
        }
        if (!property.getLocation().canSet(value)) {
            return this.createCachedDataPropertyGeneralize(thisObj, depth);
        }
        if (property.getLocation() instanceof IntLocation) {
            return new IntPropertySetNode(property, shapeCheck);
        }
        if (property.getLocation() instanceof DoubleLocation) {
            return new DoublePropertySetNode(property, shapeCheck);
        }
        if (property.getLocation() instanceof BooleanLocation) {
            return new BooleanPropertySetNode(property, shapeCheck);
        }
        return new ObjectPropertySetNode(property, shapeCheck);
    }

    private static SetCacheNode createDefinePropertyNode(Object key, PropertyCacheNode.ReceiverCheckNode shapeCheck, Object value, JSContext context, int attributeFlags, boolean declaration) {
        Shape oldShape = shapeCheck.getShape();
        Shape newShape = declaration ? JSObjectUtil.shapeDefineDeclaredDataProperty(context, oldShape, key, value, attributeFlags) : JSObjectUtil.shapeDefineDataProperty(context, oldShape, key, value, attributeFlags);
        return PropertySetNode.createResolvedDefinePropertyNode(key, shapeCheck, oldShape, newShape, attributeFlags);
    }

    private static SetCacheNode createRedefinePropertyNode(Object key, PropertyCacheNode.ReceiverCheckNode shapeCheck, Shape oldShape, Property property, Object value, JSContext context) {
        assert (JSProperty.isData(property) && JSProperty.isWritable(property));
        assert (property == oldShape.getProperty(key));
        Shape newShape = JSObjectUtil.shapeDefineDataProperty(context, oldShape, key, value, property.getFlags());
        return PropertySetNode.createResolvedDefinePropertyNode(key, shapeCheck, oldShape, newShape, property.getFlags());
    }

    private SetCacheNode createCachedDataPropertyGeneralize(JSDynamicObject thisObj, int depth) {
        Shape oldShape = thisObj.getShape();
        PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(oldShape, thisObj, depth, false, false);
        return new DataPropertySetNode(shapeCheck);
    }

    private SetCacheNode createCachedPropertyNodeNotJSObject(Property property, Object thisObj, int depth) {
        PropertyCacheNode.ReceiverCheckNode receiverCheck = this.createPrimitiveReceiverCheck(thisObj, depth);
        if (JSProperty.isData(property)) {
            return new ReadOnlyPropertySetNode(receiverCheck, this.isStrict());
        }
        assert (JSProperty.isAccessor(property));
        return new AccessorPropertySetNode(property, receiverCheck, this.isStrict());
    }

    private static SetCacheNode createResolvedDefinePropertyNode(Object key, PropertyCacheNode.ReceiverCheckNode receiverCheck, Shape oldShape, Shape newShape, int attributeFlags) {
        Property prop = newShape.getProperty(key);
        assert ((prop.getFlags() & 0x27) == attributeFlags);
        return new DataPropertySetNode(key, receiverCheck, oldShape, newShape, prop);
    }

    @Override
    protected SetCacheNode createUndefinedPropertyNode(Object thisObj, Object store, int depth, Object value) {
        SetCacheNode specialized = this.createJavaPropertyNodeMaybe(thisObj, depth);
        if (specialized != null) {
            return specialized;
        }
        if (JSDynamicObject.isJSDynamicObject(thisObj)) {
            JSDynamicObject thisJSObj = (JSDynamicObject)((Object)thisObj);
            Shape cacheShape = thisJSObj.getShape();
            PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(cacheShape, thisJSObj, depth, false, true);
            if (JSAdapter.isJSAdapter(store)) {
                PropertyCacheNode.ReceiverCheckNode receiverCheck = depth == 0 ? new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass(thisJSObj)) : shapeCheck;
                return new JSAdapterPropertySetNode(receiverCheck);
            }
            if (this.isStrict() && this.isGlobal() && !JSObject.hasProperty((DynamicObject)thisJSObj, this.key)) {
                return new ReferenceErrorPropertySetNode(shapeCheck);
            }
            if (JSProxy.isJSProxy(store) && JSRuntime.isPropertyKey(this.key)) {
                PropertyCacheNode.ReceiverCheckNode receiverCheck = depth == 0 ? new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass(thisJSObj)) : shapeCheck;
                return new JSProxyDispatcherPropertySetNode(this.context, receiverCheck, this.isStrict());
            }
            if (!JSRuntime.isObject((Object)thisJSObj)) {
                return new TypeErrorPropertySetNode(shapeCheck);
            }
            if (JSArrayBufferView.isJSArrayBufferView(store) && PropertySetNode.isNonIntegerIndex(this.key)) {
                return new ArrayBufferViewNonIntegerIndexSetNode(shapeCheck);
            }
            if (this.superProperty) {
                return this.createGenericPropertyNode();
            }
            if (JSShape.isExtensible(cacheShape) || this.key instanceof HiddenKey) {
                return PropertySetNode.createDefinePropertyNode(this.key, shapeCheck, value, this.context, this.getAttributeFlags(), this.isDeclaration());
            }
            return new ReadOnlyPropertySetNode(this.createShapeCheckNode(cacheShape, thisJSObj, depth, false, false), this.isStrict());
        }
        if (JSProxy.isJSProxy(store)) {
            PropertyCacheNode.ReceiverCheckNode receiverCheck = this.createPrimitiveReceiverCheck(thisObj, depth);
            return new JSProxyDispatcherPropertySetNode(this.context, receiverCheck, this.isStrict());
        }
        boolean doThrow = this.isStrict();
        if (!JSRuntime.isJSNative(thisObj)) {
            doThrow = false;
        }
        return new ReadOnlyPropertySetNode(new PropertyCacheNode.InstanceofCheckNode(thisObj.getClass(), this.context), doThrow);
    }

    @Override
    protected SetCacheNode createJavaPropertyNodeMaybe(Object thisObj, int depth) {
        return null;
    }

    @Override
    protected SetCacheNode createGenericPropertyNode() {
        return new GenericPropertySetNode(this.context);
    }

    @Override
    protected boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    protected boolean isOwnProperty() {
        return this.setOwnProperty;
    }

    protected final boolean isStrict() {
        return this.isStrict;
    }

    protected final int getAttributeFlags() {
        return this.attributeFlags;
    }

    protected final boolean isDeclaration() {
        return this.declaration;
    }

    @Override
    protected SetCacheNode createTruffleObjectPropertyNode() {
        return new ForeignPropertySetNode(this.context);
    }

    @CompilerDirectives.TruffleBoundary
    protected void globalPropertySetInStrictMode(Object thisObj) {
        assert (JSDynamicObject.isJSDynamicObject(thisObj) && this.context.getRealm().getGlobalObject() == thisObj);
        throw Errors.createReferenceErrorNotDefined(this.context, this.getKey(), this);
    }

    @Override
    protected boolean isPropertyAssumptionCheckEnabled() {
        return this.propertyAssumptionCheckEnabled && this.context.isSingleRealm();
    }

    @Override
    protected void setPropertyAssumptionCheckEnabled(boolean value) {
        this.propertyAssumptionCheckEnabled = value;
    }

    public static final class ArrayLengthPropertySetNode
    extends LinkedPropertySetNode {
        @Node.Child
        private ArrayLengthNode.ArrayLengthWriteNode arrayLengthWrite;
        private final Property property;
        private final boolean isStrict;
        private final BranchProfile errorBranch = BranchProfile.create();

        public ArrayLengthPropertySetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, boolean isStrict) {
            super(shapeCheck);
            assert (JSProperty.isData(property) && JSProperty.isWritable(property) && PropertyCacheNode.isArrayLengthProperty(property));
            this.property = property;
            this.isStrict = isStrict;
            this.arrayLengthWrite = ArrayLengthNode.ArrayLengthWriteNode.create(isStrict);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            boolean ret = ((PropertyProxy)this.property.get(store, guard)).set(store, value);
            if (!ret && this.isStrict) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotWritableProperty(this.property.getKey(), thisObj);
            }
            return true;
        }

        @Override
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            assert (JSArray.isJSFastArray(store));
            if (value < 0) {
                this.errorBranch.enter();
                throw Errors.createRangeErrorInvalidArrayLength();
            }
            this.arrayLengthWrite.executeVoid(store, value);
            return true;
        }
    }

    public static final class ArrayBufferViewNonIntegerIndexSetNode
    extends LinkedPropertySetNode {
        public ArrayBufferViewNonIntegerIndexSetNode(PropertyCacheNode.AbstractShapeCheckNode shapeCheck) {
            super(shapeCheck);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            if (JSArrayBufferView.hasDetachedBuffer((DynamicObject)thisObj)) {
                throw Errors.createTypeErrorDetachedBuffer();
            }
            return false;
        }
    }

    public static final class ForeignPropertySetNode
    extends LinkedPropertySetNode {
        @Node.Child
        private ExportValueNode export;
        @CompilerDirectives.CompilationFinal
        private boolean optimistic = true;
        private final JSContext context;
        @Node.Child
        private InteropLibrary interop;
        @Node.Child
        private InteropLibrary setterInterop;

        public ForeignPropertySetNode(JSContext context) {
            super(new PropertyCacheNode.ForeignLanguageCheckNode());
            this.context = context;
            this.export = ExportValueNode.create();
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        private Object nullCheck(Object truffleObject, Object key) {
            if (this.interop.isNull(truffleObject)) {
                throw Errors.createTypeErrorCannotSetProperty(key, truffleObject, this, this.context);
            }
            return truffleObject;
        }

        @Override
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            Object key = root.getKey();
            Object truffleObject = this.nullCheck(thisObj, key);
            if (!(key instanceof String)) {
                return false;
            }
            return this.performWriteMember(truffleObject, value, root);
        }

        @Override
        protected boolean setValueDouble(Object thisObj, double value, Object receiver, PropertySetNode root, boolean guard) {
            Object key = root.getKey();
            Object truffleObject = this.nullCheck(thisObj, key);
            if (!(key instanceof String)) {
                return false;
            }
            return this.performWriteMember(truffleObject, value, root);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            Object key = root.getKey();
            Object truffleObject = this.nullCheck(thisObj, key);
            if (!(key instanceof String)) {
                return false;
            }
            Object exportedValue = this.export.execute(value);
            return this.performWriteMember(truffleObject, exportedValue, root);
        }

        private boolean performWriteMember(Object truffleObject, Object value, PropertySetNode root) {
            String stringKey = (String)root.getKey();
            if (this.context.isOptionNashornCompatibilityMode() && this.tryInvokeSetter(truffleObject, value, root)) {
                return true;
            }
            if (this.optimistic) {
                try {
                    this.interop.writeMember(truffleObject, stringKey, value);
                }
                catch (UnknownIdentifierException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.optimistic = false;
                }
                catch (UnsupportedMessageException | UnsupportedTypeException e) {
                    throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeMember", stringKey, this);
                }
            } else if (this.interop.isMemberWritable(truffleObject, stringKey)) {
                try {
                    this.interop.writeMember(truffleObject, stringKey, value);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeMember", stringKey, this);
                }
            }
            return true;
        }

        private boolean tryInvokeSetter(Object thisObj, Object value, PropertySetNode root) {
            assert (this.context.isOptionNashornCompatibilityMode());
            TruffleLanguage.Env env = this.context.getRealm().getEnv();
            if (env.isHostObject(thisObj)) {
                String setterKey = root.getAccessorKey("set");
                if (setterKey == null) {
                    return false;
                }
                if (this.setterInterop == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setterInterop = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
                }
                if (!this.setterInterop.isMemberInvocable(thisObj, setterKey)) {
                    return false;
                }
                try {
                    this.setterInterop.invokeMember(thisObj, setterKey, new Object[]{value});
                    return true;
                }
                catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException throwable) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @NodeInfo(cost=NodeCost.MEGAMORPHIC)
    public static final class GenericPropertySetNode
    extends SetCacheNode {
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private ForeignPropertySetNode foreignSetNode;
        private final JSClassProfile jsclassProfile = JSClassProfile.create();
        private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isStrictSymbol = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isForeignObject = ConditionProfile.createBinaryProfile();

        public GenericPropertySetNode(JSContext context) {
            super(null);
            this.toObjectNode = JSToObjectNode.createToObjectNoCheck(context);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            if (this.isObject.profile(JSDynamicObject.isJSDynamicObject(thisObj))) {
                this.setValueInDynamicObject(thisObj, value, receiver, root);
            } else {
                if (this.isStrictSymbol.profile(root.isStrict() && thisObj instanceof Symbol)) {
                    throw Errors.createTypeError("Cannot create property on symbol", this);
                }
                if (this.isForeignObject.profile(JSGuards.isForeignObject(thisObj))) {
                    if (this.foreignSetNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.foreignSetNode = (ForeignPropertySetNode)this.insert(new ForeignPropertySetNode(root.getContext()));
                    }
                    this.foreignSetNode.setValue(thisObj, value, receiver, root, guard);
                } else {
                    this.setValueInDynamicObject(this.toObjectNode.execute(thisObj), value, receiver, root);
                }
            }
            return true;
        }

        private void setValueInDynamicObject(Object thisObj, Object value, Object receiver, PropertySetNode root) {
            JSDynamicObject thisJSObj = (JSDynamicObject)((Object)thisObj);
            Object key = root.getKey();
            if (key instanceof HiddenKey) {
                JSObjectUtil.putHiddenProperty(thisJSObj, key, value);
            } else if (root.isGlobal() && root.isStrict() && !JSObject.hasProperty((DynamicObject)thisJSObj, key, this.jsclassProfile)) {
                root.globalPropertySetInStrictMode(thisObj);
            } else if (root.isOwnProperty()) {
                if (root.isDeclaration()) {
                    assert (JSGlobal.isJSGlobalObject(thisJSObj) && !JSObject.hasProperty((DynamicObject)thisJSObj, key));
                    JSObjectUtil.putDeclaredDataProperty(root.getContext(), thisJSObj, key, value, root.getAttributeFlags());
                } else {
                    JSObject.defineOwnProperty(thisJSObj, key, PropertyDescriptor.createData(value, root.getAttributeFlags()), root.isStrict());
                }
            } else {
                JSObject.setWithReceiver((DynamicObject)thisJSObj, key, value, receiver, root.isStrict(), this.jsclassProfile, (Node)root);
            }
        }

        @Override
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            return this.setValue(thisObj, value, receiver, root, guard);
        }

        @Override
        protected boolean setValueDouble(Object thisObj, double value, Object receiver, PropertySetNode root, boolean guard) {
            return this.setValue(thisObj, value, receiver, root, guard);
        }

        @Override
        protected boolean setValueBoolean(Object thisObj, boolean value, Object receiver, PropertySetNode root, boolean guard) {
            return this.setValue(thisObj, value, receiver, root, guard);
        }
    }

    public static final class JSProxyDispatcherPropertySetNode
    extends LinkedPropertySetNode {
        @Node.Child
        private JSProxyPropertySetNode proxySet;

        public JSProxyDispatcherPropertySetNode(JSContext context, PropertyCacheNode.ReceiverCheckNode receiverCheckNode, boolean isStrict) {
            super(receiverCheckNode);
            this.proxySet = JSProxyPropertySetNode.create(context, isStrict);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            this.proxySet.executeWithReceiverAndValue(this.receiverCheck.getStore(thisObj), receiver, value, root.getKey());
            return true;
        }

        @Override
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            this.proxySet.executeWithReceiverAndValueInt(this.receiverCheck.getStore(thisObj), receiver, value, root.getKey());
            return true;
        }
    }

    public static final class JSAdapterPropertySetNode
    extends LinkedPropertySetNode {
        public JSAdapterPropertySetNode(PropertyCacheNode.ReceiverCheckNode receiverCheckNode) {
            super(receiverCheckNode);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            JSObject.set((DynamicObject)thisObj, root.getKey(), value, root.isStrict(), (Node)root);
            return true;
        }
    }

    public static final class ReferenceErrorPropertySetNode
    extends LinkedPropertySetNode {
        public ReferenceErrorPropertySetNode(PropertyCacheNode.AbstractShapeCheckNode shapeCheckNode) {
            super(shapeCheckNode);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            root.globalPropertySetInStrictMode(thisObj);
            return true;
        }
    }

    public static final class TypeErrorPropertySetNode
    extends LinkedPropertySetNode {
        public TypeErrorPropertySetNode(PropertyCacheNode.AbstractShapeCheckNode shapeCheckNode) {
            super(shapeCheckNode);
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            assert (thisObj == Undefined.instance || thisObj == Null.instance);
            throw Errors.createTypeErrorCannotSetProperty(root.getKey(), thisObj, this, root.getContext());
        }
    }

    public static final class ReadOnlyPropertySetNode
    extends LinkedPropertySetNode {
        private final boolean isStrict;

        public ReadOnlyPropertySetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck, boolean isStrict) {
            super(receiverCheck);
            this.isStrict = isStrict;
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            if (this.isStrict) {
                throw Errors.createTypeErrorNotWritableProperty(root.getKey(), thisObj, this);
            }
            return true;
        }
    }

    public static class DataPropertySetNode
    extends LinkedPropertySetNode {
        @CompilerDirectives.CompilationFinal
        protected DefinePropertyCache cache;

        public DataPropertySetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        public DataPropertySetNode(Object key, PropertyCacheNode.ReceiverCheckNode receiverCheck, Shape oldShape, Shape newShape, Property property) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            assert (property.getKey().equals(key)) : "property=" + property + " key=" + key;
            assert (property == newShape.getProperty(key));
            this.cache = new DefinePropertyCache(oldShape, newShape, property, DataPropertySetNode.getShapeValidAssumption(oldShape, newShape), null);
        }

        protected JSDynamicObject getStore(Object thisObj) {
            return (JSDynamicObject)((Object)thisObj);
        }

        @Override
        @ExplodeLoop
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            JSDynamicObject store = this.getStore(thisObj);
            DefinePropertyCache resolved = this.cache;
            while (resolved != null) {
                if (resolved.oldShape.check((DynamicObject)store)) {
                    if (!resolved.isValid()) break;
                    if (DataPropertySetNode.setCachedObject(store, value, resolved)) {
                        return true;
                    }
                }
                resolved = resolved.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.setValueAndSpecialize(store, value, root);
        }

        @Override
        @ExplodeLoop
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            JSDynamicObject store = this.getStore(thisObj);
            DefinePropertyCache resolved = this.cache;
            while (resolved != null) {
                if (resolved.oldShape.check((DynamicObject)store)) {
                    if (!resolved.isValid()) break;
                    if (DataPropertySetNode.setCachedInt(store, value, resolved)) {
                        return true;
                    }
                    if (DataPropertySetNode.setCachedDouble(store, value, resolved)) {
                        return true;
                    }
                    if (DataPropertySetNode.setCachedObject(store, value, resolved)) {
                        return true;
                    }
                }
                resolved = resolved.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.setValueAndSpecialize(store, value, root);
        }

        @Override
        @ExplodeLoop
        protected boolean setValueDouble(Object thisObj, double value, Object receiver, PropertySetNode root, boolean guard) {
            JSDynamicObject store = this.getStore(thisObj);
            DefinePropertyCache resolved = this.cache;
            while (resolved != null) {
                if (resolved.oldShape.check((DynamicObject)store)) {
                    if (!resolved.isValid()) break;
                    if (DataPropertySetNode.setCachedDouble(store, value, resolved)) {
                        return true;
                    }
                    if (DataPropertySetNode.setCachedObject(store, value, resolved)) {
                        return true;
                    }
                }
                resolved = resolved.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.setValueAndSpecialize(store, value, root);
        }

        @Override
        @ExplodeLoop
        protected boolean setValueBoolean(Object thisObj, boolean value, Object receiver, PropertySetNode root, boolean guard) {
            JSDynamicObject store = this.getStore(thisObj);
            DefinePropertyCache resolved = this.cache;
            while (resolved != null) {
                if (resolved.oldShape.check((DynamicObject)store)) {
                    if (!resolved.isValid()) break;
                    if (DataPropertySetNode.setCachedBoolean(store, value, resolved)) {
                        return true;
                    }
                    if (DataPropertySetNode.setCachedObject(store, value, resolved)) {
                        return true;
                    }
                }
                resolved = resolved.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.setValueAndSpecialize(store, value, root);
        }

        private static boolean setCachedObject(DynamicObject store, Object value, DefinePropertyCache resolved) {
            if (resolved.oldShape != resolved.newShape) {
                if (resolved.property.getLocation().canStore(value)) {
                    resolved.property.setSafe(store, value, resolved.oldShape, resolved.newShape);
                    resolved.maybeUpdateShape(store);
                    return true;
                }
            } else if (resolved.property.getLocation().canSet(value)) {
                resolved.property.setSafe(store, value, resolved.oldShape);
                return true;
            }
            return false;
        }

        private static boolean setCachedInt(DynamicObject store, int value, DefinePropertyCache resolved) {
            if (resolved.property.getLocation() instanceof IntLocation) {
                IntLocation intLocation = (IntLocation)resolved.property.getLocation();
                if (resolved.oldShape != resolved.newShape) {
                    intLocation.setInt(store, value, resolved.oldShape, resolved.newShape);
                    resolved.maybeUpdateShape(store);
                    return true;
                }
                if (!resolved.property.getLocation().isFinal()) {
                    try {
                        intLocation.setInt(store, value, resolved.oldShape);
                    }
                    catch (FinalLocationException e) {
                        throw Errors.shouldNotReachHere();
                    }
                    return true;
                }
            }
            return false;
        }

        private static boolean setCachedDouble(DynamicObject store, double value, DefinePropertyCache resolved) {
            if (resolved.property.getLocation() instanceof DoubleLocation) {
                DoubleLocation doubleLocation = (DoubleLocation)resolved.property.getLocation();
                if (resolved.oldShape != resolved.newShape) {
                    doubleLocation.setDouble(store, value, resolved.oldShape, resolved.newShape);
                    resolved.maybeUpdateShape(store);
                    return true;
                }
                if (!resolved.property.getLocation().isFinal()) {
                    try {
                        doubleLocation.setDouble(store, value, resolved.oldShape);
                    }
                    catch (FinalLocationException e) {
                        throw Errors.shouldNotReachHere();
                    }
                    return true;
                }
            }
            return false;
        }

        private static boolean setCachedBoolean(DynamicObject store, boolean value, DefinePropertyCache resolved) {
            if (resolved.property.getLocation() instanceof BooleanLocation) {
                BooleanLocation booleanLocation = (BooleanLocation)resolved.property.getLocation();
                if (resolved.oldShape != resolved.newShape) {
                    booleanLocation.setBoolean(store, value, resolved.oldShape, resolved.newShape);
                    resolved.maybeUpdateShape(store);
                    return true;
                }
                if (!resolved.property.getLocation().isFinal()) {
                    try {
                        booleanLocation.setBoolean(store, value, resolved.oldShape);
                    }
                    catch (FinalLocationException e) {
                        throw Errors.shouldNotReachHere();
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setValueAndSpecialize(DynamicObject obj, Object value, PropertySetNode root) {
            DefinePropertyCache res;
            CompilerAsserts.neverPartOfCompilation();
            Object key = root.getKey();
            Lock lock = root.getLock();
            lock.lock();
            try {
                DefinePropertyCache currentHead = this.cache;
                do {
                    Property newProperty;
                    Shape newShape;
                    assert (currentHead == this.cache);
                    int cachedCount = 0;
                    boolean invalid = false;
                    res = null;
                    DefinePropertyCache c = currentHead;
                    while (c != null) {
                        ++cachedCount;
                        if (!c.isValid()) {
                            invalid = true;
                            break;
                        }
                        if (res == null && c.acceptsValue(value)) {
                            res = c;
                        }
                        c = c.next;
                    }
                    if (invalid) {
                        assert (cachedCount > 0);
                        this.cache = currentHead = PropertySetNode.filterValid(currentHead);
                        res = null;
                        continue;
                    }
                    if (res != null) continue;
                    Shape oldShape = obj.getShape();
                    Property property = oldShape.getProperty(key);
                    if (property == null) {
                        JSObjectUtil.putDataProperty(root.getContext(), obj, key, value, root.getAttributeFlags());
                        newShape = obj.getShape();
                        newProperty = newShape.getLastProperty();
                        assert (key.equals(newProperty.getKey()));
                    } else {
                        if (JSProperty.isData(property) && !JSProperty.isProxy(property)) {
                            assert (JSProperty.isWritable(property));
                            property.setGeneric(obj, value, null);
                        } else {
                            JSObjectUtil.defineDataProperty(obj, key, value, property.getFlags());
                        }
                        newShape = obj.getShape();
                        newProperty = newShape.getProperty(key);
                    }
                    if (!oldShape.isValid()) {
                        this.cache = null;
                        boolean bl = true;
                        return bl;
                    }
                    Assumption newShapeValidAssumption = DataPropertySetNode.getShapeValidAssumption(oldShape, newShape);
                    this.cache = new DefinePropertyCache(oldShape, newShape, newProperty, newShapeValidAssumption, currentHead);
                    boolean bl = true;
                    return bl;
                } while (res == null);
            }
            finally {
                lock.unlock();
            }
            assert (res.acceptsValue(value));
            res.property.setSafe(obj, value, res.oldShape, res.newShape);
            return true;
        }

        private static Assumption getShapeValidAssumption(Shape oldShape, Shape newShape) {
            if (oldShape == newShape) {
                return AlwaysValidAssumption.INSTANCE;
            }
            return newShape.isValid() ? newShape.getValidAssumption() : NeverValidAssumption.INSTANCE;
        }

        @Override
        protected boolean sweep() {
            DefinePropertyCache before = this.cache;
            DefinePropertyCache after = PropertySetNode.filterValid(before);
            if (before == after) {
                return false;
            }
            this.cache = after;
            return true;
        }
    }

    static final class DefinePropertyCache {
        protected final Shape oldShape;
        protected final Shape newShape;
        protected final Property property;
        protected final Assumption newShapeValidAssumption;
        protected final DefinePropertyCache next;
        protected static final DefinePropertyCache GENERIC = new DefinePropertyCache(null, null, null, null, null);

        protected DefinePropertyCache(Shape oldShape, Shape newShape, Property property, Assumption newShapeValidAssumption, DefinePropertyCache next) {
            this.oldShape = oldShape;
            this.newShape = newShape;
            this.property = property;
            this.newShapeValidAssumption = newShapeValidAssumption;
            this.next = next;
        }

        protected boolean isValid() {
            return this.newShapeValidAssumption == NeverValidAssumption.INSTANCE || this.newShapeValidAssumption.isValid();
        }

        protected void maybeUpdateShape(DynamicObject store) {
            if (this.newShapeValidAssumption == NeverValidAssumption.INSTANCE) {
                DefinePropertyCache.updateShape(store);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void updateShape(DynamicObject store) {
            DynamicObjectLibrary.getUncached().updateShape(store);
        }

        protected boolean acceptsValue(Object value) {
            if (this.oldShape != this.newShape) {
                return this.property.getLocation().canStore(value);
            }
            return this.property.getLocation().canSet(value);
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            StringBuilder sb = new StringBuilder();
            int count = 0;
            sb.append('[');
            DefinePropertyCache current = this;
            while (current != null) {
                sb.append(++count);
                sb.append(": {property=").append(current.property);
                if (current.oldShape != current.newShape) {
                    sb.append(", oldShape=").append(current.oldShape).append(", newShape=").append(current.newShape);
                } else {
                    sb.append(", shape=").append(current.oldShape);
                }
                sb.append("}");
                if (current.next != null) {
                    sb.append(", ");
                }
                current = current.next;
            }
            sb.append(']');
            return sb.toString();
        }

        protected DefinePropertyCache withNext(DefinePropertyCache newNext) {
            return new DefinePropertyCache(this.oldShape, this.newShape, this.property, this.newShapeValidAssumption, newNext);
        }
    }

    public static final class AccessorPropertySetNode
    extends LinkedPropertySetNode {
        private final Property property;
        private final boolean isStrict;
        @Node.Child
        private JSFunctionCallNode callNode;
        private final BranchProfile undefinedSetterBranch = BranchProfile.create();

        public AccessorPropertySetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck, boolean isStrict) {
            super(receiverCheck);
            assert (JSProperty.isAccessor(property));
            this.property = property;
            this.isStrict = isStrict;
            this.callNode = JSFunctionCallNode.createCall();
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            Accessor accessor = (Accessor)this.property.get(store, guard);
            DynamicObject setter = accessor.getSetter();
            if (setter != Undefined.instance) {
                this.callNode.executeCall(JSArguments.createOneArg(receiver, setter, value));
            } else {
                this.undefinedSetterBranch.enter();
                if (this.isStrict) {
                    throw Errors.createTypeErrorCannotSetAccessorProperty(root.getKey(), store);
                }
            }
            return true;
        }
    }

    public static final class BooleanPropertySetNode
    extends LinkedPropertySetNode {
        private final Property property;
        private final BooleanLocation location;

        public BooleanPropertySetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck) {
            super(shapeCheck);
            this.property = property;
            this.location = (BooleanLocation)property.getLocation();
            assert (JSProperty.isData(property));
            assert (JSProperty.isWritable(property));
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            if (value instanceof Boolean) {
                DynamicObject store = this.receiverCheck.getStore(thisObj);
                try {
                    this.property.set(store, value, this.receiverCheck.getShape());
                }
                catch (FinalLocationException | IncompatibleLocationException e) {
                    throw Errors.shouldNotReachHere(e);
                }
                return true;
            }
            return false;
        }

        @Override
        protected boolean setValueBoolean(Object thisObj, boolean value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            try {
                this.location.setBoolean(store, value, this.receiverCheck.getShape());
                return true;
            }
            catch (FinalLocationException e) {
                throw Errors.shouldNotReachHere(e);
            }
        }

        @Override
        protected boolean acceptsValue(Object value) {
            return value instanceof Boolean;
        }
    }

    public static final class DoublePropertySetNode
    extends LinkedPropertySetNode {
        private final DoubleLocation location;
        @CompilerDirectives.CompilationFinal
        int valueProfile;
        private static final int INT = 1;
        private static final int DOUBLE = 2;
        private static final int OTHER = 4;

        public DoublePropertySetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck) {
            super(shapeCheck);
            this.location = (DoubleLocation)property.getLocation();
            assert (JSProperty.isData(property) && JSProperty.isWritable(property) && !property.getLocation().isFinal());
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            double doubleValue;
            int p = this.valueProfile;
            if ((p & 2) != 0 && value instanceof Double) {
                doubleValue = (Double)value;
            } else if ((p & 1) != 0 && value instanceof Integer) {
                doubleValue = ((Integer)value).intValue();
            } else {
                if ((p & 4) != 0 && !(value instanceof Double) && !(value instanceof Integer)) {
                    return false;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                p = value instanceof Double ? (p |= 2) : (value instanceof Integer ? (p |= 1) : (p |= 4));
                this.valueProfile = p;
                return this.setValue(thisObj, value, receiver, root, guard);
            }
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            try {
                this.location.setDouble(store, doubleValue, this.receiverCheck.getShape());
                return true;
            }
            catch (FinalLocationException e) {
                throw Errors.shouldNotReachHere(e);
            }
        }

        @Override
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            try {
                this.location.setDouble(store, (double)value, this.receiverCheck.getShape());
                return true;
            }
            catch (FinalLocationException e) {
                throw Errors.shouldNotReachHere(e);
            }
        }

        @Override
        protected boolean setValueDouble(Object thisObj, double value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            try {
                this.location.setDouble(store, value, this.receiverCheck.getShape());
                return true;
            }
            catch (FinalLocationException e) {
                throw Errors.shouldNotReachHere(e);
            }
        }

        @Override
        protected boolean acceptsValue(Object value) {
            return value instanceof Double || value instanceof Integer;
        }
    }

    public static final class IntPropertySetNode
    extends LinkedPropertySetNode {
        private final Property property;
        private final IntLocation location;

        public IntPropertySetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck) {
            super(shapeCheck);
            this.property = property;
            this.location = (IntLocation)property.getLocation();
            assert (JSProperty.isData(property) && JSProperty.isWritable(property) && !property.getLocation().isFinal());
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            if (value instanceof Integer) {
                DynamicObject store = this.receiverCheck.getStore(thisObj);
                try {
                    this.property.set(store, value, this.receiverCheck.getShape());
                }
                catch (FinalLocationException | IncompatibleLocationException e) {
                    throw Errors.shouldNotReachHere(e);
                }
                return true;
            }
            return false;
        }

        @Override
        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            try {
                this.location.setInt(store, value, this.receiverCheck.getShape());
                return true;
            }
            catch (FinalLocationException e) {
                throw Errors.shouldNotReachHere(e);
            }
        }

        @Override
        protected boolean acceptsValue(Object value) {
            return value instanceof Integer;
        }
    }

    public static final class PropertyProxySetNode
    extends LinkedPropertySetNode {
        private final Property property;
        private final boolean isStrict;
        private final BranchProfile errorBranch = BranchProfile.create();

        public PropertyProxySetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, boolean isStrict) {
            super(shapeCheck);
            this.property = property;
            this.isStrict = isStrict;
            assert (JSProperty.isData(property) && JSProperty.isWritable(property) && JSProperty.isProxy(property) && !property.getLocation().isFinal());
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            boolean ret = ((PropertyProxy)this.property.get(store, guard)).set(store, value);
            if (!ret && this.isStrict) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorNotWritableProperty(this.property.getKey(), thisObj);
            }
            return true;
        }
    }

    public static final class ObjectPropertySetNode
    extends LinkedPropertySetNode {
        private final Property property;

        public ObjectPropertySetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck) {
            super(shapeCheck);
            this.property = property;
            assert (JSProperty.isData(property) && JSProperty.isWritable(property) && !JSProperty.isProxy(property) && !property.getLocation().isFinal());
        }

        @Override
        protected boolean setValue(Object thisObj, Object value, Object receiver, PropertySetNode root, boolean guard) {
            if (this.property.getLocation().canSet(value)) {
                DynamicObject store = this.receiverCheck.getStore(thisObj);
                try {
                    this.property.set(store, value, this.receiverCheck.getShape());
                }
                catch (FinalLocationException | IncompatibleLocationException e) {
                    throw Errors.shouldNotReachHere(e);
                }
                return true;
            }
            return false;
        }

        @Override
        protected boolean acceptsValue(Object value) {
            return this.property.getLocation().canSet(value);
        }
    }

    public static abstract class LinkedPropertySetNode
    extends SetCacheNode {
        protected LinkedPropertySetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }
    }

    public static abstract class SetCacheNode
    extends PropertyCacheNode.CacheNode<SetCacheNode> {
        protected SetCacheNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        protected abstract boolean setValue(Object var1, Object var2, Object var3, PropertySetNode var4, boolean var5);

        protected boolean setValueInt(Object thisObj, int value, Object receiver, PropertySetNode root, boolean guard) {
            return this.setValue(thisObj, value, receiver, root, guard);
        }

        protected boolean setValueDouble(Object thisObj, double value, Object receiver, PropertySetNode root, boolean guard) {
            return this.setValue(thisObj, value, receiver, root, guard);
        }

        protected boolean setValueBoolean(Object thisObj, boolean value, Object receiver, PropertySetNode root, boolean guard) {
            return this.setValue(thisObj, value, receiver, root, guard);
        }

        @Override
        protected boolean acceptsValue(Object value) {
            return true;
        }
    }
}

