/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.catalog.internal.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;

public class TypeLoaderRegistry {
    private final Map<TypeLoaderRegistryKey, TypeLoaderFactory> typeLoaderFactoryMap = new HashMap<TypeLoaderRegistryKey, TypeLoaderFactory>();

    public TypeLoaderRegistry(List<TypeLoaderFactory> factories) {
        factories.stream().forEach(this::register);
    }

    private void register(TypeLoaderFactory typeLoaderFactory) {
        this.typeLoaderFactoryMap.put(new TypeLoaderRegistryKey(typeLoaderFactory.getTypeFormat(), typeLoaderFactory.getLoaderFormat()), typeLoaderFactory);
    }

    public Optional<TypeLoaderFactory> getFactory(String typeFormat, String shapeFormat) {
        return Optional.ofNullable(this.typeLoaderFactoryMap.get(new TypeLoaderRegistryKey(typeFormat, shapeFormat)));
    }

    private static class TypeLoaderRegistryKey {
        private final String typeFormat;
        private final String loaderFormat;

        TypeLoaderRegistryKey(String typeFormat, String loaderFormat) {
            MetadataTypeUtils.checkArgument((boolean)MetadataTypeUtils.isNotNull((Object)typeFormat), (String)"typeFormat cannot be null.");
            MetadataTypeUtils.checkArgument((boolean)MetadataTypeUtils.isNotNull((Object)loaderFormat), (String)"loaderFormat cannot be null.");
            this.typeFormat = typeFormat;
            this.loaderFormat = loaderFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeLoaderRegistryKey that = (TypeLoaderRegistryKey)o;
            return this.typeFormat.equals(that.typeFormat) && this.loaderFormat.equals(that.loaderFormat);
        }

        public int hashCode() {
            int result = this.typeFormat.hashCode();
            result = 31 * result + this.loaderFormat.hashCode();
            return result;
        }
    }
}

