/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;

public class DefaultErrorTypeRepository
implements ErrorTypeRepository {
    private final Map<ComponentIdentifier, ErrorType> errorTypes = new HashMap<ComponentIdentifier, ErrorType>();
    private final Map<ComponentIdentifier, ErrorType> internalErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.errorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.internalErrorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    private ErrorType buildErrorType(ComponentIdentifier identifier, ErrorType parent) {
        if (this.errorTypes.containsKey(identifier) || this.internalErrorTypes.containsKey(identifier)) {
            throw new IllegalStateException(String.format("An error type with identifier '%s' already exists", identifier));
        }
        return ErrorTypeBuilder.builder().namespace(identifier.getNamespace()).identifier(identifier.getName()).parentErrorType(parent).build();
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.errorTypes.get(errorTypeComponentIdentifier));
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.lookupErrorType(errorTypeIdentifier);
        if (!errorType.isPresent()) {
            errorType = Optional.ofNullable(this.internalErrorTypes.get(errorTypeIdentifier));
        }
        return errorType;
    }

    public Collection<String> getErrorNamespaces() {
        return Stream.concat(this.errorTypes.keySet().stream(), this.internalErrorTypes.keySet().stream()).map(id -> id.getNamespace().toUpperCase()).collect(Collectors.toSet());
    }

    public ErrorType getAnyErrorType() {
        return null;
    }

    public ErrorType getSourceErrorType() {
        return null;
    }

    public ErrorType getSourceResponseErrorType() {
        return null;
    }

    public ErrorType getCriticalErrorType() {
        return null;
    }

    public Set<ErrorType> getErrorTypes() {
        return new HashSet<ErrorType>(this.errorTypes.values());
    }

    public Set<ErrorType> getInternalErrorTypes() {
        return new HashSet<ErrorType>(this.internalErrorTypes.values());
    }
}

