/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapService;
import org.mule.runtime.core.api.config.builders.RegistryBootstrap;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.internal.config.bootstrap.AbstractBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.ObjectBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransactionFactoryBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransformerBootstrapProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistryBootstrap
implements RegistryBootstrap {
    private static final String TRANSACTION_RESOURCE_SUFFIX = ".transaction.resource";
    private static final String OPTIONAL_ATTRIBUTE = "optional";
    private static final String RETURN_CLASS_PROPERTY = "returnClass";
    private static final String MIME_TYPE_PROPERTY = "mimeType";
    public static final String TRANSFORMER_KEY = ".transformer.";
    public static final String OBJECT_KEY = ".object.";
    public static final String SINGLE_TX = ".singletx.";
    public static final Predicate<String> TRANSFORMER_PREDICATE = propertyKey -> propertyKey.contains(TRANSFORMER_KEY);
    public static final Predicate<String> BINDING_PROVIDER_PREDICATE = propertyKey -> propertyKey.endsWith(".binding.provider") || propertyKey.endsWith("FunctionsProvider");
    protected ArtifactType artifactType = ArtifactType.APP;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    private final Predicate<String> propertyKeyfilter;

    public AbstractRegistryBootstrap(ArtifactType artifactType, MuleContext muleContext, Predicate<String> propertyKeyfilter) {
        this.artifactType = artifactType;
        this.muleContext = muleContext;
        this.propertyKeyfilter = propertyKeyfilter;
    }

    @Override
    public void initialise() throws InitialisationException {
        List<BootstrapService> bootstrapServices;
        try {
            bootstrapServices = this.muleContext.getRegistryBootstrapServiceDiscoverer().discover();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        int objectCounter = 1;
        LinkedList<TransformerBootstrapProperty> transformers = new LinkedList<TransformerBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> bindingProviders = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> namedObjects = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> unnamedObjects = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<TransactionFactoryBootstrapProperty> singleTransactionFactories = new LinkedList<TransactionFactoryBootstrapProperty>();
        for (BootstrapService bootstrapService : bootstrapServices) {
            Properties bootstrapProperties = bootstrapService.getProperties();
            for (Map.Entry<Object, Object> entry : bootstrapProperties.entrySet()) {
                this.logger.debug("Processing registryBootstrap entry: {}={}...", entry.getKey(), entry.getValue());
                String propertyKey = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (!this.propertyKeyfilter.test(propertyKey)) {
                    this.logger.debug("Skipped registryBootstrap entry: {}", entry.getKey());
                    continue;
                }
                if (propertyKey.contains(OBJECT_KEY)) {
                    this.logger.debug("Unnamed registryBootstrap entry: {}", entry.getKey());
                    String newKey = propertyKey.substring(0, propertyKey.lastIndexOf(".")) + objectCounter++;
                    unnamedObjects.add(this.createObjectBootstrapProperty(bootstrapService, newKey, propertyValue));
                    continue;
                }
                if (TRANSFORMER_PREDICATE.test(propertyKey)) {
                    this.logger.debug("Transformer registryBootstrap entry: {}", entry.getKey());
                    transformers.add(this.createTransformerBootstrapProperty(bootstrapService, propertyValue));
                    continue;
                }
                if (propertyKey.contains(SINGLE_TX)) {
                    if (!propertyKey.contains(TRANSACTION_RESOURCE_SUFFIX)) {
                        this.logger.debug("SingleTx Resource registryBootstrap entry: {}", entry.getKey());
                        singleTransactionFactories.add(this.createTransactionFactoryBootstrapProperty(bootstrapService, bootstrapProperties, propertyKey, propertyValue));
                        continue;
                    }
                    this.logger.debug("SingleTx registryBootstrap entry: {}", entry.getKey());
                    continue;
                }
                if (BINDING_PROVIDER_PREDICATE.test(propertyKey)) {
                    this.logger.debug("Binding Provider registryBootstrap entry: {}", entry.getKey());
                    bindingProviders.add(this.createObjectBootstrapProperty(bootstrapService, propertyKey, propertyValue));
                    continue;
                }
                this.logger.debug("Named registryBootstrap entry: {}", entry.getKey());
                namedObjects.add(this.createObjectBootstrapProperty(bootstrapService, propertyKey, propertyValue));
            }
        }
        try {
            this.registerUnnamedObjects(unnamedObjects);
            this.registerTransformers(transformers);
            this.registerObjects(bindingProviders);
            this.registerObjects(namedObjects);
            this.registerTransactionFactories(singleTransactionFactories, this.muleContext);
        }
        catch (Exception e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
    }

    private TransformerBootstrapProperty createTransformerBootstrapProperty(BootstrapService bootstrapService, String propertyValue) {
        int i;
        String name = null;
        boolean optional = false;
        String transString = propertyValue;
        String returnClassName = null;
        int index = transString.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(index + 1), ',');
            name = p.getProperty("name", null);
            returnClassName = p.getProperty(RETURN_CLASS_PROPERTY, null);
            optional = p.containsKey(OPTIONAL_ATTRIBUTE);
        }
        String mime = null;
        if (returnClassName != null && (i = returnClassName.indexOf(":")) > -1) {
            mime = returnClassName.substring(i + 1);
            returnClassName = returnClassName.substring(0, i);
        }
        String className = index == -1 ? transString : transString.substring(0, index);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(MIME_TYPE_PROPERTY, mime);
        properties.put(RETURN_CLASS_PROPERTY, returnClassName);
        return new TransformerBootstrapProperty(bootstrapService, new HashSet<ArtifactType>(Arrays.asList(ArtifactType.APP, ArtifactType.POLICY)), optional, name, className, returnClassName, mime);
    }

    private TransactionFactoryBootstrapProperty createTransactionFactoryBootstrapProperty(BootstrapService bootstrapService, Properties bootstrapProperties, String propertyKey, String propertyValue) throws InitialisationException {
        String transactionResourceKey = propertyKey.replace(".transaction.factory", TRANSACTION_RESOURCE_SUFFIX);
        String transactionResource = bootstrapProperties.getProperty(transactionResourceKey);
        if (transactionResource == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("There is no transaction resource specified for transaction factory %s", propertyKey)), (Initialisable)this);
        }
        String transactionResourceClassNameProperties = transactionResource;
        boolean optional = false;
        int index = transactionResourceClassNameProperties.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(transactionResourceClassNameProperties.substring(index + 1), ',');
            optional = p.containsKey(OPTIONAL_ATTRIBUTE);
        }
        String transactionResourceClassName = index == -1 ? transactionResourceClassNameProperties : transactionResourceClassNameProperties.substring(0, index);
        return new TransactionFactoryBootstrapProperty(bootstrapService, Collections.singleton(ArtifactType.APP), optional, propertyValue, transactionResourceClassName);
    }

    private ObjectBootstrapProperty createObjectBootstrapProperty(BootstrapService bootstrapService, String propertyKey, String propertyValue) {
        String className;
        boolean optional = false;
        Set<ArtifactType> artifactTypesParameterValue = new HashSet<ArtifactType>(Arrays.asList(ArtifactType.APP, ArtifactType.DOMAIN, ArtifactType.POLICY));
        String value = propertyValue;
        int index = value.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(value.substring(index + 1), ',');
            if (p.containsKey("applyToArtifactType")) {
                artifactTypesParameterValue = Arrays.stream(((String)p.get("applyToArtifactType")).split("\\/")).map(t -> ArtifactType.createFromString(t)).collect(Collectors.toSet());
            }
            optional = p.containsKey(OPTIONAL_ATTRIBUTE);
            className = value.substring(0, index);
        } else {
            className = value;
        }
        return new ObjectBootstrapProperty(bootstrapService, artifactTypesParameterValue, optional, propertyKey, className);
    }

    private void registerUnnamedObjects(List<ObjectBootstrapProperty> bootstrapProperties) throws Exception {
        for (ObjectBootstrapProperty bootstrapProperty : bootstrapProperties) {
            this.registerObject(bootstrapProperty);
        }
    }

    private void registerObjects(List<ObjectBootstrapProperty> bootstrapProperties) throws Exception {
        for (ObjectBootstrapProperty bootstrapProperty : bootstrapProperties) {
            this.registerObject(bootstrapProperty);
        }
    }

    private void registerObject(ObjectBootstrapProperty bootstrapProperty) throws Exception {
        try {
            if (!bootstrapProperty.getArtifactTypes().contains((Object)this.artifactType)) {
                return;
            }
            this.doRegisterObject(bootstrapProperty);
        }
        catch (InvocationTargetException e) {
            Throwable cause = ExceptionUtils.getCause((Throwable)e);
            this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && bootstrapProperty.getOptional() != false, cause, bootstrapProperty);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException e) {
            this.throwExceptionIfNotOptional(bootstrapProperty.getOptional(), e, bootstrapProperty);
        }
    }

    private void registerTransactionFactories(List<TransactionFactoryBootstrapProperty> singleTransactionFactories, MuleContext context) throws Exception {
        for (TransactionFactoryBootstrapProperty bootstrapProperty : singleTransactionFactories) {
            try {
                Class supportedType = bootstrapProperty.getService().forName(bootstrapProperty.getTransactionResourceClassName());
                context.getTransactionFactoryManager().registerTransactionFactory(supportedType, (TransactionFactory)bootstrapProperty.getService().instantiateClass(bootstrapProperty.getTransactionFactoryClassName(), new Object[0]));
            }
            catch (ClassNotFoundException | NoClassDefFoundError ncdfe) {
                this.throwExceptionIfNotOptional(bootstrapProperty.getOptional(), ncdfe, bootstrapProperty);
            }
        }
    }

    private void registerTransformers(List<TransformerBootstrapProperty> props) throws Exception {
        for (TransformerBootstrapProperty bootstrapProperty : props) {
            try {
                Class transformerClass = bootstrapProperty.getService().forName(bootstrapProperty.getClassName());
                Class returnClass = null;
                String returnClassString = bootstrapProperty.getReturnClassName();
                if (returnClassString != null) {
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : bootstrapProperty.getService().forName(returnClassString);
                }
                this.doRegisterTransformer(bootstrapProperty, returnClass, transformerClass);
            }
            catch (InvocationTargetException e) {
                Throwable cause = ExceptionUtils.getCause((Throwable)e);
                this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && bootstrapProperty.getOptional() != false, cause, bootstrapProperty);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.throwExceptionIfNotOptional(bootstrapProperty.getOptional(), e, bootstrapProperty);
            }
        }
    }

    protected abstract void doRegisterTransformer(TransformerBootstrapProperty var1, Class<?> var2, Class<? extends Transformer> var3) throws Exception;

    protected abstract void doRegisterObject(ObjectBootstrapProperty var1) throws Exception;

    private void throwExceptionIfNotOptional(boolean optional, Throwable t, AbstractBootstrapProperty bootstrapProperty) throws Exception {
        if (optional) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignoring optional " + bootstrapProperty);
            }
        } else {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }
}

