/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.dataweave;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.el.context.AbstractArtifactContext;

public class DataWeaveArtifactContext
extends AbstractArtifactContext {
    public DataWeaveArtifactContext(MuleContext muleContext, Registry registry) {
        super(muleContext, registry);
    }

    @Override
    protected Map<String, Object> createRegistry(Registry registry) {
        return new RegistryWrapperMap(registry);
    }

    protected static class RegistryWrapperMap
    implements Map<String, Object> {
        private Registry registry;

        public RegistryWrapperMap(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Registry does not support clear");
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            Object value = null;
            try {
                value = this.registry.lookupByName((String)key).orElse(null);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return value;
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Registry does not support put");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Registry does not support remove");
        }

        @Override
        public Collection<Object> values() {
            ArrayList<Object> values = new ArrayList<Object>(this.size());
            for (String key : this.keySet()) {
                values.add(this.get(key));
            }
            return values;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
            for (String key : this.keySet()) {
                entrySet.add((Map.Entry<String, Object>)new DefaultMapEntry((Object)key, this.get(key)));
            }
            return entrySet;
        }

        @Override
        public boolean containsValue(Object value) {
            for (String key : this.keySet()) {
                if (!value.equals(this.get(key))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException("Registry does not support keySet");
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Registry does not support size");
        }
    }
}

