/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.net;

import java.io.Serializable;
import org.mulesoft.common.core.package$Strings$;
import org.mulesoft.common.net.InetAddress;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.parse.ParseError$;
import org.mulesoft.common.parse.package$ParseResult$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Right;
import scala.util.matching.Regex;

public final class InetAddress$
implements scala.Serializable {
    public static InetAddress$ MODULE$;
    private final Regex Ipv4Regex;

    static {
        new InetAddress$();
    }

    public Either<ParseError, InetAddress> parse(String address) {
        Either<ParseError, InetAddress> r = this.parseAsIPv4(address);
        return r.isRight() ? r : (address.indexOf(58) == -1 ? r : this.parseAsIPv6(address));
    }

    public Either<ParseError, InetAddress> parseAsIPv4(String address) {
        Right right;
        Object object = new Object();
        try {
            Right right2;
            String string = address;
            Option option = this.Ipv4Regex().unapplySeq((CharSequence)string);
            if (!option.isEmpty()) {
                List groups = (List)option.get();
                Builder r = List$.MODULE$.newBuilder();
                groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
                    int g = new StringOps(Predef$.MODULE$.augmentString(group)).toInt();
                    if (g > 255) {
                        throw new NonLocalReturnControl(object, ParseError$.MODULE$.rangeError(g));
                    }
                    return r.$plus$eq((Object)BoxesRunTime.boxToInteger((int)g));
                });
                right2 = package$.MODULE$.Right().apply((Object)this.apply(false, (List<Object>)((List)r.result())));
            } else {
                right2 = ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            right = right2;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                right = (Right)ex.value();
            }
            throw ex;
        }
        return right;
    }

    public Either<ParseError, InetAddress> parseAsIPv6(String address) {
        Either either;
        Object object = new Object();
        try {
            BoxedUnit boxedUnit;
            String[] groups;
            String[] stringArray;
            int ipv4N;
            if (package$Strings$.MODULE$.isNullOrEmpty$extension(org.mulesoft.common.core.package$.MODULE$.Strings(address))) {
                return ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            int doubleColon = address.indexOf("::");
            if (doubleColon != -1 && address.indexOf("::", doubleColon + 1) != -1) {
                return ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            int lastColon = address.lastIndexOf(58);
            if (lastColon == -1) {
                return ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            int n = ipv4N = address.indexOf(46, lastColon) == -1 ? 0 : 1;
            if (doubleColon == -1) {
                stringArray = new StringOps(Predef$.MODULE$.augmentString(address)).split(':');
            } else {
                String[] head = InetAddress$.split$1(address.substring(0, doubleColon));
                String[] tail = InetAddress$.split$1(address.substring(doubleColon + 2));
                stringArray = groups = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])head)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(8 - head.length - tail.length - ipv4N, (Function0 & Serializable & scala.Serializable)() -> "0", ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tail)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            if (groups.length + ipv4N != 8) {
                return ParseError$.MODULE$.formatError(address, "Wrong number of groups");
            }
            Builder r = List$.MODULE$.newBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), groups.length - ipv4N).foreach((Function1 & Serializable & scala.Serializable)i -> InetAddress$.$anonfun$parseAsIPv6$2(groups, object, r, BoxesRunTime.unboxToInt((Object)i)));
            if (ipv4N == 1) {
                Either<ParseError, InetAddress> either2 = this.parseAsIPv4((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups)).last());
                if (!(either2 instanceof Right)) {
                    return either2;
                }
                Right right = (Right)either2;
                InetAddress ia = (InetAddress)right.value();
                r.$plus$eq((Object)BoxesRunTime.boxToInteger((int)((BoxesRunTime.unboxToInt((Object)ia.groups().apply(0)) << 8) + BoxesRunTime.unboxToInt((Object)ia.groups().apply(1)))));
                Builder builder = r.$plus$eq((Object)BoxesRunTime.boxToInteger((int)((BoxesRunTime.unboxToInt((Object)ia.groups().apply(2)) << 8) + BoxesRunTime.unboxToInt((Object)ia.groups().apply(3)))));
                boxedUnit = builder;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)this.apply(true, (List<Object>)((List)r.result())));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    public InetAddress ipv4(String address) {
        return package$ParseResult$.MODULE$.result$extension(org.mulesoft.common.parse.package$.MODULE$.ParseResult(this.parseAsIPv4(address)));
    }

    public InetAddress ipv6(String address) {
        return package$ParseResult$.MODULE$.result$extension(org.mulesoft.common.parse.package$.MODULE$.ParseResult(this.parseAsIPv6(address)));
    }

    public InetAddress apply(String address) {
        return package$ParseResult$.MODULE$.result$extension(org.mulesoft.common.parse.package$.MODULE$.ParseResult(this.parse(address)));
    }

    private final String Ipv4Group() {
        return "(0|[1-9]\\d{0,2})";
    }

    private final Regex Ipv4Regex() {
        return this.Ipv4Regex;
    }

    private final int Ipv4MaxOctetValue() {
        return 255;
    }

    private final int Ipv6Groups() {
        return 8;
    }

    private final int Ipv6MaxGroupValue() {
        return 65535;
    }

    public InetAddress apply(boolean ipv6, List<Object> groups) {
        return new InetAddress(ipv6, groups);
    }

    public Option<Tuple2<Object, List<Object>>> unapply(InetAddress x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x$0.ipv6()), x$0.groups()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final String[] split$1(String s) {
        return s.isEmpty() ? (String[])((Object[])new String[]{"0"}) : new StringOps(Predef$.MODULE$.augmentString(s)).split(':');
    }

    public static final /* synthetic */ Builder $anonfun$parseAsIPv6$2(String[] groups$1, Object nonLocalReturnKey2$1, Builder r$2, int i) {
        Builder builder;
        String g = groups$1[i];
        try {
            int v = Integer.parseInt(g, 16);
            if (v > 65535) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, ParseError$.MODULE$.rangeError(v));
            }
            builder = r$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)v));
        }
        catch (Exception exception) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, ParseError$.MODULE$.formatError(g, ParseError$.MODULE$.formatError$default$2()));
        }
        return builder;
    }

    private InetAddress$() {
        MODULE$ = this;
        this.Ipv4Regex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("^").append("(0|[1-9]\\d{0,2})").append(".").append("(0|[1-9]\\d{0,2})").append(".").append("(0|[1-9]\\d{0,2})").append(".").append("(0|[1-9]\\d{0,2})").append("$").toString())).r();
    }
}

