/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.nativelib;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFileExtension;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactCopyNativeLibraryFinder
implements NativeLibraryFinder {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String JNILIB_EXTENSION = ".jnilib";
    public static final String EMPTY_STRING = "";
    public static final String LIB_PREFIX = "lib";
    public static final String HYPHEN_SEPARATOR = "-";
    private final File artifactTempFolder;
    private final URL[] urls;

    public ArtifactCopyNativeLibraryFinder(File tempFolder, URL[] urls) {
        this.urls = urls;
        this.artifactTempFolder = new File(tempFolder, "native");
        if (this.artifactTempFolder.exists()) {
            this.cleanNativeLibs();
        } else if (!this.artifactTempFolder.mkdirs()) {
            throw new IllegalStateException(String.format("Unable to create application '%s' folder", this.artifactTempFolder.getAbsolutePath()));
        }
    }

    @Override
    public String findLibrary(String name, String parentLibraryPath) {
        String libraryPath = parentLibraryPath;
        if (null == libraryPath) {
            libraryPath = this.findLibraryLocally(name);
        }
        if (libraryPath != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Found native library for '%s' on '%s", name, libraryPath));
            }
            File tempLibrary = this.copyNativeLibrary(name, libraryPath);
            libraryPath = tempLibrary.getAbsolutePath();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Created native library copy for '%s' on '%s", name, libraryPath));
            }
        }
        return libraryPath;
    }

    private void cleanNativeLibs() {
        String[] list = this.artifactTempFolder.list();
        if (list != null) {
            for (String library : list) {
                new File(this.artifactTempFolder, library).delete();
            }
        }
    }

    private File copyNativeLibrary(String name, String libraryPath) {
        String nativeLibName = System.mapLibraryName(name);
        File tempLibrary = new File(this.artifactTempFolder, nativeLibName + System.currentTimeMillis());
        try {
            File library = new File(URLDecoder.decode(libraryPath, Charset.defaultCharset().name()));
            FileUtils.copyFile((File)library, (File)tempLibrary);
            return tempLibrary;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to generate copy for native library '%s' at '%s'", nativeLibName, tempLibrary.getAbsolutePath()), e);
        }
    }

    private String findLibraryLocally(String name) {
        String nativeLibName = System.mapLibraryName(name);
        String extension = FilenameUtils.getExtension((String)nativeLibName);
        Optional<URL> nativeLib = Arrays.stream(this.urls).filter(url -> {
            String fullPath;
            try {
                fullPath = url.toURI().toString();
            }
            catch (URISyntaxException e) {
                return false;
            }
            String baseName = FilenameUtils.getBaseName((String)fullPath);
            return baseName.contains(name) && (fullPath.endsWith(extension) || SystemUtils.IS_OS_MAC && fullPath.endsWith(JNILIB_EXTENSION));
        }).findFirst();
        if (nativeLib.isPresent()) {
            return nativeLib.get().getFile();
        }
        return null;
    }

    @Override
    public List<String> findLibraryNames() {
        ArrayList<String> nativeLibraries = new ArrayList<String>();
        for (URL url : this.urls) {
            String fullPath;
            try {
                fullPath = url.toURI().toString();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            String libraryName = FilenameUtils.getName((String)fullPath);
            if (!this.isNativeLibrary(libraryName)) continue;
            String libraryBaseName = ArtifactCopyNativeLibraryFinder.getLibraryBaseName(libraryName);
            nativeLibraries.add(libraryBaseName);
        }
        return nativeLibraries;
    }

    private boolean isNativeLibrary(String libName) {
        if (Objects.equals(libName, EMPTY_STRING)) {
            return false;
        }
        for (NativeLibraryFileExtension extension : NativeLibraryFileExtension.values()) {
            if (!libName.endsWith(extension.value())) continue;
            return true;
        }
        return false;
    }

    private static String getLibraryBaseName(String libraryName) {
        return FilenameUtils.getBaseName((String)libraryName).replaceFirst(LIB_PREFIX, EMPTY_STRING).split(HYPHEN_SEPARATOR)[0];
    }
}

