/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;
import org.mule.runtime.ast.internal.serialization.dto.ErrorTypeHierarchyItemDTO;
import org.mule.runtime.ast.internal.serialization.json.gson.PostProcessingEnabler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTypeRepositoryDTO
implements ErrorTypeRepository,
PostProcessingEnabler.PostProcessable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorTypeRepositoryDTO.class);
    private static final ComponentIdentifier ANY_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace(ErrorTypeBuilder.CORE_NAMESPACE_NAME).name(ErrorTypeBuilder.ANY_IDENTIFIER).build();
    private static final ComponentIdentifier SOURCE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace(ErrorTypeBuilder.CORE_NAMESPACE_NAME).name("SOURCE").build();
    private static final ComponentIdentifier SOURCE_RESPONSE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace(ErrorTypeBuilder.CORE_NAMESPACE_NAME).name("SOURCE_RESPONSE").build();
    private static final ComponentIdentifier CRITICAL_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace(ErrorTypeBuilder.CORE_NAMESPACE_NAME).name(ErrorTypeBuilder.CRITICAL_IDENTIFIER).build();
    private final List<ErrorTypeHierarchyItemDTO> hierarchy;
    private transient Supplier<Map<ComponentIdentifier, ErrorType>> errorTypes;
    private transient Supplier<Map<ComponentIdentifier, ErrorType>> internalErrorTypes;
    private transient ErrorType anyErrorType;
    private transient ErrorType sourceErrorType;
    private transient ErrorType sourceResponseErrorType;
    private transient ErrorType criticalErrorType;

    @Override
    public void postProcess() {
        this.initErrorTypesCollections();
    }

    protected void initErrorTypesCollections() {
        this.errorTypes = new LazyValue(() -> this.initializeErrorTypeSet(false));
        this.internalErrorTypes = new LazyValue(() -> this.initializeErrorTypeSet(true));
    }

    protected Map<ComponentIdentifier, ErrorType> initializeErrorTypeSet(boolean internal) {
        HashMap<ComponentIdentifier, ErrorType> types = new HashMap<ComponentIdentifier, ErrorType>();
        this.initializeErrorTypeSetForChildrenRecursively(null, this.getHierarchy(), types, internal);
        return types;
    }

    protected void initializeErrorTypeSetForChildrenRecursively(ErrorType parentErrorType, List<ErrorTypeHierarchyItemDTO> hierarchyItemChildren, Map<ComponentIdentifier, ErrorType> types, boolean internal) {
        for (ErrorTypeHierarchyItemDTO hierarchyChildItem : hierarchyItemChildren) {
            String namespace = hierarchyChildItem.getNamespace().toUpperCase();
            ErrorType hierarchyItemErrorType = ErrorTypeBuilder.builder().namespace(namespace).identifier(hierarchyChildItem.getIdentifier()).parentErrorType(parentErrorType).build();
            if (hierarchyChildItem.isInternal() == internal) {
                ComponentIdentifier errorTypeIdentifier = ComponentIdentifier.builder().namespace(namespace).name(hierarchyChildItem.getIdentifier()).build();
                types.put(errorTypeIdentifier, hierarchyItemErrorType);
                if (ANY_ERROR_IDENTIFIER.equals(errorTypeIdentifier)) {
                    this.anyErrorType = hierarchyItemErrorType;
                } else if (SOURCE_ERROR_IDENTIFIER.equals(errorTypeIdentifier)) {
                    this.sourceErrorType = hierarchyItemErrorType;
                } else if (SOURCE_RESPONSE_ERROR_IDENTIFIER.equals(errorTypeIdentifier)) {
                    this.sourceResponseErrorType = hierarchyItemErrorType;
                } else if (CRITICAL_ERROR_IDENTIFIER.equals(errorTypeIdentifier)) {
                    this.criticalErrorType = hierarchyItemErrorType;
                }
            }
            this.initializeErrorTypeSetForChildrenRecursively(hierarchyItemErrorType, hierarchyChildItem.getChildren(), types, internal);
        }
    }

    public ErrorTypeRepositoryDTO(ErrorType anyErrorType, ErrorType sourceErrorType, ErrorType sourceResponseErrorType, ErrorType criticalErrorType, Set<ErrorType> errorTypes, Set<ErrorType> internalErrorTypes) {
        MultiMap parentChildren = (MultiMap)this.nonRootErrorTypesStream(errorTypes, internalErrorTypes).collect(MultiMap.toMultiMap(ErrorType::getParentErrorType, UnaryOperator.identity()));
        this.hierarchy = this.rootErrorTypesStream(errorTypes, internalErrorTypes).map(errorType -> this.createHierarchyItemRecursively((ErrorType)errorType, internalErrorTypes::contains, (MultiMap<ErrorType, ErrorType>)parentChildren)).collect(Collectors.toList());
        this.initErrorTypesCollections();
        this.anyErrorType = anyErrorType;
        this.sourceErrorType = sourceErrorType;
        this.sourceResponseErrorType = sourceResponseErrorType;
        this.criticalErrorType = criticalErrorType;
    }

    protected Stream<ErrorType> nonRootErrorTypesStream(Set<ErrorType> errorTypes, Set<ErrorType> internalErrorTypes) {
        return Stream.concat(errorTypes.stream(), internalErrorTypes.stream()).filter(errorType -> errorType.getParentErrorType() != null);
    }

    protected Stream<ErrorType> rootErrorTypesStream(Set<ErrorType> errorTypes, Set<ErrorType> internalErrorTypes) {
        return Stream.concat(errorTypes.stream(), internalErrorTypes.stream()).filter(errorType -> errorType.getParentErrorType() == null);
    }

    private ErrorTypeHierarchyItemDTO createHierarchyItemRecursively(ErrorType errorType, Predicate<ErrorType> internal, MultiMap<ErrorType, ErrorType> parentChildren) {
        return new ErrorTypeHierarchyItemDTO(errorType.getIdentifier(), errorType.getNamespace(), internal.test(errorType), parentChildren.getAll((Object)errorType).stream().map(childErrorType -> this.createHierarchyItemRecursively((ErrorType)childErrorType, internal, parentChildren)).collect(Collectors.toList()));
    }

    public ErrorType addErrorType(ComponentIdentifier componentIdentifier, ErrorType errorType) {
        throw new UnsupportedOperationException("This error repository is immutable");
    }

    public ErrorType addInternalErrorType(ComponentIdentifier componentIdentifier, ErrorType errorType) {
        throw new UnsupportedOperationException("This error repository is immutable");
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier componentIdentifier) {
        Optional<ErrorType> optional = this.doLookupErrorType(this.errorTypes.get(), componentIdentifier);
        if (optional.isPresent()) {
            return optional;
        }
        if (Boolean.getBoolean("mule.errorTypes.lax")) {
            LOGGER.warn("Could not find error '{}'.", (Object)componentIdentifier);
            return Optional.of(ErrorTypeBuilder.builder().namespace(componentIdentifier.getNamespace().toUpperCase()).identifier(componentIdentifier.getName()).parentErrorType(this.getAnyErrorType()).build());
        }
        return Optional.empty();
    }

    protected Optional<ErrorType> doLookupErrorType(Map<ComponentIdentifier, ErrorType> errorTypes, ComponentIdentifier componentIdentifier) {
        return Optional.ofNullable(errorTypes.get(componentIdentifier));
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier componentIdentifier) {
        Optional<ErrorType> errorType = this.doLookupErrorType(this.errorTypes.get(), componentIdentifier);
        if (!errorType.isPresent()) {
            errorType = this.doLookupErrorType(this.internalErrorTypes.get(), componentIdentifier);
        }
        return errorType;
    }

    public Collection<String> getErrorNamespaces() {
        return Stream.concat(this.getErrorTypes().stream(), this.getInternalErrorTypes().stream()).map(errorType -> errorType.getNamespace().toUpperCase()).distinct().collect(Collectors.toList());
    }

    public ErrorType getAnyErrorType() {
        return this.anyErrorType;
    }

    public ErrorType getSourceErrorType() {
        return this.sourceErrorType;
    }

    public ErrorType getSourceResponseErrorType() {
        return this.sourceResponseErrorType;
    }

    public ErrorType getCriticalErrorType() {
        return this.criticalErrorType;
    }

    public Set<ErrorType> getErrorTypes() {
        return new HashSet<ErrorType>(this.errorTypes.get().values());
    }

    public Set<ErrorType> getInternalErrorTypes() {
        return new HashSet<ErrorType>(this.internalErrorTypes.get().values());
    }

    public List<ErrorTypeHierarchyItemDTO> getHierarchy() {
        return this.hierarchy;
    }
}

