/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.module.extension.internal.loader.validator.DeprecationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.JavaConfigurationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.JavaConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.ParameterPluralNameModelValidator;

public abstract class AbstractExtensionModelLoader
extends ExtensionModelLoader {
    private static boolean IGNORE_DISABLED = System.getProperty("mule.disableSdkComponentIgnore") != null;
    private static final boolean ENABLE_POLLING_SOURCE_LIMIT = System.getProperty("mule.enablePollingSourceLimit") != null;
    private final List<ExtensionModelValidator> validators = Collections.unmodifiableList(Arrays.asList(new JavaConfigurationModelValidator(), new JavaConnectionProviderModelValidator(), new DeprecationModelValidator(), new ParameterPluralNameModelValidator()));

    public static void setIgnoreDisabled(boolean value) {
        IGNORE_DISABLED = value;
    }

    public static boolean getIgnoreDisabled() {
        return IGNORE_DISABLED;
    }

    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        context.addCustomValidators(this.validators);
        Optional disableComponentIgnore = context.getParameter("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE");
        disableComponentIgnore.ifPresent(value -> Preconditions.checkState((boolean)(value instanceof Boolean), (String)String.format("Property value for %s expected to be boolean", "EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE")));
        if (IGNORE_DISABLED && !disableComponentIgnore.isPresent()) {
            context.addParameter("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", (Object)true);
        }
        if (ENABLE_POLLING_SOURCE_LIMIT) {
            context.addParameter("EXTENSION_LOADER_ENABLE_POLLING_SOURCE_LIMIT", (Object)true);
        }
    }

    protected abstract ExtensionModelParserFactory getExtensionModelParserFactory(ExtensionLoadingContext var1);

    protected final void declareExtension(ExtensionLoadingContext context) {
        String version = (String)context.getParameter("version").orElseThrow(() -> new IllegalArgumentException("version not specified"));
        ExtensionModelParserFactory parserFactory = this.getExtensionModelParserFactory(context);
        this.getModelLoaderDelegate(context, version).declare(parserFactory, context);
    }

    protected ModelLoaderDelegate getModelLoaderDelegate(ExtensionLoadingContext context, String version) {
        return new DefaultExtensionModelLoaderDelegate(version);
    }
}

