/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.util.journal.JournalEntry;
import org.mule.runtime.core.internal.util.journal.JournalEntrySerializer;
import org.mule.runtime.core.internal.util.journal.TransactionCompletePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionJournalFile<T, K extends JournalEntry<T>> {
    private static final int MINIMUM_ENTRIES_TO_CLEAR_FILE = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionJournalFile.class);
    private final File journalFile;
    private final JournalEntrySerializer<T, K> journalEntrySerializer;
    private final Long clearFileMinimumSizeInBytes;
    private Multimap<T, K> entries = LinkedHashMultimap.create();
    private DataOutputStream logFileOutputStream;
    private int journalOperations = 0;

    public TransactionJournalFile(File journalFile, JournalEntrySerializer journalEntrySerializer, TransactionCompletePredicate transactionCompletePredicate, Long clearFileMinimumSizeInBytes) {
        this.journalFile = journalFile;
        this.journalEntrySerializer = journalEntrySerializer;
        this.clearFileMinimumSizeInBytes = clearFileMinimumSizeInBytes;
        if (journalFile.exists()) {
            this.loadAllEntries(transactionCompletePredicate);
        }
        this.createLogOutputStream();
    }

    public synchronized void logOperation(K journalEntry) {
        this.entries.put(journalEntry.getTxId(), journalEntry);
        this.journalEntrySerializer.serialize(journalEntry, this.logFileOutputStream);
        ++this.journalOperations;
    }

    public synchronized void clearEntriesForTransaction(T txId) {
        this.doClearEntriesForTransaction(txId);
        this.clearFileIfNeeded();
    }

    protected void doClearEntriesForTransaction(T txId) {
        Collection entries = this.entries.removeAll(txId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evicted from tx log file " + entries.size() + " entries from txid " + txId);
        }
    }

    protected void clearFileIfNeeded() {
        if (this.entries.isEmpty()) {
            if (this.clearFileMinimumSizeInBytes != null) {
                if (this.fileLength() > this.clearFileMinimumSizeInBytes) {
                    this.clear();
                    this.journalOperations = 0;
                }
            } else if (this.journalOperations > 10000) {
                this.clear();
                this.journalOperations = 0;
            }
        }
    }

    public synchronized void close() {
        block2: {
            try {
                this.logFileOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage());
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Error closing transaction journal file", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<K> getLogEntries(T txId) {
        Collection entries = (Collection)this.entries.asMap().get(txId);
        if (entries == null) {
            return Collections.emptyList();
        }
        Collection collection = entries;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList(entries));
        }
    }

    public synchronized Multimap<T, K> getAllLogEntries() {
        return this.entries;
    }

    public synchronized void clear() {
        this.close();
        this.entries.clear();
        FileUtils.deleteQuietly((File)this.journalFile);
        this.createLogOutputStream();
    }

    private void createLogOutputStream() {
        if (!this.journalFile.exists()) {
            try {
                this.journalFile.createNewFile();
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        try {
            this.logFileOutputStream = new DataOutputStream(new FileOutputStream(this.journalFile, true));
        }
        catch (FileNotFoundException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void loadAllEntries(TransactionCompletePredicate transactionCompletePredicate) {
        if (!this.journalFile.exists()) {
            return;
        }
        FilterInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.journalFile)));
            boolean logEntryCreationFailed = false;
            while (!logEntryCreationFailed) {
                try {
                    K journalEntry = this.journalEntrySerializer.deserialize((DataInputStream)dataInputStream);
                    if (journalEntry != null) {
                        this.entries.put(journalEntry.getTxId(), journalEntry);
                        ++this.journalOperations;
                        if (!transactionCompletePredicate.isTransactionComplete((JournalEntry)journalEntry)) continue;
                        this.journalOperations -= this.entries.get(journalEntry.getTxId()).size();
                        this.doClearEntriesForTransaction(journalEntry.getTxId());
                        continue;
                    }
                    logEntryCreationFailed = true;
                }
                catch (EOFException e) {
                    LOGGER.debug("Expected exception since there are no more log entries", (Throwable)e);
                    logEntryCreationFailed = true;
                }
                catch (Exception e) {
                    LOGGER.warn("Exception reading transaction content. This is normal if the mule server was shutdown due to a failure" + e.getMessage());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Error reading transaction journal file", (Throwable)e);
                    }
                    logEntryCreationFailed = true;
                }
            }
            this.clearFileIfNeeded();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error loading transaction journal file entries", (Throwable)e);
            }
        }
    }

    public int size() {
        return this.entries.size();
    }

    public boolean containsTx(T txId) {
        return this.entries.containsKey(txId);
    }

    public long fileLength() {
        return this.journalFile.length();
    }
}

