/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.google.common.base.Functions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.BackPressureAction;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalTypeModelProperty;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ReactiveReconnectionCallback;
import org.mule.runtime.module.extension.internal.runtime.connectivity.SdkReconnectableAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.source.ComposedSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.NullSourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.NullSourceCompletionHandler;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionProvider;
import org.mule.runtime.module.extension.internal.runtime.source.SourceWrapper;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacySourceWrapper;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SourceTransactionalActionUtils;
import org.mule.runtime.module.extension.internal.runtime.source.poll.RestartContext;
import org.mule.runtime.module.extension.internal.runtime.source.poll.Restartable;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.runtime.connectivity.Reconnectable;
import org.mule.sdk.api.runtime.connectivity.ReconnectionCallback;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.tx.SourceTransactionalAction;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class SourceAdapter
implements Lifecycle,
Restartable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceAdapter.class);
    private static final Boolean COMMIT_ON_REDELIVERY = Boolean.getBoolean("mule.commit.on.redelivery.exhausted");
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final Source source;
    private final Optional<ConfigurationInstance> configurationInstance;
    private final Optional<FieldSetter<Object, Object>> configurationSetter;
    private final Optional<FieldSetter<Object, ConnectionProvider>> connectionSetter;
    private final SourceCallbackFactory sourceCallbackFactory;
    private final CursorProviderFactory cursorProviderFactory;
    private final ResolverSet nonCallbackParameters;
    private final ResolverSet successCallbackParameters;
    private final ResolverSet errorCallbackParameters;
    private final Component component;
    private final SourceConnectionManager connectionManager;
    private final MessagingExceptionResolver exceptionResolver;
    private final BackPressureAction backPressureAction;
    private final Supplier<Object> sourceInvokationTarget;
    private ErrorType flowBackPressueErrorType;
    private ErrorType redeliveryExhaustedErrorType;
    private boolean initialised = false;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private MuleContext muleContext;

    public SourceAdapter(ExtensionModel extensionModel, SourceModel sourceModel, Source source, Optional<ConfigurationInstance> configurationInstance, CursorProviderFactory cursorProviderFactory, SourceCallbackFactory sourceCallbackFactory, Component component, SourceConnectionManager connectionManager, ResolverSet nonCallbackParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters, Optional<BackPressureAction> backPressureAction) {
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.source = source;
        this.sourceInvokationTarget = new LazyValue(() -> this.unwrapSource(source));
        this.cursorProviderFactory = cursorProviderFactory;
        this.configurationInstance = configurationInstance;
        this.sourceCallbackFactory = sourceCallbackFactory;
        this.component = component;
        this.connectionManager = connectionManager;
        this.nonCallbackParameters = nonCallbackParameters;
        this.successCallbackParameters = successCallbackParameters;
        this.errorCallbackParameters = errorCallbackParameters;
        this.exceptionResolver = new MessagingExceptionResolver(component);
        this.configurationSetter = this.fetchConfigurationField();
        this.connectionSetter = this.fetchConnectionProviderField();
        this.backPressureAction = backPressureAction.orElse(BackPressureAction.FAIL);
    }

    private Object unwrapSource(Source source) {
        if (source instanceof SourceWrapper) {
            return this.unwrapSource(((SourceWrapper)source).getDelegate());
        }
        if (source instanceof LegacySourceWrapper) {
            return ((LegacySourceWrapper)source).getDelegate();
        }
        return source;
    }

    private SourceCallback createSourceCallback() {
        return this.sourceCallbackFactory.createSourceCallback(this.createCompletionHandlerFactory());
    }

    private SourceCompletionHandlerFactory createCompletionHandlerFactory() {
        return this.sourceModel.getModelProperty(SourceCallbackModelProperty.class).map(this::doCreateCompletionHandler).orElse(context -> new NullSourceCompletionHandler());
    }

    private SourceCompletionHandlerFactory doCreateCompletionHandler(SourceCallbackModelProperty modelProperty) {
        SourceCallbackExecutor onBackPressureExecutor;
        SourceCallbackExecutor onTerminateExecutor;
        SourceCallbackExecutor onErrorExecutor;
        SourceCallbackExecutor onSuccessExecutor;
        if (this.source instanceof SourceWrapper) {
            SourceWrapper wrapper = (SourceWrapper)this.source;
            onSuccessExecutor = this.getMethodExecutor(modelProperty.getOnSuccessMethod(), modelProperty, wrapper::onSuccess);
            onErrorExecutor = this.getMethodExecutor(modelProperty.getOnErrorMethod(), modelProperty, wrapper::onError);
            onTerminateExecutor = this.getMethodExecutor(modelProperty.getOnTerminateMethod(), modelProperty, wrapper::onTerminate);
            onBackPressureExecutor = this.getMethodExecutor(modelProperty.getOnBackPressureMethod(), modelProperty, wrapper::onBackPressure);
        } else {
            onSuccessExecutor = this.getMethodExecutor(modelProperty.getOnSuccessMethod(), modelProperty);
            onErrorExecutor = this.getMethodExecutor(modelProperty.getOnErrorMethod(), modelProperty);
            onTerminateExecutor = this.getMethodExecutor(modelProperty.getOnTerminateMethod(), modelProperty);
            onBackPressureExecutor = this.getMethodExecutor(modelProperty.getOnBackPressureMethod(), modelProperty);
        }
        return context -> new DefaultSourceCompletionHandler(onSuccessExecutor, onErrorExecutor, onTerminateExecutor, onBackPressureExecutor, context);
    }

    private SourceCallbackExecutor getMethodExecutor(Optional<Method> method, SourceCallbackModelProperty sourceCallbackModel) {
        return this.getMethodExecutor(method, sourceCallbackModel, null);
    }

    private SourceCallbackExecutor getMethodExecutor(Optional<Method> method, SourceCallbackModelProperty sourceCallbackModel, SourceCallbackExecutor then) {
        SourceCallbackExecutor executor = method.map(m -> new DefaultSourceCallbackExecutor(this.extensionModel, this.configurationInstance, this.sourceModel, this.sourceInvokationTarget.get(), (Method)m, this.cursorProviderFactory, this.streamingManager, this.component, this.muleContext, sourceCallbackModel)).orElse(NullSourceCallbackExecutor.INSTANCE);
        if (then != null) {
            executor = new ComposedSourceCallbackExecutor(executor, then);
        }
        return executor;
    }

    public void initialise() throws InitialisationException {
        if (this.initialised) {
            return;
        }
        this.flowBackPressueErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).orElseThrow(() -> new IllegalStateException("FLOW_BACK_PRESSURE error type not found"));
        this.redeliveryExhaustedErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).orElseThrow(() -> new IllegalStateException("REDELIVERY_EXHAUSTED error type not found"));
        LifecycleUtils.initialiseIfNeeded((Object)this.nonCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.errorCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.successCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
        this.injectComponentLocation();
        try {
            this.setConfiguration(this.configurationInstance);
            this.setConnection();
            this.muleContext.getInjector().inject(this.sourceInvokationTarget.get());
            if (this.source instanceof SourceWrapper) {
                this.muleContext.getInjector().inject((Object)this.source);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.source);
        this.initialised = true;
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.source, (Logger)LOGGER);
        this.initialised = false;
    }

    @Override
    public RestartContext beginRestart() {
        if (this.source instanceof Restartable) {
            return ((Restartable)this.source).beginRestart();
        }
        return null;
    }

    @Override
    public void finishRestart(RestartContext restartContext) {
        if (this.source instanceof Restartable) {
            ((Restartable)this.source).finishRestart(restartContext);
        }
    }

    public void start() throws MuleException {
        try {
            this.source.onStart(this.createSourceCallback());
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void injectComponentLocation() {
        this.injectComponentLocation(this.sourceInvokationTarget.get());
        if (this.source instanceof SourceWrapper) {
            this.injectComponentLocation(this.source);
        }
    }

    private void injectComponentLocation(Object source) {
        List<Field> fields = IntrospectionUtils.getFieldsOfType(source.getClass(), ComponentLocation.class);
        if (fields.isEmpty()) {
            return;
        }
        new FieldSetter<Object, ComponentLocation>(fields.get(0)).set(source, this.component.getLocation());
    }

    public void stop() throws MuleException {
        try {
            this.source.onStop();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void setConfiguration(Optional<ConfigurationInstance> configuration) {
        if (this.configurationSetter.isPresent() && configuration.isPresent()) {
            this.configurationSetter.get().set(this.sourceInvokationTarget.get(), configuration.get().getValue());
        }
    }

    private void setConnection() throws MuleException {
        if (!this.connectionSetter.isPresent()) {
            return;
        }
        FieldSetter<Object, ConnectionProvider> setter = this.connectionSetter.get();
        ConfigurationInstance config = this.configurationInstance.orElseThrow(() -> new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"Message Source on root component '%s' requires a connection but it doesn't point to any configuration. Please review your application", (Object[])new Object[]{this.component.getLocation().getRootContainerName()})));
        if (!config.getConnectionProvider().isPresent()) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)String.format("Message Source on root component '%s' requires a connection, but points to config '%s' which doesn't specify any. Please review your application", this.component.getLocation().getRootContainerName(), config.getName())));
        }
        SourceConnectionProvider connectionProvider = new SourceConnectionProvider(this.connectionManager, config);
        setter.set(this.sourceInvokationTarget.get(), connectionProvider);
    }

    Optional<ConfigurationInstance> getConfigurationInstance() {
        return this.configurationInstance;
    }

    private <T> Optional<FieldSetter<Object, T>> fetchConfigurationField() {
        Optional<Field> configurationField = IntrospectionUtils.fetchConfigFieldFromSourceObject(this.sourceInvokationTarget.get());
        return configurationField.map(FieldSetter::new);
    }

    private <T> Optional<FieldSetter<Object, T>> fetchConnectionProviderField() {
        Optional<Field> connectionField = IntrospectionUtils.fetchConnectionFieldFromSourceObject(this.sourceInvokationTarget.get());
        return connectionField.map(field -> {
            if (!ConnectionProvider.class.equals(field.getType())) {
                throw new IllegalModelDefinitionException(String.format("Message Source defined on class '%s' has field '%s' of type '%s' annotated with @%s. That annotation can only be used on fields of type '%s'", this.sourceInvokationTarget.get().getClass().getName(), field.getName(), field.getType().getName(), Connection.class.getName(), ConnectionProvider.class.getName()));
            }
            return new FieldSetter((Field)field);
        });
    }

    public String getName() {
        return IntrospectionUtils.getSourceName(this.sourceInvokationTarget.get().getClass());
    }

    public Object getDelegate() {
        return this.sourceInvokationTarget.get();
    }

    Optional<Publisher<Void>> getReconnectionAction(ConnectionException e) {
        Optional<Reconnectable> adapter = SdkReconnectableAdapter.from(this.sourceInvokationTarget.get());
        return adapter.map(reconnectable -> Mono.create(sink -> reconnectable.reconnect(e, (ReconnectionCallback)new ReactiveReconnectionCallback((MonoSink<Void>)sink))));
    }

    public SourceTransactionalAction getTransactionalAction() {
        Optional transactionalAction = this.getNonCallbackParameterValue(this.getTransactionalActionFieldName());
        if (transactionalAction.isPresent()) {
            try {
                return SourceTransactionalActionUtils.from(transactionalAction.get());
            }
            catch (Exception e) {
                throw new IllegalStateException("The resolved value is not a " + SourceTransactionalAction.class.getSimpleName(), e);
            }
        }
        return SourceTransactionalAction.NONE;
    }

    TransactionType getTransactionalType() {
        Optional transactionalType = this.getNonCallbackParameterValue(this.getTransactionTypeFieldName());
        if (transactionalType.isPresent()) {
            if (transactionalType.get() instanceof TransactionType) {
                return (TransactionType)transactionalType.get();
            }
            throw new IllegalStateException("The resolved value is not a " + TransactionType.class.getSimpleName());
        }
        return TransactionType.LOCAL;
    }

    private <T> Optional<T> getNonCallbackParameterValue(String fieldName) {
        Object object;
        ValueResolver<?> valueResolver = this.nonCallbackParameters.getResolvers().get(fieldName);
        if (valueResolver == null) {
            return Optional.empty();
        }
        CoreEvent initialiserEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        try (ValueResolvingContext context = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).build();){
            object = valueResolver.resolve(context);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to get the " + fieldName + " value for Message Source")), (Throwable)e);
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
        return Optional.of(object);
    }

    private String getTransactionalActionFieldName() {
        return this.getFieldNameEnrichedWith(TransactionalActionModelProperty.class, "transactionalAction");
    }

    private String getTransactionTypeFieldName() {
        return this.getFieldNameEnrichedWith(TransactionalTypeModelProperty.class, "transactionType");
    }

    private String getFieldNameEnrichedWith(Class<? extends ModelProperty> type, String defaultName) {
        return this.sourceModel.getAllParameterModels().stream().filter(param -> param.getModelProperty(type).isPresent()).filter(param -> param.getModelProperty(DeclaringMemberModelProperty.class).isPresent()).map(param -> (DeclaringMemberModelProperty)param.getModelProperty(DeclaringMemberModelProperty.class).get()).findAny().map(modelProperty -> modelProperty.getDeclaringField().getName()).orElse(defaultName);
    }

    private MessagingException createSourceException(CoreEvent event, Throwable cause) {
        return this.exceptionResolver.resolve(new MessagingException(event, cause), this.errorTypeLocator, this.exceptionContextProviders);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Objects.toString(this.source);
    }

    public class DefaultSourceCompletionHandler
    implements SourceCompletionHandler {
        private final SourceCallbackExecutor onSuccessExecutor;
        private final SourceCallbackExecutor onErrorExecutor;
        private final SourceCallbackContextAdapter context;
        private final SourceCallbackExecutor onTerminateExecutor;
        private final SourceCallbackExecutor onBackPressureExecutor;

        public DefaultSourceCompletionHandler(SourceCallbackExecutor onSuccessExecutor, SourceCallbackExecutor onErrorExecutor, SourceCallbackExecutor onTerminateExecutor, SourceCallbackExecutor onBackPressureExecutor, SourceCallbackContextAdapter context) {
            this.onSuccessExecutor = onSuccessExecutor;
            this.onErrorExecutor = onErrorExecutor;
            this.onTerminateExecutor = onTerminateExecutor;
            this.onBackPressureExecutor = onBackPressureExecutor;
            this.context = context;
        }

        @Override
        public void onCompletion(CoreEvent event, Map<String, Object> parameters, CompletableCallback<Void> callback) {
            if (this.context.getTransactionHandle().isTransacted()) {
                callback = callback.before(v -> this.commit());
            }
            this.onSuccessExecutor.execute(event, parameters, this.context, (CompletableCallback<Void>)callback);
        }

        @Override
        public void onFailure(MessagingException exception, Map<String, Object> parameters, CompletableCallback<Void> callback) {
            SourceCallbackExecutor executor;
            CoreEvent event = exception.getEvent();
            boolean isBackPressureError = event.getError().map(e -> SourceAdapter.this.flowBackPressueErrorType.equals(e.getErrorType())).orElse(false);
            boolean isRedeliveryExhaustedError = event.getError().map(e -> SourceAdapter.this.redeliveryExhaustedErrorType.equals(e.getErrorType())).orElse(false);
            if (isBackPressureError) {
                LOGGER.info("FLOW OVERLOAD - {}.", (Object)((Error)event.getError().get()).getCause().getMessage());
                executor = this.onBackPressureExecutor;
                parameters = Collections.emptyMap();
                this.context.addVariable("MULE_BACK_PRESSURE_ACTION_CONTEXT_PARAM", SourceAdapter.this.backPressureAction);
            } else {
                executor = this.onErrorExecutor;
            }
            if (this.context.getTransactionHandle().isTransacted()) {
                callback = isRedeliveryExhaustedError && COMMIT_ON_REDELIVERY != false ? callback.finallyBefore(this::commit) : callback.finallyBefore(this::rollback);
            }
            executor.execute(event, parameters, this.context, (CompletableCallback<Void>)callback);
        }

        @Override
        public void onTerminate(Either<MessagingException, CoreEvent> result) throws Exception {
            this.onTerminateExecutor.execute((CoreEvent)result.reduce(MessagingException::getEvent, (Function)Functions.identity()), Collections.emptyMap(), this.context, (CompletableCallback<Void>)CompletableCallback.always(this.context::releaseConnection));
        }

        private void commit() {
            try {
                this.context.getTransactionHandle().resolve();
            }
            catch (TransactionException e) {
                LOGGER.error(String.format("Failed to commit transaction for message source at '%s': %s", SourceAdapter.this.component.getLocation().toString(), e.getMessage()), (Throwable)e);
            }
        }

        private void rollback() {
            try {
                this.context.getTransactionHandle().rollback();
            }
            catch (TransactionException e) {
                LOGGER.error(String.format("Failed to rollback transaction for message source at '%s': %s", SourceAdapter.this.component.getLocation().toString(), e.getMessage()), (Throwable)e);
            }
        }

        @Override
        public Map<String, Object> createResponseParameters(CoreEvent event) throws MessagingException {
            ValueResolvingContext context = this.buildResolvingContext(event);
            try {
                Map<String, Object> map = SourceAdapter.this.successCallbackParameters.resolve(context).asMap();
                if (context != null) {
                    context.close();
                }
                return map;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw SourceAdapter.this.createSourceException(event, e);
                }
            }
        }

        @Override
        public Map<String, Object> createFailureResponseParameters(CoreEvent event) throws MessagingException {
            ResolverSet resolverSet = SourceAdapter.this.errorCallbackParameters;
            ValueResolvingContext ctx = this.buildResolvingContext(event);
            try {
                ResolverSetResult parameters = resolverSet.resolve(ctx);
                Map<String, Object> map = parameters.asMap();
                if (ctx != null) {
                    ctx.close();
                }
                return map;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw SourceAdapter.this.createSourceException(event, e);
                }
            }
        }

        private ValueResolvingContext buildResolvingContext(CoreEvent event) {
            return ValueResolvingContext.builder(event).withExpressionManager(SourceAdapter.this.expressionManager).withConfig(SourceAdapter.this.configurationInstance).resolveCursors(false).build();
        }
    }
}

