/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.security.tls;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.security.tls.RestrictedSSLServerSocketFactory;
import org.mule.runtime.core.internal.security.tls.RestrictedSSLSocketFactory;
import org.mule.runtime.core.internal.security.tls.TlsProperties;
import org.mule.runtime.core.internal.util.ArrayUtils;
import org.mule.runtime.core.internal.util.SecurityUtils;
import org.mule.runtime.core.privileged.security.RevocationCheck;
import org.mule.runtime.core.privileged.security.TlsDirectKeyStore;
import org.mule.runtime.core.privileged.security.TlsDirectTrustStore;
import org.mule.runtime.core.privileged.security.TlsIndirectKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TlsConfiguration
extends AbstractComponent
implements TlsDirectTrustStore,
TlsDirectKeyStore,
TlsIndirectKeyStore {
    public static final String DEFAULT_KEYSTORE = ".keystore";
    public static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    public static final String DEFAULT_KEYMANAGER_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_TRUSTMANAGER_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    public static final String REVOCATION_KEYSTORE_ALGORITHM = "PKIX";
    public static final String INVALID_CRL_ALGORITHM = "TLS Context: certificate revocation checking is only available for algorithm %s (current value is %s)";
    public static final String DEFAULT_SSL_TYPE = "TLS";
    public static final String JSSE_NAMESPACE = "javax.net";
    public static final String PROPERTIES_FILE_PATTERN = "tls-%s.conf";
    public static final String DEFAULT_SECURITY_MODEL = "default";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sslType;
    private String keyStoreName = ".keystore";
    private String keyAlias = null;
    private String keyPassword = null;
    private String keyStorePassword = null;
    private String keystoreType = DEFAULT_KEYSTORE_TYPE;
    private String keyManagerAlgorithm = DEFAULT_KEYMANAGER_ALGORITHM;
    private KeyManagerFactory keyManagerFactory = null;
    private String clientKeyStoreName = null;
    private String clientKeyStorePassword = null;
    private String clientKeyStoreType = DEFAULT_KEYSTORE_TYPE;
    private String trustStoreName = null;
    private String trustStorePassword = null;
    private String trustStoreType = DEFAULT_KEYSTORE_TYPE;
    private String trustManagerAlgorithm = DEFAULT_TRUSTMANAGER_ALGORITHM;
    private TrustManagerFactory trustManagerFactory = null;
    private boolean explicitTrustStoreOnly = false;
    private boolean requireClientAuthentication = false;
    private TlsProperties tlsProperties = new TlsProperties();
    private RevocationCheck revocationCheck = null;

    public TlsConfiguration(String keyStore) {
        this.keyStoreName = keyStore;
    }

    public void initialise(boolean anon, String namespace) throws CreateException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initialising: anon " + anon);
        }
        this.validate(anon);
        if (!anon) {
            this.initKeyManagerFactory();
        }
        this.initTrustManagerFactory();
        this.tlsProperties.load(String.format(PROPERTIES_FILE_PATTERN, SecurityUtils.getSecurityModel()));
        if (this.sslType == null) {
            this.sslType = this.resolveSslType();
        }
    }

    private String resolveSslType() {
        if (this.tlsProperties.getDefaultProtocol() != null) {
            return this.tlsProperties.getDefaultProtocol();
        }
        return DEFAULT_SSL_TYPE;
    }

    private void validate(boolean anon) throws CreateException {
        if (!anon) {
            Preconditions.checkArgument((this.getKeyStore() != null ? 1 : 0) != 0, (String)"The KeyStore location cannot be null");
            Preconditions.checkArgument((this.getKeyPassword() != null ? 1 : 0) != 0, (String)"The Key password cannot be null");
            Preconditions.checkArgument((this.getKeyStorePassword() != null ? 1 : 0) != 0, (String)"The KeyStore password cannot be null");
            Preconditions.checkArgument((this.getKeyManagerAlgorithm() != null ? 1 : 0) != 0, (String)"The Key Manager Algorithm cannot be null");
        }
    }

    private void initKeyManagerFactory() throws CreateException {
        KeyStore tempKeyStore;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initialising key manager factory from keystore data");
        }
        try {
            tempKeyStore = this.loadKeyStore();
            this.checkKeyStoreContainsKeyAlias(tempKeyStore);
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToLoad("KeyStore: " + this.keyStoreName), (Throwable)e, (Object)this);
        }
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm());
            this.keyManagerFactory.init(tempKeyStore, this.keyPassword.toCharArray());
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToLoad("Key Manager"), (Throwable)e, (Object)this);
        }
    }

    private KeyStore loadKeyStore() throws GeneralSecurityException, IOException {
        KeyStore tempKeyStore = KeyStore.getInstance(this.keystoreType);
        try (InputStream is = IOUtils.getResourceAsStream(this.keyStoreName, this.getClass());){
            if (null == is) {
                throw new FileNotFoundException(CoreMessages.cannotLoadFromClasspath("Keystore: " + this.keyStoreName).getMessage());
            }
            tempKeyStore.load(is, this.keyStorePassword.toCharArray());
            KeyStore keyStore = tempKeyStore;
            return keyStore;
        }
    }

    private void checkKeyStoreContainsKeyAlias(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        if (!StringUtils.isBlank(this.keyAlias)) {
            boolean aliasFound = false;
            for (String alias : Collections.list(aliases)) {
                if (alias.equals(this.keyAlias)) {
                    aliasFound = true;
                    if (keyStore.isKeyEntry(this.keyAlias)) continue;
                    throw new IllegalArgumentException("Keystore entry for alias '" + this.keyAlias + "' is not a key.");
                }
                keyStore.deleteEntry(alias);
            }
            if (!aliasFound) {
                throw new IllegalStateException("Key with alias \"" + this.keyAlias + "\" was not found");
            }
        } else {
            boolean hasKey = false;
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                hasKey = true;
                break;
            }
            if (!hasKey) {
                throw new IllegalArgumentException("No key entries found.");
            }
        }
    }

    private void initTrustManagerFactory() throws CreateException {
        if (null == this.trustStoreName && this.revocationCheck == null) {
            return;
        }
        Boolean revocationEnabled = this.revocationCheck != null;
        if (revocationEnabled.booleanValue() && !REVOCATION_KEYSTORE_ALGORITHM.equalsIgnoreCase(this.trustManagerAlgorithm)) {
            String errorText = TlsConfiguration.formatInvalidCrlAlgorithm(this.getTrustManagerAlgorithm());
            throw new CreateException(I18nMessageFactory.createStaticMessage((String)errorText), (Object)this);
        }
        try {
            KeyStore trustStore = this.trustStoreName != null ? this.createTrustStore() : null;
            this.trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            if (revocationEnabled.booleanValue()) {
                ManagerFactoryParameters tmfParams = this.revocationCheck.configFor(trustStore, TlsConfiguration.getDefaultCaCerts());
                this.trustManagerFactory.init(tmfParams);
            } else {
                this.trustManagerFactory.init(trustStore);
            }
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToLoad("Trust Manager (" + this.trustManagerAlgorithm + ")"), (Throwable)e, (Object)this);
        }
    }

    public static String formatInvalidCrlAlgorithm(String givenAlgorithm) {
        return String.format(INVALID_CRL_ALGORITHM, REVOCATION_KEYSTORE_ALGORITHM, givenAlgorithm);
    }

    private KeyStore createTrustStore() throws CreateException {
        KeyStore keyStore;
        block9: {
            this.trustStorePassword = null == this.trustStorePassword ? "" : this.trustStorePassword;
            InputStream is = IOUtils.getResourceAsStream(this.trustStoreName, this.getClass());
            try {
                KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                if (null == is) {
                    throw new FileNotFoundException("Failed to load truststore from classpath or local file: " + this.trustStoreName);
                }
                trustStore.load(is, this.trustStorePassword.toCharArray());
                keyStore = trustStore;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CreateException(CoreMessages.failedToLoad("TrustStore: " + this.trustStoreName), (Throwable)e, (Object)this);
                }
            }
            is.close();
        }
        return keyStore;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<TrustAnchor> getDefaultCaCerts() throws GeneralSecurityException {
        void var4_6;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        int n = trustManagerArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            TrustManager tm = trustManagerArray[var4_6];
            x509Certificates.addAll(Arrays.asList(((X509TrustManager)tm).getAcceptedIssuers()));
            ++var4_6;
        }
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (Certificate certificate : x509Certificates) {
            trustAnchors.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        return trustAnchors;
    }

    private static String defaultForNull(String value, String deflt) {
        if (null == value) {
            return deflt;
        }
        return value;
    }

    public SSLSocketFactory getSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        return new RestrictedSSLSocketFactory(this.getSslContext(), this.getEnabledCipherSuites(), this.getEnabledProtocols());
    }

    public SSLServerSocketFactory getServerSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        return new RestrictedSSLServerSocketFactory(this.getSslContext(), this.getEnabledCipherSuites(), this.getEnabledProtocols());
    }

    public String[] getEnabledCipherSuites() {
        return this.tlsProperties.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.tlsProperties.getEnabledProtocols();
    }

    public SSLContext getSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagers = null == this.getTrustManagerFactory() ? null : this.getTrustManagerFactory().getTrustManagers();
        return this.getSslContext(trustManagers);
    }

    public SSLContext getSslContext(TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        KeyManager[] keyManagers = null == this.getKeyManagerFactory() ? null : this.getKeyManagerFactory().getKeyManagers();
        SSLContext context = SSLContext.getInstance(this.getSslType());
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    public String getSslType() {
        return this.sslType;
    }

    public void setSslType(String sslType) {
        Object[] enabledProtocols = this.tlsProperties.getEnabledProtocols();
        if (enabledProtocols != null && !ArrayUtils.contains((Object[])enabledProtocols, (Object)sslType)) {
            throw new IllegalArgumentException(String.format("Protocol %s is not allowed in current configuration", sslType));
        }
        this.sslType = sslType;
    }

    @Override
    public String getKeyStore() {
        return this.keyStoreName;
    }

    @Override
    public void setKeyStore(String name) throws IOException {
        this.keyStoreName = name;
        if (null != this.keyStoreName) {
            this.keyStoreName = FileUtils.getResourcePath(this.keyStoreName, this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Normalised keyStore path to: " + this.keyStoreName);
            }
        }
    }

    @Override
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public void setKeyStorePassword(String storePassword) {
        this.keyStorePassword = storePassword;
    }

    @Override
    public String getKeyStoreType() {
        return this.keystoreType;
    }

    @Override
    public void setKeyStoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    @Override
    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    @Override
    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    @Override
    public String getClientKeyStore() {
        return this.clientKeyStoreName;
    }

    @Override
    public void setClientKeyStore(String name) throws IOException {
        this.clientKeyStoreName = name;
        if (null != this.clientKeyStoreName) {
            this.clientKeyStoreName = FileUtils.getResourcePath(this.clientKeyStoreName, this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Normalised clientKeyStore path to: " + this.clientKeyStoreName);
            }
        }
    }

    @Override
    public String getClientKeyStorePassword() {
        return this.clientKeyStorePassword;
    }

    @Override
    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    @Override
    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.clientKeyStoreType = clientKeyStoreType;
    }

    @Override
    public String getClientKeyStoreType() {
        return this.clientKeyStoreType;
    }

    @Override
    public String getTrustStore() {
        return this.trustStoreName;
    }

    @Override
    public void setTrustStore(String name) throws IOException {
        this.trustStoreName = name;
        if (null != this.trustStoreName) {
            this.trustStoreName = FileUtils.getResourcePath(this.trustStoreName, this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Normalised trustStore path to: " + this.trustStoreName);
            }
        }
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Override
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Override
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @Override
    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    @Override
    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = TlsConfiguration.defaultForNull(trustManagerAlgorithm, DEFAULT_TRUSTMANAGER_ALGORITHM);
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    @Override
    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }

    @Override
    public boolean isExplicitTrustStoreOnly() {
        return this.explicitTrustStoreOnly;
    }

    @Override
    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.explicitTrustStoreOnly = explicitTrustStoreOnly;
    }

    @Override
    public boolean isRequireClientAuthentication() {
        return this.requireClientAuthentication;
    }

    @Override
    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.requireClientAuthentication = requireClientAuthentication;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setRevocationCheck(RevocationCheck revocationCheck) {
        this.revocationCheck = revocationCheck;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TlsConfiguration)) {
            return false;
        }
        TlsConfiguration that = (TlsConfiguration)o;
        if (this.explicitTrustStoreOnly != that.explicitTrustStoreOnly) {
            return false;
        }
        if (this.requireClientAuthentication != that.requireClientAuthentication) {
            return false;
        }
        if (this.clientKeyStoreName != null ? !this.clientKeyStoreName.equals(that.clientKeyStoreName) : that.clientKeyStoreName != null) {
            return false;
        }
        if (this.clientKeyStorePassword != null ? !this.clientKeyStorePassword.equals(that.clientKeyStorePassword) : that.clientKeyStorePassword != null) {
            return false;
        }
        if (this.clientKeyStoreType != null ? !this.clientKeyStoreType.equals(that.clientKeyStoreType) : that.clientKeyStoreType != null) {
            return false;
        }
        if (this.keyAlias != null ? !this.keyAlias.equals(that.keyAlias) : that.keyAlias != null) {
            return false;
        }
        if (this.keyManagerAlgorithm != null ? !this.keyManagerAlgorithm.equals(that.keyManagerAlgorithm) : that.keyManagerAlgorithm != null) {
            return false;
        }
        if (this.keyManagerFactory != null ? !this.keyManagerFactory.equals(that.keyManagerFactory) : that.keyManagerFactory != null) {
            return false;
        }
        if (this.keyPassword != null ? !this.keyPassword.equals(that.keyPassword) : that.keyPassword != null) {
            return false;
        }
        if (this.keyStoreName != null ? !this.keyStoreName.equals(that.keyStoreName) : that.keyStoreName != null) {
            return false;
        }
        if (this.keyStorePassword != null ? !this.keyStorePassword.equals(that.keyStorePassword) : that.keyStorePassword != null) {
            return false;
        }
        if (this.keystoreType != null ? !this.keystoreType.equals(that.keystoreType) : that.keystoreType != null) {
            return false;
        }
        if (this.sslType != null ? !this.sslType.equals(that.sslType) : that.sslType != null) {
            return false;
        }
        if (this.tlsProperties != null ? !this.tlsProperties.equals(that.tlsProperties) : that.tlsProperties != null) {
            return false;
        }
        if (this.trustManagerAlgorithm != null ? !this.trustManagerAlgorithm.equals(that.trustManagerAlgorithm) : that.trustManagerAlgorithm != null) {
            return false;
        }
        if (this.trustManagerFactory != null ? !this.trustManagerFactory.equals(that.trustManagerFactory) : that.trustManagerFactory != null) {
            return false;
        }
        if (this.trustStoreName != null ? !this.trustStoreName.equals(that.trustStoreName) : that.trustStoreName != null) {
            return false;
        }
        if (this.trustStorePassword != null ? !this.trustStorePassword.equals(that.trustStorePassword) : that.trustStorePassword != null) {
            return false;
        }
        if (this.trustStoreType != null ? !this.trustStoreType.equals(that.trustStoreType) : that.trustStoreType != null) {
            return false;
        }
        return !(this.revocationCheck != null ? !this.revocationCheck.equals(that.revocationCheck) : that.revocationCheck != null);
    }

    public int hashCode() {
        int result = this.sslType != null ? this.sslType.hashCode() : 0;
        int hashcodePrimeNumber = 31;
        result = hashcodePrimeNumber * result + (this.keyStoreName != null ? this.keyStoreName.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.keyAlias != null ? this.keyAlias.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.keyStorePassword != null ? this.keyStorePassword.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.keystoreType != null ? this.keystoreType.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.keyManagerAlgorithm != null ? this.keyManagerAlgorithm.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.keyManagerFactory != null ? this.keyManagerFactory.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.clientKeyStoreName != null ? this.clientKeyStoreName.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.clientKeyStorePassword != null ? this.clientKeyStorePassword.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.clientKeyStoreType != null ? this.clientKeyStoreType.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.trustStoreName != null ? this.trustStoreName.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.trustStorePassword != null ? this.trustStorePassword.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.trustStoreType != null ? this.trustStoreType.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.trustManagerAlgorithm != null ? this.trustManagerAlgorithm.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.trustManagerFactory != null ? this.trustManagerFactory.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.explicitTrustStoreOnly ? 1 : 0);
        result = hashcodePrimeNumber * result + (this.requireClientAuthentication ? 1 : 0);
        result = hashcodePrimeNumber * result + (this.tlsProperties != null ? this.tlsProperties.hashCode() : 0);
        result = hashcodePrimeNumber * result + (this.revocationCheck != null ? this.revocationCheck.hashCode() : 0);
        return result;
    }
}

