/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.routing.AbstractForkJoinRouter;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.RoutingUtils;
import org.mule.runtime.core.internal.routing.forkjoin.CollectMapForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.profiling.tracing.ComponentTracerAware;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ScatterGatherRouter
extends AbstractForkJoinRouter
implements Router {
    public static final String SCATTER_GATHER_ROUTE_SPAN_NAME_SUFFIX = ":route";
    private List<MessageProcessorChain> routes = Collections.emptyList();
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    @Inject
    private FeatureFlaggingService featureFlaggingService;

    @Override
    protected Consumer<CoreEvent> onEvent() {
        return event -> ScatterGatherRouter.validateMessageIsNotConsumable(event.getMessage());
    }

    @Override
    protected Publisher<ForkJoinStrategy.RoutingPair> getRoutingPairs(CoreEvent event) {
        return Flux.fromIterable(this.routes).map(route -> ForkJoinStrategy.RoutingPair.of(this.eventForRoute(event), route));
    }

    private CoreEvent eventForRoute(CoreEvent event) {
        if (!(event instanceof InternalEvent)) {
            return event;
        }
        InternalEvent copy = (InternalEvent)CoreEvent.builder((CoreEvent)event).message(event.getMessage()).build();
        RoutingUtils.setSourcePolicyChildContext(copy, this.featureFlaggingService);
        return copy;
    }

    protected List<MessageProcessorChain> getOwnedObjects() {
        return this.routes;
    }

    public void setRoutes(List<MessageProcessorChain> routes) {
        this.routes = routes;
        for (MessageProcessorChain route : routes) {
            if (!(route instanceof ComponentTracerAware)) continue;
            ((ComponentTracerAware)route).setComponentTracer(this.componentTracerFactory.fromComponent((Component)this, SCATTER_GATHER_ROUTE_SPAN_NAME_SUFFIX));
        }
    }

    @Override
    protected boolean isDelayErrors() {
        return true;
    }

    @Override
    protected int getDefaultMaxConcurrency() {
        return this.routes.size();
    }

    @Override
    protected ForkJoinStrategyFactory getDefaultForkJoinStrategyFactory() {
        return new CollectMapForkJoinStrategyFactory();
    }

    public static void validateMessageIsNotConsumable(Message message) {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new MuleRuntimeException(CoreMessages.cannotCopyStreamPayload((String)message.getPayload().getDataType().getType().getName()));
        }
    }
}

