/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.internal.util.StandaloneServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarUtils {
    private static final String MULE_MODULE_FILENAME = "lib" + File.separator + "module";
    private static final String MULE_LIB_FILENAME = "lib" + File.separator + "mule";
    private static final String MULE_HOME = StandaloneServerUtils.getMuleHome().map(File::getAbsolutePath).orElse(null);
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";
    private static final Logger logger = LoggerFactory.getLogger(JarUtils.class);

    private JarUtils() {
    }

    public static URL getUrlWithinJar(File jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toURI().toString() + "!/" + filePath);
    }

    public static List<URL> getUrlsWithinJar(File file, String directory) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(directory + "/")) continue;
                urls.add(JarUtils.getUrlWithinJar(file, jarEntry.getName()));
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap readJarFileEntries(File jarFile) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        JarFile jarFileWrapper = null;
        if (jarFile != null) {
            logger.debug("Reading jar entries from " + jarFile.getAbsolutePath());
            try {
                jarFileWrapper = new JarFile(jarFile);
                Enumeration<JarEntry> iter = jarFileWrapper.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    InputStream entryStream = jarFileWrapper.getInputStream(zipEntry);
                    try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                        IOUtils.copy((InputStream)entryStream, (OutputStream)byteArrayStream);
                        entries.put(zipEntry.getName(), byteArrayStream.toByteArray());
                        logger.debug("Read jar entry " + zipEntry.getName() + " from " + jarFile.getAbsolutePath());
                    }
                }
            }
            finally {
                if (jarFileWrapper != null) {
                    try {
                        jarFileWrapper.close();
                    }
                    catch (Exception ignore) {
                        logger.debug("Error closing jar file", (Throwable)ignore);
                    }
                }
            }
        }
        return entries;
    }

    public static void appendJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        if (entries != null) {
            LinkedHashMap combinedEntries = JarUtils.readJarFileEntries(jarFile);
            combinedEntries.putAll(entries);
            File tmpJarFile = Files.createTempFile(jarFile.getName(), null, new FileAttribute[0]).toFile();
            JarUtils.createJarFileEntries(tmpJarFile, combinedEntries);
            jarFile.delete();
            FileUtils.renameFile(tmpJarFile, jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        ZipOutputStream jarStream = null;
        FileOutputStream fileStream = null;
        if (jarFile != null) {
            logger.debug("Creating jar file " + jarFile.getAbsolutePath());
            try {
                fileStream = new FileOutputStream(jarFile);
                jarStream = new JarOutputStream(fileStream);
                if (entries != null && !entries.isEmpty()) {
                    for (String jarFilePath : entries.keySet()) {
                        Object content = entries.get(jarFilePath);
                        JarEntry entry = new JarEntry(jarFilePath);
                        ((JarOutputStream)jarStream).putNextEntry(entry);
                        logger.debug("Adding jar entry " + jarFilePath + " to " + jarFile.getAbsolutePath());
                        if (content instanceof String) {
                            JarUtils.writeJarEntry((OutputStream)jarStream, ((String)content).getBytes());
                            continue;
                        }
                        if (content instanceof byte[]) {
                            JarUtils.writeJarEntry((OutputStream)jarStream, (byte[])content);
                            continue;
                        }
                        if (!(content instanceof File)) continue;
                        JarUtils.writeJarEntry((OutputStream)jarStream, (File)content);
                    }
                }
                jarStream.flush();
                fileStream.getFD().sync();
            }
            finally {
                if (jarStream != null) {
                    try {
                        jarStream.close();
                    }
                    catch (Exception jarNotClosed) {
                        logger.debug("Error closing jar file", (Throwable)jarNotClosed);
                    }
                }
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (Exception fileNotClosed) {
                        logger.debug("Error closing file", (Throwable)fileNotClosed);
                    }
                }
            }
        }
    }

    private static void writeJarEntry(OutputStream stream, byte[] entry) throws IOException {
        stream.write(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJarEntry(OutputStream stream, File entry) throws IOException {
        FileInputStream fileContentStream = null;
        try {
            fileContentStream = new FileInputStream(entry);
            IOUtils.copy((InputStream)fileContentStream, (OutputStream)stream);
        }
        finally {
            if (fileContentStream != null) {
                try {
                    fileContentStream.close();
                }
                catch (Exception fileContentNotClosed) {
                    logger.debug("Error closing file", (Throwable)fileContentNotClosed);
                }
            }
        }
    }

    public static File getMuleHomeFile() {
        return new File(MULE_HOME);
    }

    public static File getMuleLibDir() {
        return new File(MULE_HOME + File.separator + MULE_LIB_FILENAME);
    }

    public static File getMuleModuleDir() {
        return new File(MULE_HOME + File.separator + MULE_MODULE_FILENAME);
    }

    public static File getMuleLocalJarFile() {
        return new File(JarUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME);
    }
}

