/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;

public class LazyServiceAssembly
implements ServiceAssembly {
    private final String name;
    private final LazyValue<ClassLoader> classLoader;
    private final LazyValue<ServiceProvider> serviceProvider;
    private final Class<? extends Service> serviceContract;

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    private LazyServiceAssembly(String name, Supplier<ClassLoader> classLoader, Supplier<ServiceProvider> serviceProvider, Class<? extends Service> satisfiedContract) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)name) ? 1 : 0) != 0, (String)"name cannot be blank");
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"Classloader cannot be null");
        Preconditions.checkArgument((serviceProvider != null ? 1 : 0) != 0, (String)"ServiceProvider supplier cannot be null");
        Preconditions.checkArgument((satisfiedContract != null ? 1 : 0) != 0, (String)"satisfied contract cannot be null");
        this.name = name;
        this.classLoader = this.lazy(classLoader);
        this.serviceProvider = this.lazy(serviceProvider);
        this.serviceContract = satisfiedContract;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return (ServiceProvider)this.serviceProvider.get();
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    @Override
    public Class<? extends Service> getServiceContract() {
        return this.serviceContract;
    }

    private <T> LazyValue<T> lazy(Supplier<T> supplier) {
        if (supplier instanceof LazyValue) {
            return (LazyValue)supplier;
        }
        return new LazyValue(supplier);
    }

    public static class Builder
    implements ServiceAssembly.ServiceAssemblyBuilder {
        private String name;
        private Supplier<ClassLoader> artifactClassLoader;
        private Supplier<ServiceProvider> serviceProviderSupplier;
        private String contractClassName;

        private Builder() {
        }

        @Override
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder withClassLoader(Supplier<ClassLoader> artifactClassLoader) {
            this.artifactClassLoader = artifactClassLoader;
            return this;
        }

        @Override
        public Builder withServiceProvider(CheckedSupplier<ServiceProvider> serviceProviderSupplier) {
            this.serviceProviderSupplier = serviceProviderSupplier;
            return this;
        }

        @Override
        public Builder forContract(String contractClassName) {
            this.contractClassName = contractClassName;
            return this;
        }

        @Override
        public ServiceAssembly build() throws ServiceResolutionError {
            try {
                return new LazyServiceAssembly(this.name, this.artifactClassLoader, this.serviceProviderSupplier, this.resolveContract());
            }
            catch (Exception e) {
                throw new ServiceResolutionError("Could not load service " + this.name, e);
            }
        }

        private Class<? extends Service> resolveContract() {
            try {
                return ClassUtils.loadClass((String)this.contractClassName, FileSystemServiceProviderDiscoverer.class);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }
}

