/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;

public class MavenUtilsForArtifact {
    public static Properties getPomPropertiesFolder(File artifactFolder) {
        Properties properties;
        File artifactPomProperties = MavenUtilsForArtifact.lookupPomPropertiesMavenLocation(artifactFolder);
        try (FileInputStream artifactPomPropertiesInputStream = new FileInputStream(artifactPomProperties);){
            properties = PropertiesUtils.loadProperties((InputStream)artifactPomPropertiesInputStream);
        }
        catch (IOException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", artifactPomProperties.getName(), artifactFolder.getAbsolutePath()), (Throwable)e);
        }
        return properties;
    }

    public static File lookupPomPropertiesMavenLocation(File artifactFolder) {
        NameFileFilter fileFilter;
        Collection potentialLocations;
        File mulePropertiesPom = null;
        File dir = new File(artifactFolder, "META-INF" + File.separator + "maven");
        if (dir != null && dir.exists() && !(potentialLocations = FileUtils.listFiles((File)dir, (IOFileFilter)(fileFilter = new NameFileFilter("pom.properties")), (IOFileFilter)TrueFileFilter.INSTANCE)).isEmpty()) {
            mulePropertiesPom = (File)potentialLocations.stream().findFirst().get();
        }
        if (mulePropertiesPom == null || !mulePropertiesPom.exists()) {
            throw new ArtifactDescriptorCreateException(String.format("The Maven bundle loader requires the file pom.properties (error found while reading artifact '%s')", artifactFolder.getName()));
        }
        return mulePropertiesPom;
    }
}

