/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.internal.ExtensionDevelopmentFramework;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.XmlDslConfiguration;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.mule.internal.dsl.MuleSdkDslConstants;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkErrorsDeclarationParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkExtensionModelParser;

public class MuleSdkPluginExtensionModelParser
extends MuleSdkExtensionModelParser {
    private static final String MIN_MULE_VERSION = "4.5";
    private String name;
    private Category category;
    private String vendor;
    private String namespace;
    private Optional<XmlDslConfiguration> xmlDslConfiguration;
    private LicenseModelProperty licenseModelProperty;
    private List<ErrorModelParser> errorModelParsers;

    public MuleSdkPluginExtensionModelParser(ArtifactAst ast, TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        super(typeLoader, extensionModelHelper);
        this.init(ast);
    }

    @Override
    protected void init(ArtifactAst ast) {
        this.parseStructure(ast);
        super.init(ast);
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getVendor() {
        return this.vendor;
    }

    public Optional<XmlDslConfiguration> getXmlDslConfiguration() {
        return this.xmlDslConfiguration;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Optional<ResolvedMinMuleVersion> getResolvedMinMuleVersion() {
        return Optional.of(new ResolvedMinMuleVersion(this.name, new MuleVersion(MIN_MULE_VERSION), String.format("Plugin %s has min mule version %s because the Mule Sdk was introduced in that version.", this.name, MIN_MULE_VERSION)));
    }

    public LicenseModelProperty getLicenseModelProperty() {
        return this.licenseModelProperty;
    }

    public ExtensionDevelopmentFramework getDevelopmentFramework() {
        return ExtensionDevelopmentFramework.MULE_SDK;
    }

    @Override
    protected Stream<ComponentAst> getTopLevelElements(ArtifactAst ast) {
        return ast.topLevelComponentsStream();
    }

    private void parseStructure(ArtifactAst ast) {
        ComponentAst descriptionComponentAst = this.getRequiredTopLevelComponent(ast, MuleSdkDslConstants.MULE_SDK_EXTENSION_DESCRIPTION_IDENTIFIER);
        this.name = (String)this.getParameter(descriptionComponentAst, "name");
        this.category = Category.valueOf((String)((String)this.getParameter(descriptionComponentAst, "category")).toUpperCase());
        this.vendor = (String)this.getParameter(descriptionComponentAst, "vendor");
        this.parseXmlDslConfiguration(descriptionComponentAst);
        this.parseLicenseModelProperty(descriptionComponentAst);
        this.namespace = ExtensionNamespaceUtils.getExtensionsNamespace((XmlDslModel)ModelLoaderUtils.getXmlDslModel((String)this.name, (String)"1.0.0", this.xmlDslConfiguration));
        this.parseErrorsDeclaration(ast);
    }

    private void parseErrorsDeclaration(ArtifactAst ast) {
        this.errorModelParsers = new ArrayList<ErrorModelParser>(new MuleSdkErrorsDeclarationParser(ast, this.namespace.toUpperCase(Locale.getDefault())).parse().values());
    }

    @Override
    public List<ErrorModelParser> getErrorModelParsers() {
        return this.errorModelParsers;
    }

    private void parseXmlDslConfiguration(ComponentAst descriptionComponentAst) {
        this.xmlDslConfiguration = this.getSingleChild(descriptionComponentAst, "xml-dsl-attributes").map(xmlDslAttributesComponentAst -> {
            Optional<String> prefix = this.getOptionalParameter((ComponentAst)xmlDslAttributesComponentAst, "prefix");
            Optional<String> namespace = this.getOptionalParameter((ComponentAst)xmlDslAttributesComponentAst, "namespace");
            if (prefix.isPresent() || namespace.isPresent()) {
                return Optional.of(new XmlDslConfiguration(prefix.orElse(""), namespace.orElse("")));
            }
            return Optional.empty();
        }).orElse(Optional.empty());
    }

    private void parseLicenseModelProperty(ComponentAst descriptionComponentAst) {
        this.licenseModelProperty = this.getSingleChild(descriptionComponentAst, "licensing").map(licensingComponentAst -> {
            boolean requiresEeLicense = (Boolean)this.getParameter((ComponentAst)licensingComponentAst, "requiresEnterpriseLicense");
            boolean allowsEvaluationLicense = (Boolean)this.getParameter((ComponentAst)licensingComponentAst, "allowsEvaluationLicense");
            Optional requiredEntitlement = this.getOptionalParameter((ComponentAst)licensingComponentAst, "requiredEntitlement");
            return new LicenseModelProperty(requiresEeLicense, allowsEvaluationLicense, requiredEntitlement);
        }).orElse(new LicenseModelProperty(false, true, Optional.empty()));
    }
}

