/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser;

import com.ibm.wsdl.extensions.schema.SchemaSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.mule.wsdl.parser.WsdlLocator;
import org.mule.wsdl.parser.WsdlSchemasCollector;
import org.mule.wsdl.parser.exception.WsdlParsingException;
import org.mule.wsdl.parser.locator.NullResourceLocator;
import org.mule.wsdl.parser.locator.ResourceLocator;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.SoapBinding;
import org.mule.wsdl.parser.model.Version;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.WsdlStyle;
import org.mule.wsdl.parser.model.WsdlStyleFinder;
import org.mule.wsdl.parser.model.operation.OperationModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/mule/wsdl/parser/WsdlParser;", "", "wsdlLocator", "Ljavax/wsdl/xml/WSDLLocator;", "charset", "", "(Ljavax/wsdl/xml/WSDLLocator;Ljava/lang/String;)V", "definition", "Ljavax/wsdl/Definition;", "wsdl", "Lorg/mule/wsdl/parser/model/WsdlModel;", "findPortBinding", "Lorg/mule/wsdl/parser/model/SoapBinding;", "p", "Ljavax/wsdl/Port;", "findSoapAddress", "port", "initExtensionRegistry", "Ljavax/wsdl/extensions/ExtensionRegistry;", "factory", "Ljavax/wsdl/factory/WSDLFactory;", "parseOperations", "", "Lorg/mule/wsdl/parser/model/operation/OperationModel;", "parsePorts", "Lorg/mule/wsdl/parser/model/PortModel;", "service", "Ljavax/wsdl/Service;", "parseServices", "Lorg/mule/wsdl/parser/model/ServiceModel;", "parseWsdl", "Companion", "mule-wsdl-parser"})
@SourceDebugExtension(value={"SMAP\nWsdlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WsdlParser.kt\norg/mule/wsdl/parser/WsdlParser\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n125#2:103\n152#2,3:104\n125#2:111\n152#2,3:112\n1549#3:107\n1620#3,3:108\n1549#3:115\n1620#3,3:116\n1549#3:119\n1620#3,3:120\n1549#3:123\n1620#3,3:124\n766#3:127\n857#3,2:128\n1549#3:130\n1620#3,3:131\n*S KotlinDebug\n*F\n+ 1 WsdlParser.kt\norg/mule/wsdl/parser/WsdlParser\n*L\n28#1:103\n28#1:104,3\n32#1:111\n32#1:112,3\n29#1:107\n29#1:108,3\n33#1:115\n33#1:116,3\n36#1:119\n36#1:120,3\n37#1:123\n37#1:124,3\n81#1:127\n81#1:128,2\n82#1:130\n82#1:131,3\n*E\n"})
public final class WsdlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Definition definition;
    @NotNull
    private final WsdlModel wsdl;

    private WsdlParser(WSDLLocator wsdlLocator, String charset) {
        this.definition = this.parseWsdl(wsdlLocator);
        String string = wsdlLocator.getBaseURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wsdlLocator.baseURI");
        this.wsdl = new WsdlModel(string, this.parseServices(this.definition), new WsdlSchemasCollector(this.definition, charset), this.definition);
    }

    /* synthetic */ WsdlParser(WSDLLocator wSDLLocator, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "UTF-8";
        }
        this(wSDLLocator, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServiceModel> parseServices(Definition definition) {
        Collection collection;
        Service service;
        Service item$iv$iv;
        Object $this$mapTo$iv$iv;
        Map map = definition.getServices();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"definition.services");
        Object $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            service = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Object v = service.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type javax.wsdl.Service");
            collection.add((Service)v);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void s;
            item$iv$iv = iterator.next();
            service = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = s.getQName().getLocalPart();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s.qName.localPart");
            QName qName = s.getQName();
            Intrinsics.checkNotNullExpressionValue((Object)qName, (String)"s.qName");
            collection.add(new ServiceModel(string, qName, this.parsePorts((Service)s)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PortModel> parsePorts(Service service) {
        Collection collection;
        Port port;
        Port item$iv$iv;
        Object $this$mapTo$iv$iv;
        Map map = service.getPorts();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"service.ports");
        Object $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            port = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Object v = port.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type javax.wsdl.Port");
            collection.add((Port)v);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p;
            item$iv$iv = iterator.next();
            port = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = p.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"p.name");
            collection.add(new PortModel(string, this.parseOperations((Port)p), this.findSoapAddress((Port)p), this.findPortBinding((Port)p)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OperationModel> parseOperations(Port port) {
        BindingOperation v;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List list = port.getBinding().getBindingOperations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"port.binding.bindingOperations");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type javax.wsdl.BindingOperation");
            collection.add((BindingOperation)v);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bop;
            v = (BindingOperation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = bop.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bop.name");
            collection.add(new OperationModel(string, (BindingOperation)bop));
        }
        return (List)destination$iv$iv;
    }

    private final Definition parseWsdl(WSDLLocator wsdlLocator) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"factory");
            ExtensionRegistry registry = this.initExtensionRegistry(factory);
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            wsdlReader.setExtensionRegistry(registry);
            Definition definition = wsdlReader.readWSDL(wsdlLocator);
            Intrinsics.checkNotNullExpressionValue((Object)definition, (String)"wsdlReader.readWSDL(wsdlLocator)");
            return definition;
        }
        catch (WSDLException e) {
            String string = e.getMessage();
            if (string == null || (string = StringsKt.replace$default((String)string, (String)"WSDLException:", (String)"", (boolean)false, (int)4, null)) == null || (string = StringsKt.replace$default((String)string, (String)"faultCode=OTHER_ERROR:", (String)"", (boolean)false, (int)4, null)) == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                string = "UNKNOWN";
            }
            String msg = string;
            throw new WsdlParsingException("Error processing WSDL file [" + wsdlLocator.getBaseURI() + "]: " + msg, e);
        }
    }

    private final ExtensionRegistry initExtensionRegistry(WSDLFactory factory) {
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        registry.registerSerializer(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"), (ExtensionSerializer)new SchemaSerializer());
        QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
        registry.registerDeserializer(MIMEPart.class, header, registry.queryDeserializer(BindingInput.class, header));
        registry.registerSerializer(MIMEPart.class, header, registry.querySerializer(BindingInput.class, header));
        Class<?> clazz = registry.createExtension(BindingInput.class, header).getClass();
        registry.mapExtensionTypes(MIMEPart.class, header, clazz);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registry");
        return registry;
    }

    private final String findSoapAddress(Port port) {
        for (Object element : port.getExtensibilityElements()) {
            if (element instanceof SOAPAddress) {
                return ((SOAPAddress)element).getLocationURI();
            }
            if (element instanceof SOAP12Address) {
                return ((SOAP12Address)element).getLocationURI();
            }
            if (!(element instanceof HTTPAddress)) continue;
            return ((HTTPAddress)element).getLocationURI();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final SoapBinding findPortBinding(Port p) {
        void $this$mapTo$iv$iv;
        Object e;
        Iterable $this$filterTo$iv$iv;
        List list = p.getBinding().getExtensibilityElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"p.binding.extensibilityElements");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            e = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(e instanceof SOAP12Binding || e instanceof SOAPBinding)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            SoapBinding soapBinding;
            String style;
            Object item$iv$iv;
            e = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (e instanceof SOAP12Binding) {
                style = ((SOAP12Binding)e).getStyle();
                if (style != null) {
                    WsdlStyle wsdlStyle = WsdlStyleFinder.INSTANCE.find(style);
                    String string = ((SOAP12Binding)e).getTransportURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.transportURI");
                    soapBinding = new SoapBinding(Version.V1_2, wsdlStyle, string);
                } else {
                    soapBinding = null;
                }
            } else {
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type javax.wsdl.extensions.soap.SOAPBinding");
                style = ((SOAPBinding)e).getStyle();
                if (style != null) {
                    WsdlStyle wsdlStyle = WsdlStyleFinder.INSTANCE.find(style);
                    String string = ((SOAPBinding)e).getTransportURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.transportURI");
                    soapBinding = new SoapBinding(Version.V1_1, wsdlStyle, string);
                } else {
                    soapBinding = null;
                }
            }
            collection.add(soapBinding);
        }
        return (SoapBinding)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public /* synthetic */ WsdlParser(WSDLLocator wsdlLocator, String charset, DefaultConstructorMarker $constructor_marker) {
        this(wsdlLocator, charset);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/mule/wsdl/parser/WsdlParser$Companion;", "", "()V", "parse", "Lorg/mule/wsdl/parser/model/WsdlModel;", "wsdlLocation", "", "charset", "locator", "Lorg/mule/wsdl/parser/locator/ResourceLocator;", "mule-wsdl-parser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WsdlModel parse(@NotNull String wsdlLocation) {
            Intrinsics.checkNotNullParameter((Object)wsdlLocation, (String)"wsdlLocation");
            return new WsdlParser(new WsdlLocator(wsdlLocation, new NullResourceLocator()), null, 2, null).wsdl;
        }

        @NotNull
        public final WsdlModel parse(@NotNull String wsdlLocation, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)wsdlLocation, (String)"wsdlLocation");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return new WsdlParser(new WsdlLocator(wsdlLocation, new NullResourceLocator()), charset, null).wsdl;
        }

        @NotNull
        public final WsdlModel parse(@NotNull String wsdlLocation, @NotNull ResourceLocator locator) {
            Intrinsics.checkNotNullParameter((Object)wsdlLocation, (String)"wsdlLocation");
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            return new WsdlParser(new WsdlLocator(wsdlLocation, locator), null, 2, null).wsdl;
        }

        @NotNull
        public final WsdlModel parse(@NotNull String wsdlLocation, @NotNull ResourceLocator locator, @NotNull String charset) {
            Intrinsics.checkNotNullParameter((Object)wsdlLocation, (String)"wsdlLocation");
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return new WsdlParser(new WsdlLocator(wsdlLocation, locator), charset, null).wsdl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

